/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.demo.pojo.client;

import io.servicecomb.core.CseContext;
import io.servicecomb.core.provider.consumer.InvokerUtils;
import io.servicecomb.demo.DemoConst;
import io.servicecomb.demo.TestMgr;
import io.servicecomb.demo.server.Test;
import io.servicecomb.demo.server.TestRequest;
import io.servicecomb.demo.server.User;
import io.servicecomb.provider.pojo.RpcReference;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PojoClientTest {
    private static Logger LOGGER = LoggerFactory.getLogger(PojoClientTest.class);
    @RpcReference(microserviceName="pojo")
    public static Test test;
    public static Test testFromXml;
    public static final byte[] buffer;

    public static void setTestFromXml(Test testFromXml) {
        PojoClientTest.testFromXml = testFromXml;
    }

    public static void runTest() throws Exception {
        String microserviceName = "pojo";
        for (String transport : DemoConst.transports) {
            CseContext.getInstance().getConsumerProviderManager().setTransport(microserviceName, transport);
            TestMgr.setMsg(microserviceName, transport);
            LOGGER.info("test {}, transport {}", (Object)microserviceName, (Object)transport);
            PojoClientTest.testNull(testFromXml);
            PojoClientTest.testNull(test);
            PojoClientTest.testEmpty(test);
            PojoClientTest.testStringArray(test);
            PojoClientTest.testChinese(test);
            PojoClientTest.testStringHaveSpace(test);
            PojoClientTest.testWrapParam(test);
            PojoClientTest.testSplitParam(test);
            PojoClientTest.testInputArray(test);
            PojoClientTest.testCommonInvoke(transport);
        }
        TestMgr.summary();
    }

    private static void testInputArray(Test test) {
        String result = test.addString(new String[]{"a", "b"});
        LOGGER.info("input array result:{}", (Object)result);
        TestMgr.check("[a, b]", result);
    }

    private static void testSplitParam(Test test) {
        User result = test.splitParam(1, new User());
        LOGGER.info("split param result:{}", (Object)result);
        TestMgr.check("User [name=nameA,  users count:0, age=100, index=1]", result);
    }

    private static void testCommonInvoke(String transport) {
        Object result = InvokerUtils.syncInvoke((String)"pojo", (String)"server", (String)"splitParam", (Object[])new Object[]{2, new User()});
        TestMgr.check("User [name=nameA,  users count:0, age=100, index=2]", result);
        result = InvokerUtils.syncInvoke((String)"pojo", (String)"0.0.1", (String)transport, (String)"server", (String)"splitParam", (Object[])new Object[]{3, new User()});
        TestMgr.check("User [name=nameA,  users count:0, age=100, index=3]", result);
    }

    private static void testEmpty(Test test) {
        TestMgr.check("code is ''", test.getTestString(""));
    }

    private static void testNull(Test test) {
        TestMgr.check("code is 'null'", test.getTestString(null));
        TestMgr.check(null, test.wrapParam(null));
    }

    private static void testChinese(Test test) {
        TestMgr.check("code is '\u6d4b\u8bd5'", test.getTestString("\u6d4b\u8bd5"));
        User user = new User();
        user.setName("\u540d\u5b57");
        User result = test.splitParam(1, user);
        TestMgr.check("\u540d\u5b57,  users count:0", result.getName());
    }

    private static void testStringHaveSpace(Test test) {
        TestMgr.check("code is 'a b'", test.getTestString("a b"));
    }

    private static void testStringArray(Test test) {
        TestMgr.check("arr is '[a, b]'", test.testStringArray(new String[]{"a", "b"}));
    }

    private static void testWrapParam(Test test) {
        User user = new User();
        TestRequest request = new TestRequest();
        request.setUser(user);
        request.setIndex(0);
        request.setData(buffer);
        request.getUsers().add(user);
        User result = test.wrapParam(request);
        LOGGER.info("wrap param result:{}", (Object)result);
        TestMgr.check("User [name=nameA,  users count:1, age=100, index=0]", result);
    }

    static {
        buffer = new byte[1024];
        Arrays.fill(buffer, (byte)1);
    }
}

