/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.demo.pojo.client;

import io.servicecomb.core.CseContext;
import io.servicecomb.demo.CodeFirstPojoIntf;
import io.servicecomb.demo.DemoConst;
import io.servicecomb.demo.TestMgr;
import io.servicecomb.demo.compute.Person;
import io.servicecomb.demo.server.User;
import io.servicecomb.provider.pojo.RpcReference;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class CodeFirstPojoClient {
    @RpcReference(microserviceName="pojo", schemaId="io.servicecomb.demo.CodeFirstPojoIntf")
    public CodeFirstPojoIntf codeFirstAnnotation;
    @RpcReference(microserviceName="pojo")
    public CodeFirstPojoIntf codeFirstAnnotationEmptySchemaId;
    @Inject
    private CodeFirstPojoIntf codeFirstFromXml;

    public void testCodeFirst(String microserviceName) {
        for (String transport : DemoConst.transports) {
            CseContext.getInstance().getConsumerProviderManager().setTransport(microserviceName, transport);
            TestMgr.setMsg((String)microserviceName, (String)transport);
            this.testAll(this.codeFirstAnnotation, transport);
            this.testAll(this.codeFirstAnnotationEmptySchemaId, transport);
            this.testAll(this.codeFirstFromXml, transport);
        }
    }

    protected void testAll(CodeFirstPojoIntf codeFirst, String transport) {
        this.testCodeFirstUserMap(codeFirst);
        this.testCodeFirstUserArray(codeFirst);
        this.testCodeFirstStrings(codeFirst);
        this.testCodeFirstBytes(codeFirst);
        this.testCodeFirstAddDate(codeFirst);
        this.testCodeFirstAddString(codeFirst);
        this.testCodeFirstIsTrue(codeFirst);
        this.testCodeFirstSayHi2(codeFirst);
        this.testCodeFirstSayHi(codeFirst);
        this.testCodeFirstSaySomething(codeFirst);
        this.testCodeFirstSayHello(codeFirst);
        this.testCodeFirstReduce(codeFirst);
    }

    private void testCodeFirstUserMap(CodeFirstPojoIntf codeFirst) {
        User user1 = new User();
        user1.setNames(new String[]{"u1", "u2"});
        User user2 = new User();
        user2.setNames(new String[]{"u3", "u4"});
        HashMap<String, User> userMap = new HashMap<String, User>();
        userMap.put("u1", user1);
        userMap.put("u2", user2);
        Map result = codeFirst.testUserMap(userMap);
        TestMgr.check((Object)"u1", (Object)((User)result.get("u1")).getNames()[0]);
        TestMgr.check((Object)"u2", (Object)((User)result.get("u1")).getNames()[1]);
        TestMgr.check((Object)"u3", (Object)((User)result.get("u2")).getNames()[0]);
        TestMgr.check((Object)"u4", (Object)((User)result.get("u2")).getNames()[1]);
    }

    private void testCodeFirstUserArray(CodeFirstPojoIntf codeFirst) {
        User user1 = new User();
        user1.setNames(new String[]{"u1", "u2"});
        User user2 = new User();
        user2.setNames(new String[]{"u3", "u4"});
        User[] users = new User[]{user1, user2};
        List result = codeFirst.testUserArray(Arrays.asList(users));
        TestMgr.check((Object)"u1", (Object)((User)result.get(0)).getNames()[0]);
        TestMgr.check((Object)"u2", (Object)((User)result.get(0)).getNames()[1]);
        TestMgr.check((Object)"u3", (Object)((User)result.get(1)).getNames()[0]);
        TestMgr.check((Object)"u4", (Object)((User)result.get(1)).getNames()[1]);
    }

    private void testCodeFirstStrings(CodeFirstPojoIntf codeFirst) {
        String[] result = codeFirst.testStrings(new String[]{"a", "b"});
        TestMgr.check((Object)"aa0", (Object)result[0]);
        TestMgr.check((Object)"b", (Object)result[1]);
    }

    private void testCodeFirstBytes(CodeFirstPojoIntf codeFirst) {
        byte[] input = new byte[]{0, 1, 2};
        byte[] result = codeFirst.testBytes(input);
        TestMgr.check((Object)3, (Object)result.length);
        TestMgr.check((Object)1, (Object)result[0]);
        TestMgr.check((Object)1, (Object)result[1]);
        TestMgr.check((Object)2, (Object)result[2]);
    }

    private void testCodeFirstAddDate(CodeFirstPojoIntf codeFirst) {
        Date date = new Date();
        int seconds = 1;
        Date result = codeFirst.addDate(date, (long)seconds);
        TestMgr.check((Object)new Date(date.getTime() + (long)(seconds * 1000)), (Object)result);
    }

    protected void testCodeFirstAddString(CodeFirstPojoIntf codeFirst) {
        String result = codeFirst.addString(Arrays.asList("a", "b"));
        TestMgr.check((Object)"ab", (Object)result);
    }

    protected void testCodeFirstIsTrue(CodeFirstPojoIntf codeFirst) {
        boolean result = codeFirst.isTrue();
        TestMgr.check((Object)true, (Object)result);
    }

    protected void testCodeFirstSayHi2(CodeFirstPojoIntf codeFirst) {
        String result = codeFirst.sayHi2("world");
        TestMgr.check((Object)"world sayhi 2", (Object)result);
    }

    protected void testCodeFirstSayHi(CodeFirstPojoIntf codeFirst) {
        String result = codeFirst.sayHi("world");
        TestMgr.check((Object)"world sayhi", (Object)result);
    }

    protected void testCodeFirstSaySomething(CodeFirstPojoIntf codeFirst) {
        Person person = new Person();
        person.setName("person name");
        String result = codeFirst.saySomething("prefix  prefix", person);
        TestMgr.check((Object)"prefix  prefix person name", (Object)result);
    }

    protected void testCodeFirstSayHello(CodeFirstPojoIntf codeFirst) {
        Person input = new Person();
        input.setName("person name");
        Person result = codeFirst.sayHello(input);
        TestMgr.check((Object)"hello person name", (Object)result.getName());
    }

    protected void testCodeFirstReduce(CodeFirstPojoIntf codeFirst) {
        int result = codeFirst.reduce(5, 3);
        TestMgr.check((Object)2, (Object)result);
    }
}

