/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.demo.pojo.client;

import io.servicecomb.core.CseContext;
import io.servicecomb.core.provider.consumer.InvokerUtils;
import io.servicecomb.demo.DemoConst;
import io.servicecomb.demo.TestMgr;
import io.servicecomb.demo.pojo.client.CodeFirstPojoClient;
import io.servicecomb.demo.server.Test;
import io.servicecomb.demo.server.TestRequest;
import io.servicecomb.demo.server.User;
import io.servicecomb.demo.smartcare.Application;
import io.servicecomb.demo.smartcare.Group;
import io.servicecomb.demo.smartcare.SmartCare;
import io.servicecomb.foundation.common.utils.BeanUtils;
import io.servicecomb.foundation.common.utils.Log4jUtils;
import io.servicecomb.provider.pojo.RpcReference;
import io.servicecomb.swagger.invocation.exception.InvocationException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PojoClient {
    private static Logger LOGGER = LoggerFactory.getLogger(PojoClient.class);
    public static CodeFirstPojoClient codeFirstPojoClient;
    @RpcReference(microserviceName="pojo")
    public static Test test;
    public static Test testFromXml;
    private static SmartCare smartcare;
    public static final byte[] buffer;

    public static void setTestFromXml(Test testFromXml) {
        PojoClient.testFromXml = testFromXml;
    }

    @Inject
    public void setCodeFirstPojoClient(CodeFirstPojoClient codeFirstPojoClient) {
        PojoClient.codeFirstPojoClient = codeFirstPojoClient;
    }

    public static void main(String[] args) throws Exception {
        Log4jUtils.init();
        BeanUtils.init();
        PojoClient.run();
        TestMgr.summary();
    }

    public static void run() throws Exception {
        smartcare = (SmartCare)BeanUtils.getBean((String)"smartcare");
        String microserviceName = "pojo";
        codeFirstPojoClient.testCodeFirst(microserviceName);
        for (String transport : DemoConst.transports) {
            CseContext.getInstance().getConsumerProviderManager().setTransport(microserviceName, transport);
            TestMgr.setMsg((String)microserviceName, (String)transport);
            LOGGER.info("test {}, transport {}", (Object)microserviceName, (Object)transport);
            PojoClient.testNull(testFromXml);
            PojoClient.testNull(test);
            PojoClient.testEmpty(test);
            PojoClient.testStringArray(test);
            PojoClient.testChinese(test);
            PojoClient.testStringHaveSpace(test);
            PojoClient.testWrapParam(test);
            PojoClient.testSplitParam(test);
            PojoClient.testInputArray(test);
            PojoClient.testException(test);
            PojoClient.testSmartCare(smartcare);
            PojoClient.testCommonInvoke(transport);
        }
    }

    private static void testSmartCare(SmartCare smartCare) {
        Group group = new Group();
        group.setName("group0");
        Application application = new Application();
        application.setName("app0");
        application.setDefaultGroup("group0");
        application.setVersion("v1");
        application.setDynamicFlag(true);
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(group);
        application.setGroups(groups);
        TestMgr.check((Object)"resultCode: 0\nresultMessage: add application app0 success", (Object)smartCare.addApplication(application));
        TestMgr.check((Object)"resultCode: 1\nresultMessage: delete application app0 failed", (Object)smartCare.delApplication("app0"));
    }

    private static void testException(Test test) {
        try {
            test.testException(456);
        }
        catch (InvocationException e) {
            TestMgr.check((Object)"456 error", (Object)e.getErrorData());
        }
        try {
            test.testException(556);
        }
        catch (InvocationException e) {
            TestMgr.check((Object)"[556 error]", (Object)e.getErrorData());
        }
        try {
            test.testException(557);
        }
        catch (InvocationException e) {
            TestMgr.check((Object)"[[557 error]]", (Object)e.getErrorData());
        }
    }

    private static void testInputArray(Test test) {
        String result = test.addString(new String[]{"a", "b"});
        LOGGER.info("input array result:{}", (Object)result);
        TestMgr.check((Object)"[a, b]", (Object)result);
    }

    private static void testSplitParam(Test test) {
        User result = test.splitParam(1, new User());
        LOGGER.info("split param result:{}", (Object)result);
        TestMgr.check((Object)"User [name=nameA,  users count:0, age=100, index=1]", (Object)result);
    }

    private static void testCommonInvoke(String transport) {
        Object result = InvokerUtils.syncInvoke((String)"pojo", (String)"server", (String)"splitParam", (Object[])new Object[]{2, new User()});
        TestMgr.check((Object)"User [name=nameA,  users count:0, age=100, index=2]", (Object)result);
        result = InvokerUtils.syncInvoke((String)"pojo", (String)"0.0.1", (String)transport, (String)"server", (String)"splitParam", (Object[])new Object[]{3, new User()});
        TestMgr.check((Object)"User [name=nameA,  users count:0, age=100, index=3]", (Object)result);
    }

    private static void testEmpty(Test test) {
        TestMgr.check((Object)"code is ''", (Object)test.getTestString(""));
    }

    private static void testNull(Test test) {
        TestMgr.check((Object)"code is 'null'", (Object)test.getTestString(null));
        TestMgr.check(null, (Object)test.wrapParam(null));
    }

    private static void testChinese(Test test) {
        TestMgr.check((Object)"code is '\u6d4b\u8bd5'", (Object)test.getTestString("\u6d4b\u8bd5"));
        User user = new User();
        user.setName("\u540d\u5b57");
        User result = test.splitParam(1, user);
        TestMgr.check((Object)"\u540d\u5b57,  users count:0", (Object)result.getName());
    }

    private static void testStringHaveSpace(Test test) {
        TestMgr.check((Object)"code is 'a b'", (Object)test.getTestString("a b"));
    }

    private static void testStringArray(Test test) {
        TestMgr.check((Object)"arr is '[a, b]'", (Object)test.testStringArray(new String[]{"a", "b"}));
    }

    private static void testWrapParam(Test test) {
        User user = new User();
        TestRequest request = new TestRequest();
        request.setUser(user);
        request.setIndex(0);
        request.setData(buffer);
        request.getUsers().add(user);
        User result = test.wrapParam(request);
        LOGGER.info("wrap param result:{}", (Object)result);
        TestMgr.check((Object)"User [name=nameA,  users count:1, age=100, index=0]", (Object)result);
    }

    static {
        buffer = new byte[1024];
        Arrays.fill(buffer, (byte)1);
    }
}

