/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.demo.springmvc.server;

import io.servicecomb.common.rest.codec.RestObjectMapper;
import io.servicecomb.demo.compute.Person;
import io.servicecomb.demo.server.User;
import io.servicecomb.provider.rest.common.RestSchema;
import io.servicecomb.swagger.extend.annotations.ResponseHeaders;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.context.ContextUtils;
import io.servicecomb.swagger.invocation.context.InvocationContext;
import io.servicecomb.swagger.invocation.response.Headers;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ResponseHeader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RestSchema(schemaId="codeFirst")
@RequestMapping(path={"/codeFirstSpringmvc"}, produces={"application/json"})
public class CodeFirstSpringmvc {
    @ResponseHeaders(value={@ResponseHeader(name="h1", response=String.class), @ResponseHeader(name="h2", response=String.class)})
    @RequestMapping(path={"/responseEntity"}, method={RequestMethod.POST})
    public ResponseEntity<Date> responseEntity(InvocationContext c1, @RequestAttribute(value="date") Date date) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("h1", "h1v " + c1.getContext().toString());
        InvocationContext c2 = ContextUtils.getInvocationContext();
        headers.add("h2", "h2v " + c2.getContext().toString());
        return new ResponseEntity((Object)date, (MultiValueMap)headers, HttpStatus.ACCEPTED);
    }

    @ApiResponse(code=200, response=User.class, message="")
    @ResponseHeaders(value={@ResponseHeader(name="h1", response=String.class), @ResponseHeader(name="h2", response=String.class)})
    @RequestMapping(path={"/cseResponse"}, method={RequestMethod.GET})
    public Response cseResponse(InvocationContext c1) {
        Response response = Response.createSuccess((Response.StatusType)Response.Status.ACCEPTED, (Object)new User());
        Headers headers = response.getHeaders();
        headers.addHeader("h1", (Object)("h1v " + c1.getContext().toString()));
        InvocationContext c2 = ContextUtils.getInvocationContext();
        headers.addHeader("h2", (Object)("h2v " + c2.getContext().toString()));
        return response;
    }

    @RequestMapping(path={"/testUserMap"}, method={RequestMethod.POST})
    public Map<String, User> testUserMap(@RequestBody Map<String, User> userMap) {
        return userMap;
    }

    @RequestMapping(path={"/textPlain"}, method={RequestMethod.POST}, consumes={"text/plain"})
    public String textPlain(@RequestBody String body) {
        return body;
    }

    @RequestMapping(path={"/bytes"}, method={RequestMethod.POST})
    public byte[] bytes(@RequestBody byte[] input) {
        input[0] = (byte)(input[0] + 1);
        return input;
    }

    @RequestMapping(path={"/addDate"}, method={RequestMethod.POST})
    public Date addDate(@RequestAttribute(value="date") Date date, @QueryParam(value="seconds") long seconds) {
        return new Date(date.getTime() + seconds * 1000L);
    }

    @RequestMapping(path={"/add"}, method={RequestMethod.POST})
    public int add(@RequestAttribute(value="a") int a, @RequestAttribute(value="b") int b) {
        return a + b;
    }

    @RequestMapping(path={"/reduce"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="a", dataType="integer", format="int32", paramType="query")})
    public int reduce(HttpServletRequest request, @CookieValue(name="b") int b) {
        int a = Integer.parseInt(request.getParameter("a"));
        return a - b;
    }

    @RequestMapping(path={"/sayhello"}, method={RequestMethod.POST})
    public Person sayHello(@RequestBody Person user) {
        user.setName("hello " + user.getName());
        return user;
    }

    @RequestMapping(path={"/testrawjson"}, method={RequestMethod.POST})
    public String testRawJsonString(String jsonInput) {
        Map person;
        try {
            person = (Map)RestObjectMapper.INSTANCE.readValue(jsonInput.getBytes(), Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return "hello " + (String)person.get("name");
    }

    @RequestMapping(path={"/saysomething"}, method={RequestMethod.POST})
    public String saySomething(@RequestHeader(name="prefix") String prefix, @RequestBody Person user) {
        return prefix + " " + user.getName();
    }

    @RequestMapping(path={"/sayhi/{name}"}, method={RequestMethod.PUT})
    public String sayHi(@PathVariable(name="name") String name) {
        ContextUtils.getInvocationContext().setStatus(202);
        return name + " sayhi";
    }

    @RequestMapping(path={"/sayhi/{name}/v2"}, method={RequestMethod.PUT})
    public String sayHi2(@PathVariable(name="name") String name) {
        return name + " sayhi 2";
    }

    @RequestMapping(path={"/istrue"}, method={RequestMethod.GET})
    public boolean isTrue() {
        return true;
    }

    @RequestMapping(path={"/addstring"}, method={RequestMethod.DELETE}, produces={"text/plain"})
    public String addString(@RequestParam(name="s") List<String> s) {
        String result = "";
        for (String x : s) {
            result = result + x;
        }
        return result;
    }
}

