/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.buffer.api.ReadOnlyByteBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

final class ReadOnlyBufferAllocator
implements BufferAllocator {
    static final BufferAllocator PREFER_DIRECT_ALLOCATOR = new ReadOnlyBufferAllocator(true);
    static final BufferAllocator PREFER_HEAP_ALLOCATOR = new ReadOnlyBufferAllocator(false);
    private final boolean preferDirect;

    private ReadOnlyBufferAllocator(boolean preferDirect) {
        this.preferDirect = preferDirect;
    }

    @Override
    public Buffer newBuffer(int initialCapacity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer newBuffer(int initialCapacity, boolean direct) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeBuffer newCompositeBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeBuffer newCompositeBuffer(int maxComponents) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer fromSequence(CharSequence data, Charset charset) {
        return this.fromSequence(data, charset, this.preferDirect);
    }

    @Override
    public Buffer fromSequence(CharSequence data, Charset charset, boolean direct) {
        if (charset == StandardCharsets.US_ASCII) {
            return this.fromAscii(data, direct);
        }
        if (data.length() == 0) {
            return EmptyBuffer.EMPTY_BUFFER;
        }
        CharsetEncoder encoder = charset.newEncoder();
        ByteBuffer byteBuffer = direct ? ByteBuffer.allocateDirect((int)((float)data.length() * encoder.maxBytesPerChar())) : ByteBuffer.allocate((int)((float)data.length() * encoder.maxBytesPerChar()));
        CoderResult cr = encoder.encode(CharBuffer.wrap(data), byteBuffer, true);
        try {
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(byteBuffer)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
        byteBuffer.flip();
        return new ReadOnlyByteBuffer(byteBuffer);
    }

    @Override
    public Buffer fromUtf8(CharSequence data) {
        return this.fromUtf8(data, this.preferDirect);
    }

    @Override
    public Buffer fromUtf8(CharSequence data, boolean direct) {
        return this.fromSequence(data, StandardCharsets.UTF_8, direct);
    }

    @Override
    public Buffer fromAscii(CharSequence data) {
        return this.fromAscii(data, this.preferDirect);
    }

    @Override
    public Buffer fromAscii(CharSequence data, boolean direct) {
        if (data.length() == 0) {
            return EmptyBuffer.EMPTY_BUFFER;
        }
        ByteBuffer byteBuffer = direct ? ByteBuffer.allocateDirect(data.length()) : ByteBuffer.allocate(data.length());
        byteBuffer.put(data.toString().getBytes(StandardCharsets.US_ASCII));
        byteBuffer.flip();
        return new ReadOnlyByteBuffer(byteBuffer);
    }

    @Override
    public Buffer wrap(byte[] bytes) {
        return this.wrap(bytes, 0, bytes.length);
    }

    @Override
    public Buffer wrap(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return EmptyBuffer.EMPTY_BUFFER;
        }
        return new ReadOnlyByteBuffer(ByteBuffer.wrap(bytes, offset, len));
    }

    @Override
    public Buffer wrap(ByteBuffer buffer) {
        return new ReadOnlyByteBuffer(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(directByDefault: " + this.preferDirect + ')';
    }
}

