/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.AsciiBuffer;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CharSequences {
    private CharSequences() {
    }

    public static CharSequence newAsciiString(String input) {
        return CharSequences.newAsciiString(ReadOnlyBufferAllocators.DEFAULT_RO_ALLOCATOR.fromAscii(input));
    }

    public static CharSequence newAsciiString(Buffer input) {
        return new AsciiBuffer(input);
    }

    public static CharSequence emptyAsciiString() {
        return AsciiBuffer.EMPTY_ASCII_BUFFER;
    }

    public static boolean isAsciiString(CharSequence sequence) {
        return sequence.getClass() == AsciiBuffer.class;
    }

    @Nullable
    public static Buffer unwrapBuffer(CharSequence cs) {
        return CharSequences.isAsciiString(cs) ? ((AsciiBuffer)cs).unwrap() : null;
    }

    public static int forEachByte(CharSequence sequence, ByteProcessor visitor) {
        Objects.requireNonNull(sequence);
        if (CharSequences.isAsciiString(sequence)) {
            return ((AsciiBuffer)sequence).forEachByte(visitor);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (visitor.process((byte)sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean contentEqualsIgnoreCase(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        if (a.getClass() == AsciiBuffer.class) {
            return ((AsciiBuffer)a).contentEqualsIgnoreCase(b);
        }
        return CharSequences.contentEqualsIgnoreCaseUnknownTypes(a, b);
    }

    public static boolean contentEquals(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        if (a.getClass() == AsciiBuffer.class) {
            return ((AsciiBuffer)a).contentEquals(b);
        }
        return CharSequences.contentEqualsUnknownTypes(a, b);
    }

    public static int indexOf(CharSequence sequence, char c, int fromIndex) {
        if (sequence instanceof String) {
            return ((String)sequence).indexOf(c, fromIndex);
        }
        if (CharSequences.isAsciiString(sequence)) {
            return CharSequences.asciiStringIndexOf(sequence, c, fromIndex);
        }
        for (int i = fromIndex; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int asciiStringIndexOf(CharSequence sequence, char c, int fromIndex) {
        return ((AsciiBuffer)sequence).indexOf(c, fromIndex);
    }

    public static int caseInsensitiveHashCode(CharSequence seq) {
        return CharSequences.isAsciiString(seq) ? seq.hashCode() : AsciiBuffer.hashCodeAscii(seq);
    }

    public static List<CharSequence> split(CharSequence input, char delimiter, boolean trim) {
        if (input.length() == 0) {
            return Collections.emptyList();
        }
        return trim ? CharSequences.splitWithTrim(input, CharSequences.isAsciiString(input), delimiter) : CharSequences.split0(input, CharSequences.isAsciiString(input), delimiter);
    }

    private static List<CharSequence> split0(CharSequence input, boolean isAscii, char delimiter) {
        int startIndex = 0;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(4);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != delimiter) continue;
            result.add(CharSequences.subsequence(isAscii, input, startIndex, i));
            startIndex = i + 1;
        }
        if (input.length() - startIndex > 0) {
            result.add(CharSequences.subsequence(isAscii, input, startIndex, input.length()));
        } else {
            result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
        }
        return result;
    }

    private static List<CharSequence> splitWithTrim(CharSequence input, boolean isAscii, char delimiter) {
        int startIndex = -1;
        int endIndex = -1;
        boolean reset = true;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(4);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != ' ' && c != delimiter) {
                endIndex = i + 1;
            }
            if (reset && c != ' ' && c != delimiter) {
                startIndex = i;
                reset = false;
                continue;
            }
            if (c != delimiter) continue;
            if (endIndex > startIndex) {
                result.add(CharSequences.subsequence(isAscii, input, startIndex, endIndex));
            } else {
                result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
            }
            startIndex = i + 1;
            endIndex = i + 1;
            reset = true;
        }
        if (startIndex != -1) {
            if (input.length() - startIndex > 0) {
                result.add(CharSequences.subsequence(isAscii, input, startIndex, endIndex));
            } else {
                result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
            }
        }
        return result;
    }

    private static CharSequence subsequence(boolean isAscii, CharSequence input, int start, int end) {
        return isAscii ? CharSequences.newAsciiString(((AsciiBuffer)input).unwrap().copy(start, end - start)) : input.subSequence(start, end);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || CharSequences.toLowerCase(a) == CharSequences.toLowerCase(b);
    }

    public static boolean equalsIgnoreCaseLower(char a, char lowerCaseChar) {
        return a == lowerCaseChar || CharSequences.toLowerCase(a) == lowerCaseChar;
    }

    private static char toLowerCase(char c) {
        return CharSequences.isUpperCase(c) ? (char)(c + 32) : c;
    }

    private static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start, int length) {
        if (cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, csStart, (String)string, start, length);
        }
        return CharSequences.regionMatchesCharSequences(cs, csStart, string, start, length, ignoreCase ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string, int start, int length, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length > cs.length() - csStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length;
        int stringIndex = start;
        while (csIndex < csEnd) {
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string.charAt(stringIndex++))) continue;
            return false;
        }
        return true;
    }

    static boolean contentEqualsUnknownTypes(CharSequence a, CharSequence b) {
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean contentEqualsIgnoreCaseUnknownTypes(CharSequence a, CharSequence b) {
        for (int i = 0; i < a.length(); ++i) {
            if (CharSequences.equalsIgnoreCase(a.charAt(i), b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

