/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.CharSequences;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;

public final class Matchers {
    private Matchers() {
    }

    public static Matcher<CharSequence> contentEqualTo(final CharSequence expected) {
        Objects.requireNonNull(expected);
        return new TypeSafeMatcher<CharSequence>(){

            protected boolean matchesSafely(CharSequence item) {
                return CharSequences.contentEquals((CharSequence)expected, (CharSequence)item);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expected);
            }
        };
    }

    @SafeVarargs
    public static <E extends CharSequence> Matcher<Iterable<? extends E>> containsIgnoreCase(E ... items) {
        ArrayList<CharsEqualsIgnoreCase> matchers = new ArrayList<CharsEqualsIgnoreCase>(items.length);
        for (E item : items) {
            matchers.add(new CharsEqualsIgnoreCase((CharSequence)item));
        }
        return IsIterableContainingInOrder.contains(matchers);
    }

    private static final class CharsEqualsIgnoreCase
    extends BaseMatcher<CharSequence> {
        @Nullable
        private final CharSequence expected;

        private CharsEqualsIgnoreCase(CharSequence expected) {
            this.expected = expected;
        }

        public boolean matches(Object actual) {
            return actual instanceof CharSequence && CharSequences.contentEqualsIgnoreCase((CharSequence)this.expected, (CharSequence)((CharSequence)actual));
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.expected);
        }
    }
}

