/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.buffer.api.EmptyBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

final class AsciiBuffer
implements CharSequence {
    static final CharSequence EMPTY_ASCII_BUFFER = new AsciiBuffer(EmptyBuffer.EMPTY_BUFFER);
    private static final boolean BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private static final int HASH_CODE_ASCII_SEED = -1028477387;
    private static final int HASH_CODE_C1 = -862048943;
    private static final int HASH_CODE_C2 = 461845907;
    private final Buffer buffer;
    private int hash;

    AsciiBuffer(Buffer buffer) {
        this.buffer = buffer.asReadOnly();
    }

    @Override
    public int length() {
        return this.buffer.readableBytes();
    }

    @Override
    public char charAt(int index) {
        return (char)(this.buffer.getByte(index) & 0xFF);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.toString(start, end - start, StandardCharsets.US_ASCII);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = AsciiBuffer.hashCodeAscii(this.buffer, this.buffer.readerIndex(), this.buffer.readableBytes());
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != AsciiBuffer.class) {
            return false;
        }
        AsciiBuffer that = (AsciiBuffer)o;
        return this.hashCode() == that.hashCode() && this.buffer.equals(that.buffer);
    }

    @Override
    public String toString() {
        return this.buffer.toString(StandardCharsets.US_ASCII);
    }

    Buffer unwrap() {
        return this.buffer;
    }

    int indexOf(char ch, int start) {
        return this.buffer.indexOf(start, this.buffer.writerIndex(), (byte)ch);
    }

    int forEachByte(ByteProcessor visitor) {
        return this.buffer.forEachByte(visitor);
    }

    boolean contentEquals(CharSequence cs) {
        if (cs.getClass() == AsciiBuffer.class) {
            return this.buffer.equals(((AsciiBuffer)cs).buffer);
        }
        return CharSequences.contentEqualsUnknownTypes(this, cs);
    }

    boolean contentEqualsIgnoreCase(CharSequence cs) {
        return CharSequences.contentEqualsIgnoreCaseUnknownTypes(this, cs);
    }

    private static int hashCodeAscii(Buffer buffer, int startPos, int length) {
        int hash = -1028477387;
        int remainingBytes = length & 7;
        int end = startPos + remainingBytes;
        for (int i = startPos - 8 + length; i >= end; i -= 8) {
            hash = AsciiBuffer.hashCodeAsciiCompute(buffer.getLong(i), hash);
        }
        switch (remainingBytes) {
            case 7: {
                return ((hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getByte(startPos))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getShort(startPos + 1))) * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getInt(startPos + 3));
            }
            case 6: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getShort(startPos))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getInt(startPos + 2));
            }
            case 5: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getByte(startPos))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getInt(startPos + 1));
            }
            case 4: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getInt(startPos));
            }
            case 3: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getByte(startPos))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getShort(startPos + 1));
            }
            case 2: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getShort(startPos));
            }
            case 1: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize(buffer.getByte(startPos));
            }
        }
        return hash;
    }

    static int hashCodeAscii(CharSequence bytes) {
        int hash = -1028477387;
        int remainingBytes = bytes.length() & 7;
        switch (bytes.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                hash = AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 24, AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 16, AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 8, hash)));
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                hash = AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 16, AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 8, hash));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                hash = AsciiBuffer.hashCodeAsciiCompute(bytes, bytes.length() - 8, hash);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                for (int i = bytes.length() - 8; i >= remainingBytes; i -= 8) {
                    hash = AsciiBuffer.hashCodeAsciiCompute(bytes, i, hash);
                }
            }
        }
        switch (remainingBytes) {
            case 7: {
                return ((hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeByte(bytes.charAt(0))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeShort(bytes, 1)) * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeInt(bytes, 3);
            }
            case 6: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeShort(bytes, 0)) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeInt(bytes, 2);
            }
            case 5: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeByte(bytes.charAt(0))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeInt(bytes, 1);
            }
            case 4: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeInt(bytes, 0);
            }
            case 3: {
                return (hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeByte(bytes.charAt(0))) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeShort(bytes, 1);
            }
            case 2: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeShort(bytes, 0);
            }
            case 1: {
                return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeByte(bytes.charAt(0));
            }
        }
        return hash;
    }

    private static int hashCodeAsciiCompute(long value, int hash) {
        return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitize((int)value) * 461845907 + (int)((value & 0x1F1F1F1F00000000L) >>> 32);
    }

    private static int hashCodeAsciiSanitize(int value) {
        return value & 0x1F1F1F1F;
    }

    private static int hashCodeAsciiSanitize(short value) {
        return value & 0x1F1F;
    }

    private static int hashCodeAsciiSanitize(byte value) {
        return value & 0x1F;
    }

    private static int hashCodeAsciiSanitizeByte(char value) {
        return value & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence value, int offset) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (value.charAt(offset + 1) & 0x1F) << 8 | value.charAt(offset) & 0x1F;
        }
        return value.charAt(offset + 1) & 0x1F | (value.charAt(offset) & 0x1F) << 8;
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence value, int offset) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (value.charAt(offset + 3) & 0x1F) << 24 | (value.charAt(offset + 2) & 0x1F) << 16 | (value.charAt(offset + 1) & 0x1F) << 8 | value.charAt(offset) & 0x1F;
        }
        return value.charAt(offset + 3) & 0x1F | (value.charAt(offset + 2) & 0x1F) << 8 | (value.charAt(offset + 1) & 0x1F) << 16 | (value.charAt(offset) & 0x1F) << 24;
    }

    private static int hashCodeAsciiCompute(CharSequence value, int offset, int hash) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeInt(value, offset) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeInt(value, offset + 4);
        }
        return hash * -862048943 + AsciiBuffer.hashCodeAsciiSanitizeInt(value, offset + 4) * 461845907 + AsciiBuffer.hashCodeAsciiSanitizeInt(value, offset);
    }
}

