/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson.jersey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.servicetalk.data.jackson.JacksonSerializationProvider;
import io.servicetalk.data.jackson.jersey.JacksonSerializationProviderContextResolver;
import io.servicetalk.data.jackson.jersey.JacksonSerializerMessageBodyReaderWriter;
import io.servicetalk.data.jackson.jersey.SerializationExceptionMapper;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ContextResolver;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceTalkJacksonSerializerFeature
implements Feature {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTalkJacksonSerializerFeature.class);
    private static final String ST_JSON_FEATURE = ServiceTalkJacksonSerializerFeature.class.getSimpleName();

    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = (String)CommonProperties.getValue((Map)config.getProperties(), (RuntimeType)config.getRuntimeType(), (String)"jersey.config.jsonFeature", (Object)ST_JSON_FEATURE, String.class);
        if (!ST_JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            LOGGER.warn("Skipping registration of: {} as JSON support is already provided by: {}", (Object)ST_JSON_FEATURE, (Object)jsonFeature);
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime((String)"jersey.config.jsonFeature", (RuntimeType)config.getRuntimeType()), (Object)ST_JSON_FEATURE);
        if (!config.isRegistered(JacksonSerializerMessageBodyReaderWriter.class)) {
            context.register(SerializationExceptionMapper.class);
            context.register(JacksonSerializerMessageBodyReaderWriter.class);
        }
        return true;
    }

    public static ContextResolver<JacksonSerializationProvider> contextResolverFor(ObjectMapper objectMapper) {
        return ServiceTalkJacksonSerializerFeature.contextResolverFor(new JacksonSerializationProvider(objectMapper));
    }

    public static ContextResolver<JacksonSerializationProvider> contextResolverFor(JacksonSerializationProvider serializationProvider) {
        return new JacksonSerializationProviderContextResolver(Objects.requireNonNull(serializationProvider));
    }
}

