/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.servicetalk.grpc.protoc.DefaultServiceCommentsMap;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.NoopServiceCommentsMap;
import io.servicetalk.grpc.protoc.ServiceCommentsMap;
import io.servicetalk.grpc.protoc.StringUtils;
import io.servicetalk.grpc.protoc.Types;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

final class Generator {
    private final GenerationContext context;
    private final Map<String, ClassName> messageTypesMap;
    private final ServiceCommentsMap serviceCommentsMap;
    private final boolean printJavaDocs;

    Generator(GenerationContext context, Map<String, ClassName> messageTypesMap, boolean printJavaDocs, DescriptorProtos.SourceCodeInfo sourceCodeInfo) {
        this.context = context;
        this.messageTypesMap = messageTypesMap;
        this.serviceCommentsMap = printJavaDocs ? new DefaultServiceCommentsMap(sourceCodeInfo) : NoopServiceCommentsMap.NOOP_MAP;
        this.printJavaDocs = printJavaDocs;
    }

    TypeSpec.Builder generate(DescriptorProtos.ServiceDescriptorProto serviceProto, int serviceIndex) {
        String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(serviceProto.getName(), false) + "Service");
        State state = new State(serviceProto, name, serviceIndex);
        TypeSpec.Builder serviceClassBuilder = this.context.newServiceClassBuilder(serviceProto);
        if (this.printJavaDocs) {
            serviceClassBuilder.addJavadoc("Class for $L Service", new Object[]{serviceProto.getName()});
        }
        this.addSerializationProviderInit(state, serviceClassBuilder);
        this.addServiceRpcInterfaces(state, serviceClassBuilder);
        this.addServiceInterfaces(state, serviceClassBuilder);
        this.addServiceFilter(state, serviceClassBuilder);
        Generator.addServiceFilterFactory(state, serviceClassBuilder);
        this.addServiceFactory(state, serviceClassBuilder);
        this.addClientMetadata(state, serviceClassBuilder);
        this.addClientInterfaces(state, serviceClassBuilder);
        this.addClientFilter(state, serviceClassBuilder);
        Generator.addClientFilterFactory(state, serviceClassBuilder);
        this.addClientFactory(state, serviceClassBuilder);
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addSerializationProviderInit(State state, TypeSpec.Builder serviceClassBuilder) {
        CodeBlock.Builder staticInitBlockBuilder = CodeBlock.builder().addStatement("$T builder = new $T()", new Object[]{Types.ProtoBufSerializationProviderBuilder, Types.ProtoBufSerializationProviderBuilder}).addStatement("builder.supportedMessageCodings($L)", new Object[]{"supportedMessageCodings"});
        Stream.concat(state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasInputType).map(DescriptorProtos.MethodDescriptorProto::getInputType), state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasOutputType).map(DescriptorProtos.MethodDescriptorProto::getOutputType)).distinct().map(this.messageTypesMap::get).forEach(t -> staticInitBlockBuilder.addStatement("$L.registerMessageType($T.class, $T.parser())", new Object[]{"builder", t, t}));
        staticInitBlockBuilder.addStatement("return $L.build()", new Object[]{"builder"}).build();
        serviceClassBuilder.addMethod(MethodSpec.methodBuilder((String)"initSerializationProvider").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)Types.GrpcSerializationProvider).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addCode(staticInitBlockBuilder.build()).build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addServiceRpcInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        List methodDescriptorProtoList = state.serviceProto.getMethodList();
        for (int i = 0; i < methodDescriptorProtoList.size(); ++i) {
            int methodIndex = i;
            DescriptorProtos.MethodDescriptorProto methodProto = (DescriptorProtos.MethodDescriptorProto)methodDescriptorProtoList.get(i);
            String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Rpc");
            FieldSpec.Builder pathSpecBuilder = FieldSpec.builder(String.class, (String)"PATH", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.context.methodPath(state.serviceProto, methodProto)});
            TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder((String)name).addAnnotation(FunctionalInterface.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(pathSpecBuilder.build()).addMethod(this.newRpcMethodSpec(methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addParameter((TypeName)Types.GrpcServiceContext, "ctx", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param ctx context associated with this service and request." + System.lineSeparator(), new Object[0]);
                }
                return b;
            })).addSuperinterface((TypeName)Types.GrpcService);
            if (methodProto.hasOptions() && methodProto.getOptions().getDeprecated()) {
                interfaceSpecBuilder.addAnnotation(Deprecated.class);
            }
            TypeSpec interfaceSpec = interfaceSpecBuilder.build();
            state.serviceRpcInterfaces.add(new RpcInterface(methodProto, false, ClassName.bestGuess((String)name)));
            serviceClassBuilder.addType(interfaceSpec);
        }
        ArrayList<RpcInterface> asyncRpcInterfaces = new ArrayList<RpcInterface>(state.serviceRpcInterfaces);
        for (int i = 0; i < asyncRpcInterfaces.size(); ++i) {
            int methodIndex = i;
            RpcInterface rpcInterface = (RpcInterface)asyncRpcInterfaces.get(i);
            DescriptorProtos.MethodDescriptorProto methodProto = rpcInterface.methodProto;
            String name = this.context.deconflictJavaTypeName("Blocking" + rpcInterface.className.simpleName());
            FieldSpec.Builder pathSpecBuilder = FieldSpec.builder(String.class, (String)"PATH", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{rpcInterface.className, "PATH"});
            TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder((String)name).addAnnotation(FunctionalInterface.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(pathSpecBuilder.build()).addMethod(this.newRpcMethodSpec(methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addParameter((TypeName)Types.GrpcServiceContext, "ctx", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param ctx context associated with this service and request." + System.lineSeparator(), new Object[0]);
                }
                return b;
            })).addSuperinterface((TypeName)Types.BlockingGrpcService);
            if (methodProto.hasOptions() && methodProto.getOptions().getDeprecated()) {
                interfaceSpecBuilder.addAnnotation(Deprecated.class);
            }
            TypeSpec interfaceSpec = interfaceSpecBuilder.build();
            state.serviceRpcInterfaces.add(new RpcInterface(methodProto, true, ClassName.bestGuess((String)name)));
            serviceClassBuilder.addType(interfaceSpec);
        }
        return serviceClassBuilder;
    }

    private void extractJavaDocComments(State state, int methodIndex, MethodSpec.Builder b) {
        String serviceComments = this.serviceCommentsMap.getLeadingComments(state.serviceIndex, methodIndex);
        if (serviceComments != null) {
            StringBuilder sb = new StringBuilder(serviceComments.length() * 2);
            sb.append("<pre>").append(System.lineSeparator());
            StringUtils.escapeJavaDoc(serviceComments, sb);
            sb.append("</pre>").append(System.lineSeparator()).append(System.lineSeparator());
            b.addJavadoc(sb.toString(), new Object[0]);
        }
    }

    private TypeSpec.Builder addServiceInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec interfaceSpec = this.newServiceInterfaceSpec(state, false);
        serviceClassBuilder.addType(interfaceSpec);
        interfaceSpec = this.newServiceInterfaceSpec(state, true);
        serviceClassBuilder.addType(interfaceSpec);
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addServiceFilter(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec.Builder classSpecBuilder = Generator.newFilterDelegateCommonMethods(state.serviceFilterClass, state.serviceClass);
        state.serviceProto.getMethodList().forEach(methodProto -> classSpecBuilder.addMethod(this.newRpcMethodSpec((DescriptorProtos.MethodDescriptorProto)methodProto, EnumSet.noneOf(NewRpcMethodFlag.class), false, (n, b) -> b.addAnnotation(Override.class).addParameter((TypeName)Types.GrpcServiceContext, "ctx", new Modifier[]{Modifier.FINAL}).addStatement("return $L.$L($L, $L)", new Object[]{"delegate", n, "ctx", "request"}))));
        serviceClassBuilder.addType(classSpecBuilder.build());
        return serviceClassBuilder;
    }

    private static TypeSpec.Builder addServiceFilterFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        serviceClassBuilder.addType(TypeSpec.interfaceBuilder((ClassName)state.serviceFilterFactoryClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcServiceFilterFactory, (TypeName[])new TypeName[]{state.serviceFilterClass, state.serviceClass})).build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addServiceFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName builderClass = state.serviceFactoryClass.nestedClass("Builder");
        ClassName serviceFromRoutesClass = builderClass.nestedClass(state.serviceClass.simpleName() + "FromRoutes");
        TypeSpec.Builder serviceBuilderSpecBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addField(FieldSpec.builder((TypeName)Types.GrpcSupportedCodings, (String)"supportedMessageCodings", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).superclass((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcRoutes, (TypeName[])new TypeName[]{state.serviceClass})).addType(this.newServiceFromRoutesClassSpec(serviceFromRoutesClass, state.serviceRpcInterfaces, state.serviceClass)).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this(java.util.Collections.emptyList())", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this.$L = $L", new Object[]{"supportedMessageCodings", "supportedMessageCodings"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addStatement("this($L, java.util.Collections.emptyList())", new Object[]{"strategyFactory"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("super($L)", new Object[]{"strategyFactory"}).addStatement("this.$L = $L", new Object[]{"supportedMessageCodings", "supportedMessageCodings"}).build()).addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)state.serviceFactoryClass).addStatement("return new $T(this)", new Object[]{state.serviceFactoryClass}).build()).addMethod(MethodSpec.methodBuilder((String)"newServiceFromRoutes").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)serviceFromRoutesClass).addParameter((TypeName)Types.AllGrpcRoutes, "routes", new Modifier[]{Modifier.FINAL}).addStatement("return new $T($L)", new Object[]{serviceFromRoutesClass, "routes"}).build());
        state.serviceRpcInterfaces.forEach(rpcInterface -> {
            ClassName inClass = this.messageTypesMap.get(rpcInterface.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(rpcInterface.methodProto.getOutputType());
            String routeName = Generator.routeName(rpcInterface.methodProto);
            String methodName = routeName + (rpcInterface.blocking ? "Blocking" : "");
            String addRouteMethodName = Generator.addRouteMethodName(rpcInterface.methodProto, rpcInterface.blocking);
            ClassName routeInterfaceClass = Generator.routeInterfaceClass(rpcInterface.methodProto, rpcInterface.blocking);
            serviceBuilderSpecBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)rpcInterface.className, "rpc", new Modifier[]{Modifier.FINAL}).returns((TypeName)builderClass).addStatement("$L($T.$L, $L.getClass(), $S, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", new Object[]{addRouteMethodName, rpcInterface.className, "PATH", "rpc", routeName, routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedMessageCodings"}).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Types.GrpcExecutionStrategy, "strategy", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)rpcInterface.className, "rpc", new Modifier[]{Modifier.FINAL}).returns((TypeName)builderClass).addStatement("$L($T.$L, $L, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", new Object[]{addRouteMethodName, rpcInterface.className, "PATH", "strategy", routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedMessageCodings"}).addStatement("return this", new Object[0]).build());
        });
        MethodSpec.Builder registerRoutesMethodSpecBuilder = MethodSpec.methodBuilder((String)"registerRoutes").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter((TypeName)state.serviceClass, "service", new Modifier[]{Modifier.FINAL});
        state.serviceProto.getMethodList().stream().map(Generator::routeName).forEach(n -> registerRoutesMethodSpecBuilder.addStatement("$L($L)", new Object[]{n, "service"}));
        TypeSpec serviceBuilderType = serviceBuilderSpecBuilder.addMethod(registerRoutesMethodSpecBuilder.build()).build();
        TypeSpec.Builder serviceFactoryClassSpecBuilder = TypeSpec.classBuilder((ClassName)state.serviceFactoryClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcServiceFactory, (TypeName[])new TypeName[]{state.serviceFilterClass, state.serviceClass, state.serviceFilterFactoryClass})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.serviceClass, "service", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T().$L)", new Object[]{builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.serviceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L).$L)", new Object[]{builderClass, "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.serviceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L).$L)", new Object[]{builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.serviceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L, $L).$L)", new Object[]{builderClass, "strategyFactory", "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.blockingServiceClass, "service", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T().$L)", new Object[]{builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.blockingServiceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L).$L)", new Object[]{builderClass, "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.blockingServiceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L).$L)", new Object[]{builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)state.blockingServiceClass, "service", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this(new $T($L, $L).$L)", new Object[]{builderClass, "strategyFactory", "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)builderClass, "builder", new Modifier[]{Modifier.FINAL}).addStatement("super($L)", new Object[]{"builder"}).build()).addMethod(MethodSpec.methodBuilder((String)"appendServiceFilter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)state.serviceFactoryClass).addParameter((TypeName)state.serviceFilterFactoryClass, "factory", new Modifier[]{Modifier.FINAL}).addStatement("super.$L($L)", new Object[]{"appendServiceFilter", "factory"}).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"appendServiceFilterFactory").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.serviceFilterFactoryClass).addParameter((TypeName)state.serviceFilterFactoryClass, "existing", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)state.serviceFilterFactoryClass, "append", new Modifier[]{Modifier.FINAL}).addStatement("return $L -> $L.create($L.create($L))", new Object[]{"service", "existing", "append", "service"}).build()).addType(serviceBuilderType);
        serviceClassBuilder.addType(serviceFactoryClassSpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientMetadata(State state, TypeSpec.Builder serviceClassBuilder) {
        state.serviceRpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpcInterface -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpcInterface.methodProto;
            String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Metadata");
            ClassName metaDataClassName = ClassName.bestGuess((String)name);
            TypeSpec classSpec = TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)Types.DefaultGrpcClientMetadata).addField(FieldSpec.builder((TypeName)metaDataClassName, (String)"INSTANCE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{metaDataClassName}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("super($T.$L)", new Object[]{rpcInterface.className, "PATH"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Types.ContentCodec, "requestEncoding", new Modifier[]{Modifier.FINAL}).addStatement("super($T.$L, $L)", new Object[]{rpcInterface.className, "PATH", "requestEncoding"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Types.GrpcExecutionStrategy, "strategy", new Modifier[]{Modifier.FINAL}).addStatement("super($T.$L, $L)", new Object[]{rpcInterface.className, "PATH", "strategy"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Duration.class, "timeout", new Modifier[]{Modifier.FINAL}).addStatement("super($T.$L, $L)", new Object[]{rpcInterface.className, "PATH", "timeout"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Types.GrpcExecutionStrategy, "strategy", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)Types.ContentCodec, "requestEncoding", new Modifier[]{Modifier.FINAL}).addStatement("super($T.$L, $L, $L)", new Object[]{rpcInterface.className, "PATH", "strategy", "requestEncoding"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Types.GrpcExecutionStrategy, "strategy", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)Types.ContentCodec, "requestEncoding", new Modifier[]{Modifier.FINAL}).addParameter(Duration.class, "timeout", new Modifier[]{Modifier.FINAL}).addStatement("super($T.$L, $L, $L, $L)", new Object[]{rpcInterface.className, "PATH", "strategy", "requestEncoding", "timeout"}).build()).build();
            state.clientMetaDatas.add(new ClientMetaData(methodProto, metaDataClassName));
            serviceClassBuilder.addType(classSpec);
        });
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec.Builder clientSpecBuilder = TypeSpec.interfaceBuilder((ClassName)state.clientClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)state.filterableClientClass).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcClient, (TypeName[])new TypeName[]{state.blockingClientClass}));
        TypeSpec.Builder filterableClientSpecBuilder = TypeSpec.interfaceBuilder((ClassName)state.filterableClientClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)Types.FilterableGrpcClient);
        TypeSpec.Builder blockingClientSpecBuilder = TypeSpec.interfaceBuilder((ClassName)state.blockingClientClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.BlockingGrpcClient, (TypeName[])new TypeName[]{state.clientClass}));
        for (int i = 0; i < state.clientMetaDatas.size(); ++i) {
            int methodIndex = i;
            ClientMetaData clientMetaData = state.clientMetaDatas.get(i);
            clientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                }
                return b;
            }));
            filterableClientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b;
            }));
            blockingClientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                }
                return b;
            })).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b;
            }));
        }
        serviceClassBuilder.addType(clientSpecBuilder.build()).addType(filterableClientSpecBuilder.build()).addType(blockingClientSpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientFilter(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec.Builder classSpecBuilder = Generator.newFilterDelegateCommonMethods(state.clientFilterClass, state.filterableClientClass).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "delegate")).addMethod(Generator.newDelegatingMethodSpec("executionContext", "delegate", Types.GrpcExecutionContext, null));
        state.clientMetaDatas.forEach(clientMetaData -> classSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[0]).addStatement("return $L.$L($L, $L)", new Object[]{"delegate", n, "metadata", "request"}))));
        serviceClassBuilder.addType(classSpecBuilder.build());
        return serviceClassBuilder;
    }

    private static TypeSpec.Builder addClientFilterFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        serviceClassBuilder.addType(TypeSpec.interfaceBuilder((ClassName)state.clientFilterFactoryClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcClientFilterFactory, (TypeName[])new TypeName[]{state.clientFilterClass, state.filterableClientClass})).build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName clientFactoryClass = state.clientClass.peerClass("ClientFactory");
        ClassName defaultClientClass = clientFactoryClass.peerClass("Default" + state.clientClass.simpleName());
        ClassName filterableClientToClientClass = clientFactoryClass.peerClass(state.filterableClientClass.simpleName() + "To" + state.clientClass.simpleName());
        ClassName defaultBlockingClientClass = clientFactoryClass.peerClass("Default" + state.blockingClientClass.simpleName());
        ClassName clientToBlockingClientClass = clientFactoryClass.peerClass(state.clientClass.simpleName() + "To" + state.blockingClientClass.simpleName());
        TypeSpec.Builder clientFactorySpecBuilder = TypeSpec.classBuilder((ClassName)clientFactoryClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcClientFactory, (TypeName[])new TypeName[]{state.clientClass, state.blockingClientClass, state.clientFilterClass, state.filterableClientClass, state.clientFilterFactoryClass})).addMethod(MethodSpec.methodBuilder((String)"appendClientFilterFactory").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.clientFilterFactoryClass).addParameter((TypeName)state.clientFilterFactoryClass, "existing", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)state.clientFilterFactoryClass, "append", new Modifier[]{Modifier.FINAL}).addStatement("return $L -> $L.create($L.create($L))", new Object[]{"client", "existing", "append", "client"}).build()).addMethod(MethodSpec.methodBuilder((String)"newClient").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.clientClass).addParameter((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.FINAL}).addStatement("return new $T($L, $L())", new Object[]{defaultClientClass, "factory", "supportedMessageCodings"}).build()).addMethod(MethodSpec.methodBuilder((String)"newFilter").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.clientFilterClass).addParameter((TypeName)state.clientClass, "client", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)state.clientFilterFactoryClass, "factory", new Modifier[]{Modifier.FINAL}).addStatement("return $L.create($L)", new Object[]{"factory", "client"}).build()).addMethod(MethodSpec.methodBuilder((String)"newClient").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.clientClass).addParameter((TypeName)state.filterableClientClass, "client", new Modifier[]{Modifier.FINAL}).addStatement("return new $T($L)", new Object[]{filterableClientToClientClass, "client"}).build()).addMethod(MethodSpec.methodBuilder((String)"newBlockingClient").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)state.blockingClientClass).addParameter((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.FINAL}).addStatement("return new $T($L, $L())", new Object[]{defaultBlockingClientClass, "factory", "supportedMessageCodings"}).build()).addType(this.newDefaultClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newFilterableClientToClientClassSpec(state, filterableClientToClientClass, clientToBlockingClientClass)).addType(this.newDefaultBlockingClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newClientToBlockingClientClassSpec(state, clientToBlockingClientClass));
        serviceClassBuilder.addType(clientFactorySpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec newServiceFromRoutesClassSpec(ClassName serviceFromRoutesClass, List<RpcInterface> rpcInterfaces, ClassName serviceClass) {
        TypeSpec.Builder serviceFromRoutesSpecBuilder = TypeSpec.classBuilder((ClassName)serviceFromRoutesClass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)serviceClass).addField((TypeName)Types.AsyncCloseable, "closeable", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder serviceFromRoutesConstructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Types.AllGrpcRoutes, "routes", new Modifier[]{Modifier.FINAL}).addStatement("$L = $L", new Object[]{"closeable", "routes"});
        rpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpc -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpc.methodProto;
            ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
            String routeName = Generator.routeName(methodProto);
            serviceFromRoutesSpecBuilder.addField((TypeName)ParameterizedTypeName.get((ClassName)Generator.routeInterfaceClass(methodProto), (TypeName[])new TypeName[]{inClass, outClass}), routeName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            serviceFromRoutesConstructorBuilder.addStatement("$L = $L.$L($T.$L)", new Object[]{routeName, "routes", Generator.routeFactoryMethodName(methodProto), rpc.className, "PATH"});
            serviceFromRoutesSpecBuilder.addMethod(this.newRpcMethodSpec(methodProto, EnumSet.noneOf(NewRpcMethodFlag.class), false, (name, builder) -> builder.addAnnotation(Override.class).addParameter((TypeName)Types.GrpcServiceContext, "ctx", new Modifier[]{Modifier.FINAL}).addStatement("return $L.handle($L, $L)", new Object[]{routeName, "ctx", "request"})));
        });
        serviceFromRoutesSpecBuilder.addMethod(serviceFromRoutesConstructorBuilder.build()).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "closeable")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "closeable"));
        return serviceFromRoutesSpecBuilder.build();
    }

    private MethodSpec newRpcMethodSpec(DescriptorProtos.MethodDescriptorProto methodProto, EnumSet<NewRpcMethodFlag> flags, boolean printJavaDocs, BiFunction<String, MethodSpec.Builder, MethodSpec.Builder> methodBuilderCustomizer) {
        Modifier[] modifierArray;
        ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
        ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
        String name = Generator.routeName(methodProto);
        MethodSpec.Builder methodSpecBuilder = methodBuilderCustomizer.apply(name, MethodSpec.methodBuilder((String)name)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (flags.contains((Object)NewRpcMethodFlag.INTERFACE)) {
            modifierArray = new Modifier[]{};
        } else {
            Modifier[] modifierArray2 = new Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = Modifier.FINAL;
        }
        Modifier[] mods = modifierArray;
        if (flags.contains((Object)NewRpcMethodFlag.BLOCKING)) {
            if (methodProto.getClientStreaming()) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Iterable.class), (TypeName[])new TypeName[]{inClass}), "request", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param request used to send a stream of type {@link $T} to the server." + System.lineSeparator(), new Object[]{inClass});
                    }
                } else {
                    methodSpecBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Types.BlockingIterable, (TypeName[])new TypeName[]{inClass}), "request", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param request used to read the stream of type {@link $T} from the client." + System.lineSeparator(), new Object[]{inClass});
                    }
                }
            } else {
                methodSpecBuilder.addParameter((TypeName)inClass, "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request the request from the client." + System.lineSeparator(), new Object[0]);
                }
            }
            if (methodProto.getServerStreaming()) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)Types.BlockingIterable, (TypeName[])new TypeName[]{outClass}));
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@return used to read the response stream of type {@link $T} from the server." + System.lineSeparator(), new Object[]{outClass});
                    }
                } else {
                    methodSpecBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcPayloadWriter, (TypeName[])new TypeName[]{outClass}), "responseWriter", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param responseWriter used to write a stream of type {@link $T} to the client." + System.lineSeparator() + "The implementation of this method is responsible for calling {@link $T#close()}." + System.lineSeparator(), new Object[]{outClass, Types.GrpcPayloadWriter});
                    }
                }
            } else {
                methodSpecBuilder.returns((TypeName)outClass);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "the response from the server." : "the response to send to the client") + System.lineSeparator(), new Object[0]);
                }
            }
            methodSpecBuilder.addException(Exception.class);
            if (printJavaDocs) {
                methodSpecBuilder.addJavadoc("@throws $T if an unexpected application error occurs." + System.lineSeparator(), new Object[]{Exception.class}).addJavadoc("@throws $T if an expected application exception occurs. Its contents will be serialized and propagated to the peer.", new Object[]{Types.GrpcStatusException});
            }
        } else {
            if (methodProto.getClientStreaming()) {
                methodSpecBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Types.Publisher, (TypeName[])new TypeName[]{inClass}), "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request used to read a stream of type {@link $T} from the client." + System.lineSeparator(), new Object[]{inClass});
                }
            } else {
                methodSpecBuilder.addParameter((TypeName)inClass, "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request" + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? " the request to send to the server." : " the request from the client.") + System.lineSeparator(), new Object[0]);
                }
            }
            if (methodProto.getServerStreaming()) {
                methodSpecBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)Types.Publisher, (TypeName[])new TypeName[]{outClass}));
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "used to read a stream of type {@link $T} from the server." : "used to write a stream of type {@link $T} to the client.") + System.lineSeparator(), new Object[]{outClass});
                }
            } else {
                methodSpecBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)Types.Single, (TypeName[])new TypeName[]{outClass}));
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "a {@link $T} which completes when the response is received from the server." : "a {@link $T} which sends the response to the client when it terminates.") + System.lineSeparator(), new Object[]{Types.Single});
                }
            }
        }
        return methodSpecBuilder.build();
    }

    private TypeSpec newDefaultBlockingClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)defaultBlockingClientClass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)state.blockingClientClass).addField((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.methodBuilder((String)"asClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)state.clientClass).addStatement("return new $T($L, $L)", new Object[]{defaultClientClass, "factory", "supportedMessageCodings"}).build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this.$N = $N", new Object[]{"factory", "factory"}).addStatement("this.$N = $N", new Object[]{"supportedMessageCodings", "supportedMessageCodings"});
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, true);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private TypeSpec newDefaultClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)defaultClientClass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)state.clientClass).addField((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.methodBuilder((String)"asBlockingClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)state.blockingClientClass).addStatement("return new $T($L, $L)", new Object[]{defaultBlockingClientClass, "factory", "supportedMessageCodings"}).build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Types.GrpcClientCallFactory, "factory", new Modifier[]{Modifier.FINAL}).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[]{Modifier.FINAL}).addStatement("this.$N = $N", new Object[]{"factory", "factory"}).addStatement("this.$N = $N", new Object[]{"supportedMessageCodings", "supportedMessageCodings"});
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, false);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private void addClientFieldsAndMethods(State state, TypeSpec.Builder typeSpecBuilder, MethodSpec.Builder constructorBuilder, boolean blocking) {
        EnumSet<NewRpcMethodFlag> rpcMethodSpecsFlags = blocking ? EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT) : EnumSet.of(NewRpcMethodFlag.CLIENT);
        state.clientMetaDatas.forEach(clientMetaData -> {
            ClassName inClass = this.messageTypesMap.get(clientMetaData.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(clientMetaData.methodProto.getOutputType());
            String routeName = Generator.routeName(clientMetaData.methodProto);
            String callFieldName = routeName + "Call";
            typeSpecBuilder.addField((TypeName)ParameterizedTypeName.get((ClassName)Generator.clientCallClass(clientMetaData.methodProto, blocking), (TypeName[])new TypeName[]{inClass, outClass}), callFieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, false, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L($T.$L, $L)", new Object[]{n, clientMetaData.className, "INSTANCE", "request"}))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, false, (__, b) -> b.addAnnotation(Override.class).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[]{Modifier.FINAL}).addStatement("return $L.$L($L, $L)", new Object[]{callFieldName, "request", "metadata", "request"})));
            constructorBuilder.addStatement("$L = $N.$L($L($L), $T.class, $T.class)", new Object[]{callFieldName, "factory", Generator.newCallMethodName(clientMetaData.methodProto, blocking), "initSerializationProvider", "supportedMessageCodings", inClass, outClass});
        });
    }

    private TypeSpec newFilterableClientToClientClassSpec(State state, ClassName filterableClientToClientClass, ClassName clientToBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)filterableClientToClientClass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)state.clientClass).addField((TypeName)state.filterableClientClass, "client", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)state.filterableClientClass, "client", new Modifier[]{Modifier.FINAL}).addStatement("this.$L = $L", new Object[]{"client", "client"}).build()).addMethod(MethodSpec.methodBuilder((String)"asBlockingClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)state.blockingClientClass).addStatement("return new $T(this)", new Object[]{clientToBlockingClientClass}).build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "client", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "client")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "client")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "client"));
        state.clientMetaDatas.forEach(clientMetaData -> typeSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L($T.$L, $L)", new Object[]{n, clientMetaData.className, "INSTANCE", "request"}))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[]{Modifier.FINAL}).addStatement("return $L.$L($L, $L)", new Object[]{"client", n, "metadata", "request"}))));
        return typeSpecBuilder.build();
    }

    private TypeSpec newClientToBlockingClientClassSpec(State state, ClassName clientToBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)clientToBlockingClientClass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)state.blockingClientClass).addField((TypeName)state.clientClass, "client", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)state.clientClass, "client", new Modifier[]{Modifier.FINAL}).addStatement("this.$L = $L", new Object[]{"client", "client"}).build()).addMethod(MethodSpec.methodBuilder((String)"asClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)state.clientClass).addStatement("return $L", new Object[]{"client"}).build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "client", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingMethodSpec("close", "client", null, ClassName.get(Exception.class)));
        state.clientMetaDatas.forEach(clientMetaData -> {
            CodeBlock requestExpression = clientMetaData.methodProto.getClientStreaming() ? CodeBlock.of((String)"$T.fromIterable($L)", (Object[])new Object[]{Types.Publisher, "request"}) : CodeBlock.of((String)"request", (Object[])new Object[0]);
            String responseConversionExpression = clientMetaData.methodProto.getServerStreaming() ? ".toIterable()" : ".toFuture().get()";
            typeSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L.$L($L)$L", new Object[]{"client", n, requestExpression, responseConversionExpression}))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addParameter((TypeName)clientMetaData.className, "metadata", new Modifier[]{Modifier.FINAL}).addStatement("return $L.$L($L, $L)$L", new Object[]{"client", n, "metadata", requestExpression, responseConversionExpression})));
        });
        return typeSpecBuilder.build();
    }

    private TypeSpec newServiceInterfaceSpec(State state, boolean blocking) {
        ClassName serviceClass = blocking ? state.blockingServiceClass : state.serviceClass;
        String name = serviceClass.simpleName();
        TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.GrpcBindableService, (TypeName[])new TypeName[]{state.serviceFilterClass, state.serviceClass, state.serviceFilterFactoryClass})).addSuperinterface((TypeName)(blocking ? Types.BlockingGrpcService : Types.GrpcService));
        state.serviceRpcInterfaces.stream().filter(e -> e.blocking == blocking).map(e -> e.className).forEach(arg_0 -> ((TypeSpec.Builder)interfaceSpecBuilder).addSuperinterface(arg_0));
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"bindService");
        if (this.printJavaDocs) {
            b.addJavadoc("Makes a {@link $T} bound to this instance implementing {@link $T}", new Object[]{state.serviceFactoryClass, serviceClass});
        }
        interfaceSpecBuilder.addMethod(b.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.DEFAULT}).returns((TypeName)state.serviceFactoryClass).addStatement("return new $T(this)", new Object[]{state.serviceFactoryClass}).build());
        return interfaceSpecBuilder.build();
    }

    private static TypeSpec.Builder newFilterDelegateCommonMethods(ClassName filterClass, ClassName filteredClass) {
        return TypeSpec.classBuilder((ClassName)filterClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)filteredClass).addField((TypeName)filteredClass, "delegate", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)filteredClass, "delegate", new Modifier[]{Modifier.FINAL}).addStatement("this.$L = $L", new Object[]{"delegate", "delegate"}).build()).addMethod(MethodSpec.methodBuilder((String)"delegate").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)filteredClass).addStatement("return $L", new Object[]{"delegate"}).build()).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "delegate")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "delegate"));
    }

    private static String routeName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return StringUtils.sanitizeIdentifier(methodProto.getName(), true);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingRoute : Types.RequestStreamingRoute) : (methodProto.getServerStreaming() ? Types.ResponseStreamingRoute : Types.Route);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? (blocking ? Types.BlockingStreamingRoute : Types.StreamingRoute) : (blocking ? Types.BlockingRequestStreamingRoute : Types.RequestStreamingRoute)) : (methodProto.getServerStreaming() ? (blocking ? Types.BlockingResponseStreamingRoute : Types.ResponseStreamingRoute) : (blocking ? Types.BlockingRoute : Types.Route));
    }

    private static String routeFactoryMethodName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return (methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "streamingR" : "requestStreamingR") : (methodProto.getServerStreaming() ? "responseStreamingR" : "r")) + "outeFor";
    }

    private static String addRouteMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "add" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Route";
    }

    private static String serviceFactoryBuilderInitChain(DescriptorProtos.ServiceDescriptorProto serviceProto, boolean blocking) {
        return serviceProto.getMethodList().stream().map(methodProto -> Generator.routeName(methodProto) + (blocking ? "Blocking" : "") + '(' + "service" + ')').collect(Collectors.joining("."));
    }

    private static ClassName clientCallClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        if (!blocking) {
            return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingClientCall : Types.RequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.ResponseStreamingClientCall : Types.ClientCall);
        }
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.BlockingStreamingClientCall : Types.BlockingRequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.BlockingResponseStreamingClientCall : Types.BlockingClientCall);
    }

    private static String newCallMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "new" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Call";
    }

    private static String streamingNameModifier(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "Streaming" : "RequestStreaming") : (methodProto.getServerStreaming() ? "ResponseStreaming" : "");
    }

    private static MethodSpec newDelegatingCompletableMethodSpec(String methodName, String fieldName) {
        return Generator.newDelegatingMethodSpec(methodName, fieldName, Types.Completable, null);
    }

    private static MethodSpec newDelegatingMethodSpec(String methodName, String fieldName, @Nullable ClassName returnClass, @Nullable ClassName thrownClass) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$L$L.$L()", new Object[]{returnClass != null ? "return " : "", fieldName, methodName});
        if (returnClass != null) {
            methodSpecBuilder.returns((TypeName)returnClass);
        }
        if (thrownClass != null) {
            methodSpecBuilder.addException((TypeName)thrownClass);
        }
        return methodSpecBuilder.build();
    }

    private static MethodSpec newDelegatingCompletableToBlockingMethodSpec(String blockingMethodName, String completableMethodName, String fieldName) {
        return MethodSpec.methodBuilder((String)blockingMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addException(Exception.class).addStatement("$L.$L().toFuture().get()", new Object[]{fieldName, completableMethodName}).build();
    }

    static enum NewRpcMethodFlag {
        BLOCKING,
        INTERFACE,
        CLIENT;

    }

    private static final class State {
        final DescriptorProtos.ServiceDescriptorProto serviceProto;
        final int serviceIndex;
        final List<RpcInterface> serviceRpcInterfaces;
        final ClassName serviceClass;
        final ClassName blockingServiceClass;
        final ClassName serviceFactoryClass;
        final ClassName serviceFilterClass;
        final ClassName serviceFilterFactoryClass;
        final List<ClientMetaData> clientMetaDatas;
        final ClassName clientClass;
        final ClassName filterableClientClass;
        final ClassName blockingClientClass;
        final ClassName clientFilterClass;
        final ClassName clientFilterFactoryClass;

        private State(DescriptorProtos.ServiceDescriptorProto serviceProto, String name, int serviceIndex) {
            this.serviceProto = serviceProto;
            this.serviceIndex = serviceIndex;
            this.serviceRpcInterfaces = new ArrayList<RpcInterface>(2 * serviceProto.getMethodCount());
            this.serviceClass = ClassName.bestGuess((String)name);
            this.blockingServiceClass = ClassName.bestGuess((String)("Blocking" + name));
            this.serviceFactoryClass = this.serviceClass.peerClass("ServiceFactory");
            this.serviceFilterClass = this.serviceClass.peerClass(this.serviceClass.simpleName() + "Filter");
            this.serviceFilterFactoryClass = this.serviceFilterClass.peerClass(this.serviceFilterClass.simpleName() + "Factory");
            this.clientMetaDatas = new ArrayList<ClientMetaData>(serviceProto.getMethodCount());
            this.clientClass = ClassName.bestGuess((String)(StringUtils.sanitizeIdentifier(serviceProto.getName(), false) + "Client"));
            this.filterableClientClass = this.clientClass.peerClass("Filterable" + this.clientClass.simpleName());
            this.blockingClientClass = this.clientClass.peerClass("Blocking" + this.clientClass.simpleName());
            this.clientFilterClass = this.clientClass.peerClass(this.clientClass.simpleName() + "Filter");
            this.clientFilterFactoryClass = this.clientFilterClass.peerClass(this.clientFilterClass.simpleName() + "Factory");
        }
    }

    private static final class ClientMetaData {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final ClassName className;

        private ClientMetaData(DescriptorProtos.MethodDescriptorProto methodProto, ClassName className) {
            this.methodProto = methodProto;
            this.className = className;
        }
    }

    private static final class RpcInterface {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final boolean blocking;
        final ClassName className;

        private RpcInterface(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking, ClassName className) {
            this.methodProto = methodProto;
            this.blocking = blocking;
            this.className = className;
        }
    }
}

