/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Supplier;

final class AfterSubscriberPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier;

    AfterSubscriberPublisher(Publisher<T> original, Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        super(original);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new AfterSubscriberPublisherSubscriber<T>(subscriber, this.subscriberSupplier.get());
    }

    private static final class AfterSubscriberPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final PublisherSource.Subscriber<? super T> subscriber;

        AfterSubscriberPublisherSubscriber(PublisherSource.Subscriber<? super T> original, PublisherSource.Subscriber<? super T> subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.original.onSubscribe(s);
            this.subscriber.onSubscribe(s);
        }

        @Override
        public void onNext(T t) {
            this.original.onNext(t);
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            try {
                this.original.onComplete();
            }
            finally {
                this.subscriber.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.original.onError(t);
            }
            finally {
                this.subscriber.onError(t);
            }
        }
    }
}

