/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.concurrent.Callable;

final class ContextPreservingCallable<V>
implements Callable<V> {
    private final ContextMap saved;
    private final Callable<V> delegate;

    ContextPreservingCallable(Callable<V> delegate) {
        this(delegate, DefaultAsyncContextProvider.INSTANCE.context());
    }

    ContextPreservingCallable(Callable<V> delegate, ContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                V v = this.delegate.call();
                return v;
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        }
        return this.slowPath();
    }

    private V slowPath() throws Exception {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            V v = this.delegate.call();
            return v;
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

