/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import javax.annotation.Nullable;

class ContextPreservingSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    final ContextMap saved;
    final SingleSource.Subscriber<T> subscriber;

    ContextPreservingSingleSubscriber(SingleSource.Subscriber<T> subscriber, ContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    void invokeOnSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSubscribe(Cancellable cancellable) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.invokeOnSubscribe(cancellable);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onSubscribeSlowPath(cancellable);
        }
    }

    private void onSubscribeSlowPath(Cancellable cancellable) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.invokeOnSubscribe(cancellable);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSuccess(@Nullable T result) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscriber.onSuccess(result);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onSuccessSlowPath(result);
        }
    }

    private void onSuccessSlowPath(@Nullable T result) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscriber.onSuccess(result);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Throwable t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscriber.onError(t);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onErrorSlowPath(t);
        }
    }

    private void onErrorSlowPath(Throwable t) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscriber.onError(t);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

