/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;

final class ContextPreservingSubscription
implements PublisherSource.Subscription {
    private final ContextMap saved;
    private final PublisherSource.Subscription subscription;

    private ContextPreservingSubscription(PublisherSource.Subscription subscription, ContextMap current) {
        this.subscription = Objects.requireNonNull(subscription);
        this.saved = Objects.requireNonNull(current);
    }

    static PublisherSource.Subscription wrap(PublisherSource.Subscription subscription, ContextMap current) {
        return subscription instanceof ContextPreservingSubscription && ((ContextPreservingSubscription)subscription).saved == current ? subscription : new ContextPreservingSubscription(subscription, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long l) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscription.request(l);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.requestSlowPath(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSlowPath(long l) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscription.request(l);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscription.cancel();
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.cancelSlowPath();
        }
    }

    private void cancelSlowPath() {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscription.cancel();
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscription + ')';
    }
}

