/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.internal.ContextMapUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class CopyOnWriteContextMap
implements ContextMap {
    private static final AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater = AtomicReferenceFieldUpdater.newUpdater(CopyOnWriteContextMap.class, CopyContextMap.class, "map");
    private volatile CopyContextMap map;

    CopyOnWriteContextMap() {
        this(EmptyContextMap.INSTANCE);
    }

    private CopyOnWriteContextMap(CopyContextMap map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(ContextMap.Key<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
        return this.map.contains(key, value);
    }

    @Override
    @Nullable
    public <T> T get(ContextMap.Key<T> key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    @Nullable
    public <T> T put(ContextMap.Key<T> key, @Nullable T value) {
        return this.map.put(key, value, this, mapUpdater);
    }

    @Override
    @Nullable
    public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value) {
        return this.map.putIfAbsent(key, value, this, mapUpdater);
    }

    @Override
    @Nullable
    public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction) {
        return this.map.computeIfAbsent(key, computeFunction, this, mapUpdater);
    }

    @Override
    public void putAll(ContextMap map) {
        CopyContextMap contextMap;
        int size = map.size();
        if (size < 1) {
            return;
        }
        do {
            contextMap = this.map;
        } while (!mapUpdater.compareAndSet(this, contextMap, contextMap.putAll(size, map::forEach)));
    }

    @Override
    public void putAll(Map<ContextMap.Key<?>, Object> map) {
        CopyContextMap contextMap;
        int size = map.size();
        if (size < 1) {
            return;
        }
        do {
            contextMap = this.map;
        } while (!mapUpdater.compareAndSet(this, contextMap, contextMap.putAll(size, map::forEach)));
    }

    @Override
    @Nullable
    public <T> T remove(ContextMap.Key<T> key) {
        return this.map.remove(key, this, mapUpdater);
    }

    @Override
    public boolean removeAll(Iterable<ContextMap.Key<?>> keys) {
        return this.map.removeAll(keys, this, mapUpdater);
    }

    @Override
    public void clear() {
        this.map = EmptyContextMap.INSTANCE;
    }

    @Override
    @Nullable
    public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
        return this.map.forEach(consumer);
    }

    @Override
    public ContextMap copy() {
        return new CopyOnWriteContextMap(this.map);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextMap)) {
            return false;
        }
        if (o instanceof CopyOnWriteContextMap) {
            return this.map.equals(((CopyOnWriteContextMap)o).map);
        }
        return ContextMapUtils.equals((ContextMap)this, (ContextMap)((ContextMap)o));
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return ContextMapUtils.toString((ContextMap)this);
    }

    private static final class PutAllBuilder
    implements BiConsumer<ContextMap.Key<?>, Object>,
    BiPredicate<ContextMap.Key<?>, Object> {
        private final Object[] pairs;
        private int index;

        PutAllBuilder(int size) {
            assert (size > 0);
            this.pairs = new Object[size << 1];
        }

        void addPairs(Object[] currentPairs) {
            System.arraycopy(currentPairs, 0, this.pairs, 0, currentPairs.length);
            this.index = currentPairs.length;
        }

        int addPair(ContextMap.Key<?> key, @Nullable Object value) {
            assert (this.index <= this.pairs.length - 2);
            this.pairs[this.index] = key;
            this.pairs[++this.index] = value;
            return ++this.index;
        }

        @Override
        public void accept(ContextMap.Key<?> key, @Nullable Object value) {
            ContextMapUtils.ensureType(key, (Object)value);
            this.test(key, value);
        }

        @Override
        public boolean test(ContextMap.Key<?> key, @Nullable Object value) {
            for (int i = 0; i < this.index; i += 2) {
                if (!key.equals(this.pairs[i])) continue;
                this.pairs[i + 1] = value;
                return true;
            }
            return this.addPair(key, value) < this.pairs.length;
        }

        CopyContextMap build() {
            assert (this.index % 2 == 0);
            if (this.index <= 12) {
                switch (this.index) {
                    case 0: {
                        return EmptyContextMap.INSTANCE;
                    }
                    case 2: {
                        return new OneContextMap((ContextMap.Key)this.pairs[0], this.pairs[1]);
                    }
                    case 4: {
                        return new TwoContextMap((ContextMap.Key)this.pairs[0], this.pairs[1], (ContextMap.Key)this.pairs[2], this.pairs[3]);
                    }
                    case 6: {
                        return new ThreeContextMap((ContextMap.Key)this.pairs[0], this.pairs[1], (ContextMap.Key)this.pairs[2], this.pairs[3], (ContextMap.Key)this.pairs[4], this.pairs[5]);
                    }
                    case 8: {
                        return new FourContextMap((ContextMap.Key)this.pairs[0], this.pairs[1], (ContextMap.Key)this.pairs[2], this.pairs[3], (ContextMap.Key)this.pairs[4], this.pairs[5], (ContextMap.Key)this.pairs[6], this.pairs[7]);
                    }
                    case 10: {
                        return new FiveContextMap((ContextMap.Key)this.pairs[0], this.pairs[1], (ContextMap.Key)this.pairs[2], this.pairs[3], (ContextMap.Key)this.pairs[4], this.pairs[5], (ContextMap.Key)this.pairs[6], this.pairs[7], (ContextMap.Key)this.pairs[8], this.pairs[9]);
                    }
                    case 12: {
                        return new SixContextMap((ContextMap.Key)this.pairs[0], this.pairs[1], (ContextMap.Key)this.pairs[2], this.pairs[3], (ContextMap.Key)this.pairs[4], this.pairs[5], (ContextMap.Key)this.pairs[6], this.pairs[7], (ContextMap.Key)this.pairs[8], this.pairs[9], (ContextMap.Key)this.pairs[10], this.pairs[11]);
                    }
                }
                throw new IllegalStateException("Unexpected index: " + this.index + ", (expected an even number from 2 to 12");
            }
            if (this.index == this.pairs.length) {
                return new SevenOrMoreContextMap(this.pairs);
            }
            return new SevenOrMoreContextMap(Arrays.copyOf(this.pairs, this.index));
        }
    }

    private static final class SevenOrMoreContextMap
    implements CopyContextMap {
        private final Object[] context;

        SevenOrMoreContextMap(Object ... context) {
            assert (context.length >= 2);
            assert (context.length % 2 == 0);
            this.context = context;
        }

        private int findIndex(ContextMap.Key<?> key) {
            for (int i = 0; i < this.context.length; i += 2) {
                if (!key.equals(this.context[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int size() {
            return this.context.length >>> 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return this.findIndex(key) >= 0;
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            for (int i = 1; i < this.context.length; i += 2) {
                if (!Objects.equals(value, this.context[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            for (int i = 0; i < this.context.length; i += 2) {
                if (!key.equals(this.context[i]) || !Objects.equals(value, this.context[i + 1])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> T get(ContextMap.Key<T> key) {
            int i = this.findIndex(key);
            return (T)(i < 0 ? null : this.context[i + 1]);
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            int i = this.findIndex(key);
            return (T)(i < 0 ? defaultValue : this.context[i + 1]);
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            Object[] context;
            Object returnValue;
            int i = this.findIndex(key);
            if (i < 0) {
                returnValue = null;
                context = new Object[this.context.length + 2];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[this.context.length] = key;
                context[this.context.length + 1] = value;
            } else {
                returnValue = this.context[i + 1];
                context = new Object[this.context.length];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[i + 1] = value;
            }
            return (T)(mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(context)) ? returnValue : owner.put(key, value));
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            Object[] context;
            int i = this.findIndex(key);
            if (i < 0) {
                context = new Object[this.context.length + 2];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[this.context.length] = key;
                context[this.context.length + 1] = value;
            } else {
                Object currentValue = this.context[i + 1];
                if (currentValue != null) {
                    return (T)currentValue;
                }
                context = new Object[this.context.length];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[i + 1] = value;
            }
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(context)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            Object[] context;
            T value;
            int i = this.findIndex(key);
            if (i < 0) {
                value = computeFunction.apply(key);
                context = new Object[this.context.length + 2];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[this.context.length] = key;
                context[this.context.length + 1] = value;
            } else {
                Object currentValue = this.context[i + 1];
                if (currentValue != null) {
                    return (T)currentValue;
                }
                value = computeFunction.apply(key);
                context = new Object[this.context.length];
                System.arraycopy(this.context, 0, context, 0, this.context.length);
                context[i + 1] = value;
            }
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(context)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPairs(this.context);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            int i = this.findIndex(key);
            if (i < 0) {
                return null;
            }
            Object value = this.context[i + 1];
            if (this.size() == 7) {
                return (T)(mapUpdater.compareAndSet(owner, this, this.removeBelowSeven(i)) ? value : owner.remove(key));
            }
            Object[] context = new Object[this.context.length - 2];
            System.arraycopy(this.context, 0, context, 0, i);
            System.arraycopy(this.context, i + 2, context, i, this.context.length - i - 2);
            return (T)(mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(context)) ? value : owner.remove(key));
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            GrowableIntArray indexesToRemove = new GrowableIntArray(keys instanceof Collection ? ((Collection)keys).size() : 4);
            for (ContextMap.Key<?> k : keys) {
                int keyIndex = this.findIndex(k);
                if (keyIndex < 0) continue;
                indexesToRemove.add(keyIndex);
            }
            CopyContextMap newMap = this.removeAll(indexesToRemove);
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        @Nullable
        private CopyContextMap removeAll(GrowableIntArray indexesToRemove) {
            if (this.size() == indexesToRemove.count()) {
                return EmptyContextMap.INSTANCE;
            }
            if (indexesToRemove.count() == 0) {
                return null;
            }
            if (this.size() - indexesToRemove.count() < 7) {
                return this.removeBelowSeven(indexesToRemove);
            }
            Object[] context = new Object[this.context.length - (indexesToRemove.count() << 1)];
            int newContextIndex = 0;
            for (int i = 0; i < this.context.length; i += 2) {
                if (!indexesToRemove.isValueAbsent(i)) continue;
                context[newContextIndex++] = this.context[i];
                context[newContextIndex++] = this.context[i + 1];
            }
            assert (newContextIndex == context.length);
            return new SevenOrMoreContextMap(context);
        }

        private CopyContextMap removeBelowSeven(int i) {
            switch (i) {
                case 0: {
                    return new SixContextMap((ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[10], this.context[11], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 2: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[10], this.context[11], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 4: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[10], this.context[11], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 6: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[10], this.context[11], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 8: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[10], this.context[11], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 10: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[12], this.context[13]);
                }
                case 12: {
                    return new SixContextMap((ContextMap.Key)this.context[0], this.context[1], (ContextMap.Key)this.context[2], this.context[3], (ContextMap.Key)this.context[4], this.context[5], (ContextMap.Key)this.context[6], this.context[7], (ContextMap.Key)this.context[8], this.context[9], (ContextMap.Key)this.context[10], this.context[11]);
                }
            }
            throw new IllegalStateException("Programming error, unable to remove a key at index=" + i);
        }

        private CopyContextMap removeBelowSeven(GrowableIntArray indexesToRemove) {
            switch (this.size() - indexesToRemove.count()) {
                case 1: {
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        return new OneContextMap((ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 2: {
                    int keepI1 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        return new TwoContextMap((ContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 3: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        return new ThreeContextMap((ContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (ContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 4: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        return new FourContextMap((ContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (ContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (ContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 5: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    int keepI4 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        if (keepI4 < 0) {
                            keepI4 = i;
                            continue;
                        }
                        return new FiveContextMap((ContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (ContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (ContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (ContextMap.Key)this.context[keepI4], this.context[keepI4 + 1], (ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
                case 6: {
                    int keepI1 = -1;
                    int keepI2 = -1;
                    int keepI3 = -1;
                    int keepI4 = -1;
                    int keepI5 = -1;
                    for (int i = 0; i < this.context.length; i += 2) {
                        if (!indexesToRemove.isValueAbsent(i)) continue;
                        if (keepI1 < 0) {
                            keepI1 = i;
                            continue;
                        }
                        if (keepI2 < 0) {
                            keepI2 = i;
                            continue;
                        }
                        if (keepI3 < 0) {
                            keepI3 = i;
                            continue;
                        }
                        if (keepI4 < 0) {
                            keepI4 = i;
                            continue;
                        }
                        if (keepI5 < 0) {
                            keepI5 = i;
                            continue;
                        }
                        return new SixContextMap((ContextMap.Key)this.context[keepI1], this.context[keepI1 + 1], (ContextMap.Key)this.context[keepI2], this.context[keepI2 + 1], (ContextMap.Key)this.context[keepI3], this.context[keepI3 + 1], (ContextMap.Key)this.context[keepI4], this.context[keepI4 + 1], (ContextMap.Key)this.context[keepI5], this.context[keepI5 + 1], (ContextMap.Key)this.context[i], this.context[i + 1]);
                    }
                    break;
                }
            }
            throw new IllegalStateException("Programming error, unable to reduce from " + this.size() + " to " + (this.size() - indexesToRemove.count()));
        }

        @Override
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            for (int i = 0; i < this.context.length; i += 2) {
                ContextMap.Key key = (ContextMap.Key)this.context[i];
                if (consumer.test(key, this.context[i + 1])) continue;
                return key;
            }
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SevenOrMoreContextMap that = (SevenOrMoreContextMap)o;
            return Arrays.equals(this.context, that.context);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.context);
        }

        private static final class GrowableIntArray {
            private int[] array;
            private int count;

            GrowableIntArray(int initialSize) {
                this.array = new int[initialSize];
            }

            void add(int value) {
                if (this.count == this.array.length) {
                    this.array = Arrays.copyOf(this.array, this.array.length << 1);
                }
                this.array[this.count++] = value;
            }

            boolean isValueAbsent(int value) {
                for (int i = 0; i < this.count; ++i) {
                    if (this.array[i] != value) continue;
                    return false;
                }
                return true;
            }

            int count() {
                return this.count;
            }
        }
    }

    private static final class SixContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;
        private final ContextMap.Key<?> keyTwo;
        @Nullable
        private final Object valueTwo;
        private final ContextMap.Key<?> keyThree;
        @Nullable
        private final Object valueThree;
        private final ContextMap.Key<?> keyFour;
        @Nullable
        private final Object valueFour;
        private final ContextMap.Key<?> keyFive;
        @Nullable
        private final Object valueFive;
        private final ContextMap.Key<?> keySix;
        @Nullable
        private final Object valueSix;

        SixContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne, ContextMap.Key<?> keyTwo, @Nullable Object valueTwo, ContextMap.Key<?> keyThree, @Nullable Object valueThree, ContextMap.Key<?> keyFour, @Nullable Object valueFour, ContextMap.Key<?> keyFive, @Nullable Object valueFive, ContextMap.Key<?> keySix, @Nullable Object valueSix) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
            this.keyFive = keyFive;
            this.valueFive = valueFive;
            this.keySix = keySix;
            this.valueSix = valueSix;
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne) || key.equals(this.keyTwo) || key.equals(this.keyThree) || key.equals(this.keyFour) || key.equals(this.keyFive) || key.equals(this.keySix);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne) || Objects.equals(value, this.valueTwo) || Objects.equals(value, this.valueThree) || Objects.equals(value, this.valueFour) || Objects.equals(value, this.valueFive) || Objects.equals(value, this.valueSix);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return key.equals(this.keyOne) && Objects.equals(value, this.valueOne) || key.equals(this.keyTwo) && Objects.equals(value, this.valueTwo) || key.equals(this.keyThree) && Objects.equals(value, this.valueThree) || key.equals(this.keyFour) && Objects.equals(value, this.valueFour) || key.equals(this.keyFive) && Objects.equals(value, this.valueFive) || key.equals(this.keySix) && Objects.equals(value, this.valueSix);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : (key.equals(this.keyFive) ? this.valueFive : (key.equals(this.keySix) ? this.valueSix : null))))));
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : (key.equals(this.keyFive) ? this.valueFive : (key.equals(this.keySix) ? this.valueSix : defaultValue))))));
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueOne : owner.put(key, value));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueTwo : owner.put(key, value));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueThree : owner.put(key, value));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueFour : owner.put(key, value));
            }
            if (key.equals(this.keyFive)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value, this.keySix, this.valueSix)) ? this.valueFive : owner.put(key, value));
            }
            if (key.equals(this.keySix)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? this.valueSix : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueFour;
            }
            if (key.equals(this.keyFive)) {
                if (this.valueFive == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value, this.keySix, this.valueSix)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueFive;
            }
            if (key.equals(this.keySix)) {
                if (this.valueSix == null) {
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueSix;
            }
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueFour;
            }
            if (key.equals(this.keyFive)) {
                if (this.valueFive == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value, this.keySix, this.valueSix)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueFive;
            }
            if (key.equals(this.keySix)) {
                if (this.valueSix == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueSix;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new SevenOrMoreContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            builder.addPair(this.keyTwo, this.valueTwo);
            builder.addPair(this.keyThree, this.valueThree);
            builder.addPair(this.keyFour, this.valueFour);
            builder.addPair(this.keyFive, this.valueFive);
            builder.addPair(this.keySix, this.valueSix);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueOne : owner.remove(key));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueTwo : owner.remove(key));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueThree : owner.remove(key));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix)) ? this.valueFour : owner.remove(key));
            }
            if (key.equals(this.keyFive)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix)) ? this.valueFive : owner.remove(key));
            }
            if (key.equals(this.keySix)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueSix : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            CopyContextMap newMap = this.removeAll(this.removeIndexMask(keys));
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        private int removeIndexMask(Iterable<ContextMap.Key<?>> keys) {
            int mask = 0;
            for (ContextMap.Key<?> k : keys) {
                if (k.equals(this.keyOne)) {
                    mask |= 1;
                    continue;
                }
                if (k.equals(this.keyTwo)) {
                    mask |= 2;
                    continue;
                }
                if (k.equals(this.keyThree)) {
                    mask |= 4;
                    continue;
                }
                if (k.equals(this.keyFour)) {
                    mask |= 8;
                    continue;
                }
                if (k.equals(this.keyFive)) {
                    mask |= 0x10;
                    continue;
                }
                if (!k.equals(this.keySix)) continue;
                mask |= 0x20;
            }
            return mask;
        }

        @Nullable
        private CopyContextMap removeAll(int removeIndexMask) {
            if ((removeIndexMask & 0x3F) == 63) {
                return EmptyContextMap.INSTANCE;
            }
            if ((removeIndexMask & 0x20) == 32) {
                if ((removeIndexMask & 0x10) == 16) {
                    if ((removeIndexMask & 8) == 8) {
                        if ((removeIndexMask & 4) == 4) {
                            if ((removeIndexMask & 2) == 2) {
                                return new OneContextMap(this.keyOne, this.valueOne);
                            }
                            if ((removeIndexMask & 1) == 1) {
                                return new OneContextMap(this.keyTwo, this.valueTwo);
                            }
                            return new TwoContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                        }
                        if ((removeIndexMask & 2) == 2) {
                            if ((removeIndexMask & 1) == 1) {
                                return new OneContextMap(this.keyThree, this.valueThree);
                            }
                            return new TwoContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                        }
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    }
                    if ((removeIndexMask & 4) == 4) {
                        if ((removeIndexMask & 2) == 2) {
                            if ((removeIndexMask & 1) == 1) {
                                return new OneContextMap(this.keyFour, this.valueFour);
                            }
                            return new TwoContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                        }
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask & 8) == 8) {
                    if ((removeIndexMask & 4) == 4) {
                        if ((removeIndexMask & 2) == 2) {
                            if ((removeIndexMask & 1) == 1) {
                                return new OneContextMap(this.keyFive, this.valueFive);
                            }
                            return new TwoContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive);
                        }
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new FourContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask & 0x10) == 16) {
                if ((removeIndexMask & 8) == 8) {
                    if ((removeIndexMask & 4) == 4) {
                        if ((removeIndexMask & 2) == 2) {
                            if ((removeIndexMask & 1) == 1) {
                                return new OneContextMap(this.keySix, this.valueSix);
                            }
                            return new TwoContextMap(this.keyOne, this.valueOne, this.keySix, this.valueSix);
                        }
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyTwo, this.valueTwo, this.keySix, this.valueSix);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyThree, this.valueThree, this.keySix, this.valueSix);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyFour, this.valueFour, this.keySix, this.valueSix);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new FourContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
                }
                return new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keySix, this.valueSix);
            }
            if ((removeIndexMask & 8) == 8) {
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new TwoContextMap(this.keyFive, this.valueFive, this.keySix, this.valueSix);
                        }
                        return new ThreeContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new FourContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask & 4) == 4) {
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new ThreeContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                    }
                    return new FourContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new FourContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask & 2) == 2) {
                if ((removeIndexMask & 1) == 1) {
                    return new FourContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
                }
                return new FiveContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            if ((removeIndexMask & 1) == 1) {
                return new FiveContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, this.keySix, this.valueSix);
            }
            return null;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            if (!consumer.test(this.keyFour, this.valueFour)) {
                return this.keyFour;
            }
            if (!consumer.test(this.keyFive, this.valueFive)) {
                return this.keyFive;
            }
            return consumer.test(this.keySix, this.valueSix) ? null : this.keySix;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            result = 31 * result + this.keyTwo.hashCode();
            result = 31 * result + Objects.hashCode(this.valueTwo);
            result = 31 * result + this.keyThree.hashCode();
            result = 31 * result + Objects.hashCode(this.valueThree);
            result = 31 * result + this.keyFour.hashCode();
            result = 31 * result + Objects.hashCode(this.valueFour);
            result = 31 * result + this.keyFive.hashCode();
            result = 31 * result + Objects.hashCode(this.valueFive);
            result = 31 * result + this.keySix.hashCode();
            result = 31 * result + Objects.hashCode(this.valueSix);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SixContextMap that = (SixContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne) && this.keyTwo.equals(that.keyTwo) && Objects.equals(this.valueTwo, that.valueTwo) && this.keyThree.equals(that.keyThree) && Objects.equals(this.valueThree, that.valueThree) && this.keyFour.equals(that.keyFour) && Objects.equals(this.valueFour, that.valueFour) && this.keyFive.equals(that.keyFive) && Objects.equals(this.valueFive, that.valueFive) && this.keySix.equals(that.keySix) && Objects.equals(this.valueSix, that.valueSix);
        }
    }

    private static final class FiveContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;
        private final ContextMap.Key<?> keyTwo;
        @Nullable
        private final Object valueTwo;
        private final ContextMap.Key<?> keyThree;
        @Nullable
        private final Object valueThree;
        private final ContextMap.Key<?> keyFour;
        @Nullable
        private final Object valueFour;
        private final ContextMap.Key<?> keyFive;
        @Nullable
        private final Object valueFive;

        FiveContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne, ContextMap.Key<?> keyTwo, @Nullable Object valueTwo, ContextMap.Key<?> keyThree, @Nullable Object valueThree, ContextMap.Key<?> keyFour, @Nullable Object valueFour, ContextMap.Key<?> keyFive, @Nullable Object valueFive) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
            this.keyFive = keyFive;
            this.valueFive = valueFive;
        }

        @Override
        public int size() {
            return 5;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne) || key.equals(this.keyTwo) || key.equals(this.keyThree) || key.equals(this.keyFour) || key.equals(this.keyFive);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne) || Objects.equals(value, this.valueTwo) || Objects.equals(value, this.valueThree) || Objects.equals(value, this.valueFour) || Objects.equals(value, this.valueFive);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return key.equals(this.keyOne) && Objects.equals(value, this.valueOne) || key.equals(this.keyTwo) && Objects.equals(value, this.valueTwo) || key.equals(this.keyThree) && Objects.equals(value, this.valueThree) || key.equals(this.keyFour) && Objects.equals(value, this.valueFour) || key.equals(this.keyFive) && Objects.equals(value, this.valueFive);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : (key.equals(this.keyFive) ? this.valueFive : null)))));
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : (key.equals(this.keyFive) ? this.valueFive : defaultValue)))));
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueOne : owner.put(key, value));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueTwo : owner.put(key, value));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueThree : owner.put(key, value));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive)) ? this.valueFour : owner.put(key, value));
            }
            if (key.equals(this.keyFive)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? this.valueFive : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueFour;
            }
            if (key.equals(this.keyFive)) {
                if (this.valueFive == null) {
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueFive;
            }
            return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value, this.keyFive, this.valueFive)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueFour;
            }
            if (key.equals(this.keyFive)) {
                if (this.valueFive == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueFive;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new SixContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            builder.addPair(this.keyTwo, this.valueTwo);
            builder.addPair(this.keyThree, this.valueThree);
            builder.addPair(this.keyFour, this.valueFour);
            builder.addPair(this.keyFive, this.valueFive);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueOne : owner.remove(key));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueTwo : owner.remove(key));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive)) ? this.valueThree : owner.remove(key));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive)) ? this.valueFour : owner.remove(key));
            }
            if (key.equals(this.keyFive)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueFive : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            CopyContextMap newMap = this.removeAll(this.removeIndexMask(keys));
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        private int removeIndexMask(Iterable<ContextMap.Key<?>> keys) {
            int mask = 0;
            for (ContextMap.Key<?> k : keys) {
                if (k.equals(this.keyOne)) {
                    mask |= 1;
                    continue;
                }
                if (k.equals(this.keyTwo)) {
                    mask |= 2;
                    continue;
                }
                if (k.equals(this.keyThree)) {
                    mask |= 4;
                    continue;
                }
                if (k.equals(this.keyFour)) {
                    mask |= 8;
                    continue;
                }
                if (!k.equals(this.keyFive)) continue;
                mask |= 0x10;
            }
            return mask;
        }

        @Nullable
        private CopyContextMap removeAll(int removeIndexMask) {
            if ((removeIndexMask & 0x1F) == 31) {
                return EmptyContextMap.INSTANCE;
            }
            if ((removeIndexMask & 0x10) == 16) {
                if ((removeIndexMask & 8) == 8) {
                    if ((removeIndexMask & 4) == 4) {
                        if ((removeIndexMask & 2) == 2) {
                            return new OneContextMap(this.keyOne, this.valueOne);
                        }
                        if ((removeIndexMask & 1) == 1) {
                            return new OneContextMap(this.keyTwo, this.valueTwo);
                        }
                        return new TwoContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                    }
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new OneContextMap(this.keyThree, this.valueThree);
                        }
                        return new TwoContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new OneContextMap(this.keyFour, this.valueFour);
                        }
                        return new TwoContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask & 8) == 8) {
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        if ((removeIndexMask & 1) == 1) {
                            return new OneContextMap(this.keyFive, this.valueFive);
                        }
                        return new TwoContextMap(this.keyOne, this.valueOne, this.keyFive, this.valueFive);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
                }
                return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask & 4) == 4) {
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new TwoContextMap(this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                    }
                    return new ThreeContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask & 2) == 2) {
                if ((removeIndexMask & 1) == 1) {
                    return new ThreeContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
                }
                return new FourContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            if ((removeIndexMask & 1) == 1) {
                return new FourContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, this.keyFive, this.valueFive);
            }
            return null;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            if (!consumer.test(this.keyFour, this.valueFour)) {
                return this.keyFour;
            }
            return consumer.test(this.keyFive, this.valueFive) ? null : this.keyFive;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            result = 31 * result + this.keyTwo.hashCode();
            result = 31 * result + Objects.hashCode(this.valueTwo);
            result = 31 * result + this.keyThree.hashCode();
            result = 31 * result + Objects.hashCode(this.valueThree);
            result = 31 * result + this.keyFour.hashCode();
            result = 31 * result + Objects.hashCode(this.valueFour);
            result = 31 * result + this.keyFive.hashCode();
            result = 31 * result + Objects.hashCode(this.valueFive);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FiveContextMap that = (FiveContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne) && this.keyTwo.equals(that.keyTwo) && Objects.equals(this.valueTwo, that.valueTwo) && this.keyThree.equals(that.keyThree) && Objects.equals(this.valueThree, that.valueThree) && this.keyFour.equals(that.keyFour) && Objects.equals(this.valueFour, that.valueFour) && this.keyFive.equals(that.keyFive) && Objects.equals(this.valueFive, that.valueFive);
        }
    }

    private static final class FourContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;
        private final ContextMap.Key<?> keyTwo;
        @Nullable
        private final Object valueTwo;
        private final ContextMap.Key<?> keyThree;
        @Nullable
        private final Object valueThree;
        private final ContextMap.Key<?> keyFour;
        @Nullable
        private final Object valueFour;

        FourContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne, ContextMap.Key<?> keyTwo, @Nullable Object valueTwo, ContextMap.Key<?> keyThree, @Nullable Object valueThree, ContextMap.Key<?> keyFour, @Nullable Object valueFour) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
            this.keyFour = keyFour;
            this.valueFour = valueFour;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne) || key.equals(this.keyTwo) || key.equals(this.keyThree) || key.equals(this.keyFour);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne) || Objects.equals(value, this.valueTwo) || Objects.equals(value, this.valueThree) || Objects.equals(value, this.valueFour);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return key.equals(this.keyOne) && Objects.equals(value, this.valueOne) || key.equals(this.keyTwo) && Objects.equals(value, this.valueTwo) || key.equals(this.keyThree) && Objects.equals(value, this.valueThree) || key.equals(this.keyFour) && Objects.equals(value, this.valueFour);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : null))));
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : (key.equals(this.keyFour) ? this.valueFour : defaultValue))));
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueOne : owner.put(key, value));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueTwo : owner.put(key, value));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour)) ? this.valueThree : owner.put(key, value));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? this.valueFour : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueFour;
            }
            return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueTwo;
            }
            if (key.equals(this.keyThree)) {
                if (this.valueThree == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value, this.keyFour, this.valueFour)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueThree;
            }
            if (key.equals(this.keyFour)) {
                if (this.valueFour == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueFour;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new FiveContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            builder.addPair(this.keyTwo, this.valueTwo);
            builder.addPair(this.keyThree, this.valueThree);
            builder.addPair(this.keyFour, this.valueFour);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueOne : owner.remove(key));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour)) ? this.valueTwo : owner.remove(key));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour)) ? this.valueThree : owner.remove(key));
            }
            if (key.equals(this.keyFour)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueFour : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            CopyContextMap newMap = this.removeAll(this.removeIndexMask(keys));
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        private int removeIndexMask(Iterable<ContextMap.Key<?>> keys) {
            int mask = 0;
            for (ContextMap.Key<?> k : keys) {
                if (k.equals(this.keyOne)) {
                    mask |= 1;
                    continue;
                }
                if (k.equals(this.keyTwo)) {
                    mask |= 2;
                    continue;
                }
                if (k.equals(this.keyThree)) {
                    mask |= 4;
                    continue;
                }
                if (!k.equals(this.keyFour)) continue;
                mask |= 8;
            }
            return mask;
        }

        @Nullable
        private CopyContextMap removeAll(int removeIndexMask) {
            if ((removeIndexMask & 0xF) == 15) {
                return EmptyContextMap.INSTANCE;
            }
            if ((removeIndexMask & 8) == 8) {
                if ((removeIndexMask & 4) == 4) {
                    if ((removeIndexMask & 2) == 2) {
                        return new OneContextMap(this.keyOne, this.valueOne);
                    }
                    if ((removeIndexMask & 1) == 1) {
                        return new OneContextMap(this.keyTwo, this.valueTwo);
                    }
                    return new TwoContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
                }
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new OneContextMap(this.keyThree, this.valueThree);
                    }
                    return new TwoContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
                }
                return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }
            if ((removeIndexMask & 4) == 4) {
                if ((removeIndexMask & 2) == 2) {
                    if ((removeIndexMask & 1) == 1) {
                        return new OneContextMap(this.keyFour, this.valueFour);
                    }
                    return new TwoContextMap(this.keyOne, this.valueOne, this.keyFour, this.valueFour);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
                }
                return new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask & 2) == 2) {
                if ((removeIndexMask & 1) == 1) {
                    return new TwoContextMap(this.keyThree, this.valueThree, this.keyFour, this.valueFour);
                }
                return new ThreeContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            if ((removeIndexMask & 1) == 1) {
                return new ThreeContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, this.keyFour, this.valueFour);
            }
            return null;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            if (!consumer.test(this.keyThree, this.valueThree)) {
                return this.keyThree;
            }
            return consumer.test(this.keyFour, this.valueFour) ? null : this.keyFour;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            result = 31 * result + this.keyTwo.hashCode();
            result = 31 * result + Objects.hashCode(this.valueTwo);
            result = 31 * result + this.keyThree.hashCode();
            result = 31 * result + Objects.hashCode(this.valueThree);
            result = 31 * result + this.keyFour.hashCode();
            result = 31 * result + Objects.hashCode(this.valueFour);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FourContextMap that = (FourContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne) && this.keyTwo.equals(that.keyTwo) && Objects.equals(this.valueTwo, that.valueTwo) && this.keyThree.equals(that.keyThree) && Objects.equals(this.valueThree, that.valueThree) && this.keyFour.equals(that.keyFour) && Objects.equals(this.valueFour, that.valueFour);
        }
    }

    private static final class ThreeContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;
        private final ContextMap.Key<?> keyTwo;
        @Nullable
        private final Object valueTwo;
        private final ContextMap.Key<?> keyThree;
        @Nullable
        private final Object valueThree;

        ThreeContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne, ContextMap.Key<?> keyTwo, @Nullable Object valueTwo, ContextMap.Key<?> keyThree, @Nullable Object valueThree) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
            this.keyThree = keyThree;
            this.valueThree = valueThree;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne) || key.equals(this.keyTwo) || key.equals(this.keyThree);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne) || Objects.equals(value, this.valueTwo) || Objects.equals(value, this.valueThree);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return key.equals(this.keyOne) && Objects.equals(value, this.valueOne) || key.equals(this.keyTwo) && Objects.equals(value, this.valueTwo) || key.equals(this.keyThree) && Objects.equals(value, this.valueThree);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : null)));
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : (key.equals(this.keyThree) ? this.valueThree : defaultValue)));
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (this.keyOne.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueOne : owner.put(key, value));
            }
            if (this.keyTwo.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree)) ? this.valueTwo : owner.put(key, value));
            }
            if (this.keyThree.equals(key)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? this.valueThree : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (this.keyOne.equals(key)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            if (this.keyTwo.equals(key)) {
                if (this.valueTwo == null) {
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueTwo;
            }
            if (this.keyThree.equals(key)) {
                if (this.valueThree == null) {
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueThree;
            }
            return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (this.keyOne.equals(key)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(key, value, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            if (this.keyTwo.equals(key)) {
                if (this.valueTwo == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, key, value, this.keyThree, this.valueThree)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueTwo;
            }
            if (this.keyThree.equals(key)) {
                if (this.valueThree == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueThree;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new FourContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, this.keyThree, this.valueThree, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            builder.addPair(this.keyTwo, this.valueTwo);
            builder.addPair(this.keyThree, this.valueThree);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree)) ? this.valueOne : owner.remove(key));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree)) ? this.valueTwo : owner.remove(key));
            }
            if (key.equals(this.keyThree)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo)) ? this.valueThree : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            CopyContextMap newMap = this.removeAll(this.removeIndexMask(keys));
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        private int removeIndexMask(Iterable<ContextMap.Key<?>> keys) {
            int mask = 0;
            for (ContextMap.Key<?> k : keys) {
                if (k.equals(this.keyOne)) {
                    mask |= 1;
                    continue;
                }
                if (k.equals(this.keyTwo)) {
                    mask |= 2;
                    continue;
                }
                if (!k.equals(this.keyThree)) continue;
                mask |= 4;
            }
            return mask;
        }

        @Nullable
        private CopyContextMap removeAll(int removeIndexMask) {
            if ((removeIndexMask & 7) == 7) {
                return EmptyContextMap.INSTANCE;
            }
            if ((removeIndexMask & 4) == 4) {
                if ((removeIndexMask & 2) == 2) {
                    return new OneContextMap(this.keyOne, this.valueOne);
                }
                if ((removeIndexMask & 1) == 1) {
                    return new OneContextMap(this.keyTwo, this.valueTwo);
                }
                return new TwoContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo);
            }
            if ((removeIndexMask & 2) == 2) {
                if ((removeIndexMask & 1) == 1) {
                    return new OneContextMap(this.keyThree, this.valueThree);
                }
                return new TwoContextMap(this.keyOne, this.valueOne, this.keyThree, this.valueThree);
            }
            if ((removeIndexMask & 1) == 1) {
                return new TwoContextMap(this.keyTwo, this.valueTwo, this.keyThree, this.valueThree);
            }
            return null;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            if (!consumer.test(this.keyTwo, this.valueTwo)) {
                return this.keyTwo;
            }
            return consumer.test(this.keyThree, this.valueThree) ? null : this.keyThree;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            result = 31 * result + this.keyTwo.hashCode();
            result = 31 * result + Objects.hashCode(this.valueTwo);
            result = 31 * result + this.keyThree.hashCode();
            result = 31 * result + Objects.hashCode(this.valueThree);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreeContextMap that = (ThreeContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne) && this.keyTwo.equals(that.keyTwo) && Objects.equals(this.valueTwo, that.valueTwo) && this.keyThree.equals(that.keyThree) && Objects.equals(this.valueThree, that.valueThree);
        }
    }

    private static final class TwoContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;
        private final ContextMap.Key<?> keyTwo;
        @Nullable
        private final Object valueTwo;

        TwoContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne, ContextMap.Key<?> keyTwo, @Nullable Object valueTwo) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
            this.keyTwo = keyTwo;
            this.valueTwo = valueTwo;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne) || key.equals(this.keyTwo);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne) || Objects.equals(value, this.valueTwo);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return key.equals(this.keyOne) && Objects.equals(value, this.valueOne) || key.equals(this.keyTwo) && Objects.equals(value, this.valueTwo);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : null));
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : (key.equals(this.keyTwo) ? this.valueTwo : defaultValue));
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoContextMap(key, value, this.keyTwo, this.valueTwo)) ? this.valueOne : owner.put(key, value));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? this.valueTwo : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new TwoContextMap(key, value, this.keyTwo, this.valueTwo)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    return mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueTwo;
            }
            return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new TwoContextMap(key, value, this.keyTwo, this.valueTwo)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            if (key.equals(this.keyTwo)) {
                if (this.valueTwo == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueTwo;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new ThreeContextMap(this.keyOne, this.valueOne, this.keyTwo, this.valueTwo, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            builder.addPair(this.keyTwo, this.valueTwo);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneContextMap(this.keyTwo, this.valueTwo)) ? this.valueOne : owner.remove(key));
            }
            if (key.equals(this.keyTwo)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneContextMap(this.keyOne, this.valueOne)) ? this.valueTwo : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            CopyContextMap newMap = this.removeAll(this.removeIndexMask(keys));
            if (newMap == null) {
                return false;
            }
            return mapUpdater.compareAndSet(owner, this, newMap) || owner.removeAll(keys);
        }

        private int removeIndexMask(Iterable<ContextMap.Key<?>> keys) {
            int mask = 0;
            for (ContextMap.Key<?> k : keys) {
                if (k.equals(this.keyOne)) {
                    mask |= 1;
                    continue;
                }
                if (!k.equals(this.keyTwo)) continue;
                mask |= 2;
            }
            return mask;
        }

        @Nullable
        private CopyContextMap removeAll(int removeIndexMask) {
            if ((removeIndexMask & 3) == 3) {
                return EmptyContextMap.INSTANCE;
            }
            if ((removeIndexMask & 2) == 2) {
                return new OneContextMap(this.keyOne, this.valueOne);
            }
            if ((removeIndexMask & 1) == 1) {
                return new OneContextMap(this.keyTwo, this.valueTwo);
            }
            return null;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            if (!consumer.test(this.keyOne, this.valueOne)) {
                return this.keyOne;
            }
            return consumer.test(this.keyTwo, this.valueTwo) ? null : this.keyTwo;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            result = 31 * result + this.keyTwo.hashCode();
            result = 31 * result + Objects.hashCode(this.valueTwo);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoContextMap that = (TwoContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne) && this.keyTwo.equals(that.keyTwo) && Objects.equals(this.valueTwo, that.valueTwo);
        }
    }

    private static final class OneContextMap
    implements CopyContextMap {
        private final ContextMap.Key<?> keyOne;
        @Nullable
        private final Object valueOne;

        OneContextMap(ContextMap.Key<?> keyOne, @Nullable Object valueOne) {
            this.keyOne = keyOne;
            this.valueOne = valueOne;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return key.equals(this.keyOne);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return Objects.equals(value, this.valueOne);
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return this.containsKey(key) && this.containsValue(value);
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : null);
        }

        @Override
        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return (T)(key.equals(this.keyOne) ? this.valueOne : defaultValue);
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, new OneContextMap(key, value)) ? this.valueOne : owner.put(key, value));
            }
            return mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    return mapUpdater.compareAndSet(owner, this, new OneContextMap(key, value)) ? null : (T)owner.putIfAbsent(key, value);
                }
                return (T)this.valueOne;
            }
            return mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                if (this.valueOne == null) {
                    T value = computeFunction.apply(key);
                    return mapUpdater.compareAndSet(owner, this, new OneContextMap(key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
                }
                return (T)this.valueOne;
            }
            T value = computeFunction.apply(key);
            return mapUpdater.compareAndSet(owner, this, new TwoContextMap(this.keyOne, this.valueOne, key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(this.size() + mapSize);
            builder.addPair(this.keyOne, this.valueOne);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            if (key.equals(this.keyOne)) {
                return (T)(mapUpdater.compareAndSet(owner, this, EmptyContextMap.INSTANCE) ? this.valueOne : owner.remove(key));
            }
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            for (ContextMap.Key<?> k : keys) {
                if (!k.equals(this.keyOne)) continue;
                return mapUpdater.compareAndSet(owner, this, EmptyContextMap.INSTANCE) || owner.removeAll(keys);
            }
            return false;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            return consumer.test(this.keyOne, this.valueOne) ? null : this.keyOne;
        }

        @Override
        public int hashCode() {
            int result = this.keyOne.hashCode();
            result = 31 * result + Objects.hashCode(this.valueOne);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OneContextMap that = (OneContextMap)o;
            return this.keyOne.equals(that.keyOne) && Objects.equals(this.valueOne, that.valueOne);
        }
    }

    private static final class EmptyContextMap
    implements CopyContextMap {
        static final CopyContextMap INSTANCE = new EmptyContextMap();

        private EmptyContextMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(ContextMap.Key<?> key) {
            return false;
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return false;
        }

        @Override
        public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
            return false;
        }

        @Override
        @Nullable
        public <T> T get(ContextMap.Key<T> key) {
            return null;
        }

        @Override
        public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
            return defaultValue;
        }

        @Override
        @Nullable
        public <T> T put(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            return mapUpdater.compareAndSet(owner, this, new OneContextMap(Objects.requireNonNull(key), value)) ? null : (T)owner.put(key, value);
        }

        @Override
        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            return mapUpdater.compareAndSet(owner, this, new OneContextMap(Objects.requireNonNull(key), value)) ? null : (T)owner.putIfAbsent(key, value);
        }

        @Override
        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            T value = computeFunction.apply(Objects.requireNonNull(key));
            return mapUpdater.compareAndSet(owner, this, new OneContextMap(key, value)) ? value : owner.computeIfAbsent(key, computeFunction);
        }

        @Override
        public CopyContextMap putAll(int mapSize, Consumer<PutAllBuilder> forEach) {
            PutAllBuilder builder = new PutAllBuilder(mapSize);
            forEach.accept(builder);
            return builder.build();
        }

        @Override
        @Nullable
        public <T> T remove(ContextMap.Key<T> key, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            Objects.requireNonNull(key);
            return null;
        }

        @Override
        public boolean removeAll(Iterable<ContextMap.Key<?>> keys, CopyOnWriteContextMap owner, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> mapUpdater) {
            Objects.requireNonNull(keys);
            return false;
        }

        @Override
        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
            return null;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }

    private static interface CopyContextMap {
        public int size();

        public boolean isEmpty();

        public boolean containsKey(ContextMap.Key<?> var1);

        public boolean containsValue(@Nullable Object var1);

        public <T> boolean contains(ContextMap.Key<T> var1, @Nullable T var2);

        @Nullable
        public <T> T get(ContextMap.Key<T> var1);

        @Nullable
        public <T> T getOrDefault(ContextMap.Key<T> var1, T var2);

        @Nullable
        public <T> T put(ContextMap.Key<T> var1, @Nullable T var2, CopyOnWriteContextMap var3, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> var4);

        @Nullable
        public <T> T putIfAbsent(ContextMap.Key<T> var1, @Nullable T var2, CopyOnWriteContextMap var3, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> var4);

        @Nullable
        public <T> T computeIfAbsent(ContextMap.Key<T> var1, Function<ContextMap.Key<T>, T> var2, CopyOnWriteContextMap var3, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> var4);

        public CopyContextMap putAll(int var1, Consumer<PutAllBuilder> var2);

        @Nullable
        public <T> T remove(ContextMap.Key<T> var1, CopyOnWriteContextMap var2, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> var3);

        public boolean removeAll(Iterable<ContextMap.Key<?>> var1, CopyOnWriteContextMap var2, AtomicReferenceFieldUpdater<CopyOnWriteContextMap, CopyContextMap> var3);

        @Nullable
        public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> var1);

        public boolean equals(Object var1);

        public int hashCode();
    }
}

