/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorCompletePublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Predicate<? super Throwable> predicate;

    OnErrorCompletePublisher(Publisher<T> original, Predicate<? super Throwable> predicate) {
        super(original);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new OnErrorCompleteSubscriber(subscriber, this.predicate);
    }

    private static final class OnErrorCompleteSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final Predicate<? super Throwable> predicate;

        private OnErrorCompleteSubscriber(PublisherSource.Subscriber<? super T> subscriber, Predicate<? super Throwable> predicate) {
            this.subscriber = subscriber;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean predicateResult;
            try {
                predicateResult = this.predicate.test(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (predicateResult) {
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

