/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Supplier;

final class SingleDefer<T>
extends Single<T>
implements SingleSource<T> {
    private final Supplier<? extends Single<? extends T>> singleFactory;

    SingleDefer(Supplier<? extends Single<? extends T>> singleFactory) {
        this.singleFactory = Objects.requireNonNull(singleFactory);
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        Single<? super T> single;
        try {
            single = Objects.requireNonNull(this.singleFactory.get(), () -> "Factory " + this.singleFactory + " returned null");
        }
        catch (Throwable cause) {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)cause);
            return;
        }
        single.subscribeInternal(subscriber);
    }

    @Override
    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

