/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.javapoet.ClassName;
import io.servicetalk.grpc.protoc.FileDescriptor;
import io.servicetalk.grpc.protoc.Generator;
import io.servicetalk.grpc.protoc.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Main {
    private static final String TYPE_NAME_SUFFIX_OPTION = "typeNameSuffix";
    private static final String PRINT_JAVA_DOCS_OPTION = "javaDocs";

    private Main() {
    }

    public static void main(String ... args) throws IOException {
        Main.safeGenerate(PluginProtos.CodeGeneratorRequest.parseFrom(System.in)).writeTo(System.out);
    }

    private static PluginProtos.CodeGeneratorResponse safeGenerate(PluginProtos.CodeGeneratorRequest request) {
        try {
            return Main.generate(request);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(1024);
            sw.append("ServiceTalk code generation failed: ");
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
            }
            return PluginProtos.CodeGeneratorResponse.newBuilder().setError(sw.toString()).build();
        }
    }

    private static PluginProtos.CodeGeneratorResponse generate(PluginProtos.CodeGeneratorRequest request) {
        PluginProtos.CodeGeneratorResponse.Builder responseBuilder = PluginProtos.CodeGeneratorResponse.newBuilder().setSupportedFeatures(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL.getNumber());
        HashSet<String> filesToGenerate = new HashSet<String>(request.getFileToGenerateList());
        Map optionsMap = request.hasParameter() ? StringUtils.parseOptions(request.getParameter()) : Collections.emptyMap();
        String typeSuffixValue = (String)optionsMap.get(TYPE_NAME_SUFFIX_OPTION);
        boolean printJavaDocs = Boolean.parseBoolean(optionsMap.getOrDefault(PRINT_JAVA_DOCS_OPTION, "true"));
        List fileDescriptors = request.getProtoFileList().stream().map(protoFile -> new FileDescriptor((DescriptorProtos.FileDescriptorProto)protoFile, typeSuffixValue)).collect(Collectors.toList());
        Map<String, ClassName> messageTypesMap = fileDescriptors.stream().map(FileDescriptor::messageTypesMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (FileDescriptor f : fileDescriptors) {
            if (!filesToGenerate.contains(f.protoFileName())) continue;
            Generator generator = new Generator(f, messageTypesMap, printJavaDocs, f.sourceCodeInfo());
            List<DescriptorProtos.ServiceDescriptorProto> serviceDescriptorProtoList = f.protoServices();
            for (int i = 0; i < serviceDescriptorProtoList.size(); ++i) {
                DescriptorProtos.ServiceDescriptorProto serviceDescriptor = serviceDescriptorProtoList.get(i);
                generator.generate(f, serviceDescriptor, i);
            }
            f.writeTo(responseBuilder);
        }
        return responseBuilder.build();
    }
}

