/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.predicate;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;

final class DefaultFallbackServiceStreaming
implements StreamingHttpService {
    private static final DefaultFallbackServiceStreaming INSTANCE = new DefaultFallbackServiceStreaming();

    private DefaultFallbackServiceStreaming() {
    }

    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory factory) {
        StreamingHttpResponse response = factory.newResponse(HttpResponseStatus.NOT_FOUND).version(request.version());
        response.headers().set(HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO).set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN);
        return Single.succeeded((Object)response);
    }

    static StreamingHttpService instance() {
        return INSTANCE;
    }
}

