/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.predicate;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToOffloadedStreamingHttpService;
import io.servicetalk.http.router.predicate.Route;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.IoThreadFactory;
import java.util.List;
import java.util.Objects;

final class InOrderRouter
implements StreamingHttpService {
    private final StreamingHttpService fallbackService;
    private final Route[] routes;
    private final AsyncCloseable closeable;

    InOrderRouter(StreamingHttpService fallbackService, List<Route> routes) {
        this.fallbackService = Objects.requireNonNull(fallbackService);
        this.routes = routes.toArray(new Route[0]);
        this.closeable = AsyncCloseables.newCompositeCloseable().mergeAll(new AsyncCloseable[]{fallbackService}).mergeAll((AsyncCloseable[])routes.stream().map(Route::service).toArray(StreamingHttpService[]::new));
    }

    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory factory) {
        for (Route pair : this.routes) {
            if (!pair.predicate().test((ConnectionContext)ctx, request)) continue;
            StreamingHttpService service = pair.service();
            HttpExecutionStrategy strategy = pair.routeStrategy();
            HttpExecutionContext useContext = ctx.executionContext();
            if (null != strategy && useContext.executionStrategy().missing(strategy).hasOffloads()) {
                service = StreamingHttpServiceToOffloadedStreamingHttpService.offloadService((HttpExecutionStrategy)strategy, (Executor)useContext.executor(), IoThreadFactory.IoThread::currentThreadIsIoThread, (StreamingHttpService)service);
            }
            return service.handle(ctx, request, factory);
        }
        return this.fallbackService.handle(ctx, request, factory);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadAll();
    }

    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }
}

