/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.predicate;

import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.router.predicate.DefaultFallbackServiceStreaming;
import io.servicetalk.http.router.predicate.InOrderRouter;
import io.servicetalk.http.router.predicate.Predicates;
import io.servicetalk.http.router.predicate.Route;
import io.servicetalk.http.router.predicate.dsl.CookieMatcher;
import io.servicetalk.http.router.predicate.dsl.RouteContinuation;
import io.servicetalk.http.router.predicate.dsl.RouteStarter;
import io.servicetalk.http.router.predicate.dsl.StringMultiValueMatcher;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class HttpPredicateRouterBuilder
implements RouteStarter {
    private final List<Route> routes = new ArrayList<Route>();
    private final RouteContinuationImpl continuation = new RouteContinuationImpl();
    @Nullable
    private BiPredicate<ConnectionContext, StreamingHttpRequest> predicate;

    @Override
    public RouteContinuation whenMethod(HttpRequestMethod method) {
        this.andPredicate(Predicates.method(method));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenMethodIsOneOf(HttpRequestMethod ... methods) {
        this.andPredicate(Predicates.methodIsOneOf(methods));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenPathEquals(String path) {
        this.andPredicate(Predicates.pathEquals(path));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenPathIsOneOf(String ... paths) {
        this.andPredicate(Predicates.pathIsOneOf(paths));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenPathStartsWith(String pathPrefix) {
        this.andPredicate(Predicates.pathStartsWith(pathPrefix));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenPathMatches(String pathRegex) {
        this.andPredicate(Predicates.pathRegex(pathRegex));
        return this.continuation;
    }

    @Override
    public RouteContinuation whenPathMatches(Pattern pathRegex) {
        this.andPredicate(Predicates.pathRegex(pathRegex));
        return this.continuation;
    }

    @Override
    public StringMultiValueMatcher whenQueryParam(String name) {
        Objects.requireNonNull(name);
        return new StringMultiValueMatcherImpl(req -> req.queryParametersIterator(name));
    }

    @Override
    public StringMultiValueMatcher whenHeader(CharSequence name) {
        Objects.requireNonNull(name);
        return new StringMultiValueMatcherImpl(req -> req.headers().valuesIterator(name));
    }

    @Override
    public CookieMatcher whenCookie(String name) {
        Objects.requireNonNull(name);
        return new CookieMatcherImpl(req -> req.headers().getCookiesIterator((CharSequence)name));
    }

    @Override
    public RouteContinuation whenIsSsl() {
        this.andPredicate((ctx, req) -> ctx.sslSession() != null);
        return this.continuation;
    }

    @Override
    public RouteContinuation whenIsNotSsl() {
        this.andPredicate((ctx, req) -> ctx.sslSession() == null);
        return this.continuation;
    }

    @Override
    public RouteContinuation when(Predicate<StreamingHttpRequest> predicate) {
        Objects.requireNonNull(predicate);
        this.andPredicate((ctx, req) -> predicate.test((StreamingHttpRequest)req));
        return this.continuation;
    }

    @Override
    public RouteContinuation when(BiPredicate<ConnectionContext, StreamingHttpRequest> predicate) {
        this.andPredicate(Objects.requireNonNull(predicate));
        return this.continuation;
    }

    @Override
    public StreamingHttpService buildStreaming() {
        return new InOrderRouter(DefaultFallbackServiceStreaming.instance(), this.routes);
    }

    private void andPredicate(BiPredicate<ConnectionContext, StreamingHttpRequest> newPredicate) {
        this.predicate = this.predicate == null ? newPredicate : this.predicate.and(newPredicate);
    }

    private class StringMultiValueMatcherImpl
    implements StringMultiValueMatcher {
        private final Function<StreamingHttpRequest, Iterator<? extends CharSequence>> itemsSource;

        StringMultiValueMatcherImpl(Function<StreamingHttpRequest, Iterator<? extends CharSequence>> itemsSource) {
            this.itemsSource = itemsSource;
        }

        @Override
        public RouteContinuation isPresent() {
            return this.firstValue((CharSequence value) -> true);
        }

        @Override
        public RouteContinuation firstValue(CharSequence value) {
            return this.firstValue(value::equals);
        }

        @Override
        public RouteContinuation firstValue(Predicate<CharSequence> predicate) {
            Objects.requireNonNull(predicate);
            return this.values(iterator -> iterator.hasNext() && predicate.test((CharSequence)iterator.next()));
        }

        @Override
        public RouteContinuation values(Predicate<Iterator<? extends CharSequence>> predicate) {
            HttpPredicateRouterBuilder.this.andPredicate((ctx, req) -> predicate.test(this.itemsSource.apply((StreamingHttpRequest)req)));
            return HttpPredicateRouterBuilder.this.continuation;
        }

        @Override
        public RouteContinuation firstValueMatches(String regex) {
            return this.firstValue(Predicates.regex(regex));
        }

        @Override
        public RouteContinuation firstValueMatches(Pattern regex) {
            return this.firstValue(Predicates.regex(regex));
        }
    }

    private class CookieMatcherImpl
    implements CookieMatcher {
        private final Function<StreamingHttpRequest, Iterator<? extends HttpCookiePair>> itemsSource;

        CookieMatcherImpl(Function<StreamingHttpRequest, Iterator<? extends HttpCookiePair>> itemsSource) {
            this.itemsSource = itemsSource;
        }

        @Override
        public RouteContinuation isPresent() {
            return this.value(v -> true);
        }

        @Override
        public RouteContinuation value(Predicate<HttpCookiePair> predicate) {
            return this.values(cookies -> {
                while (cookies.hasNext()) {
                    if (!predicate.test((HttpCookiePair)cookies.next())) continue;
                    return true;
                }
                return false;
            });
        }

        @Override
        public RouteContinuation values(Predicate<Iterator<? extends HttpCookiePair>> predicate) {
            HttpPredicateRouterBuilder.this.andPredicate((ctx, req) -> predicate.test(this.itemsSource.apply((StreamingHttpRequest)req)));
            return HttpPredicateRouterBuilder.this.continuation;
        }
    }

    private class RouteContinuationImpl
    implements RouteContinuation {
        @Nullable
        private HttpExecutionStrategy strategy;

        private RouteContinuationImpl() {
        }

        @Override
        public RouteContinuation andMethod(HttpRequestMethod method) {
            return HttpPredicateRouterBuilder.this.whenMethod(method);
        }

        @Override
        public RouteContinuation andMethodIsOneOf(HttpRequestMethod ... methods) {
            return HttpPredicateRouterBuilder.this.whenMethodIsOneOf(methods);
        }

        @Override
        public RouteContinuation andPathEquals(String path) {
            return HttpPredicateRouterBuilder.this.whenPathEquals(path);
        }

        @Override
        public RouteContinuation andPathIsOneOf(String ... paths) {
            return HttpPredicateRouterBuilder.this.whenPathIsOneOf(paths);
        }

        @Override
        public RouteContinuation andPathStartsWith(String pathPrefix) {
            return HttpPredicateRouterBuilder.this.whenPathStartsWith(pathPrefix);
        }

        @Override
        public RouteContinuation andPathMatches(String pathRegex) {
            return HttpPredicateRouterBuilder.this.whenPathMatches(pathRegex);
        }

        @Override
        public RouteContinuation andPathMatches(Pattern pathRegex) {
            return HttpPredicateRouterBuilder.this.whenPathMatches(pathRegex);
        }

        @Override
        public StringMultiValueMatcher andQueryParam(String name) {
            return HttpPredicateRouterBuilder.this.whenQueryParam(name);
        }

        @Override
        public StringMultiValueMatcher andHeader(CharSequence name) {
            return HttpPredicateRouterBuilder.this.whenHeader(name);
        }

        @Override
        public CookieMatcher andCookie(String name) {
            return HttpPredicateRouterBuilder.this.whenCookie(name);
        }

        @Override
        public RouteContinuation andIsSsl() {
            return HttpPredicateRouterBuilder.this.whenIsSsl();
        }

        @Override
        public RouteContinuation andIsNotSsl() {
            return HttpPredicateRouterBuilder.this.whenIsNotSsl();
        }

        @Override
        public RouteContinuation and(Predicate<StreamingHttpRequest> predicate) {
            return HttpPredicateRouterBuilder.this.when(predicate);
        }

        @Override
        public RouteContinuation and(BiPredicate<ConnectionContext, StreamingHttpRequest> predicate) {
            return HttpPredicateRouterBuilder.this.when(predicate);
        }

        @Override
        public RouteContinuation executionStrategy(HttpExecutionStrategy routeStrategy) {
            this.strategy = Objects.requireNonNull(routeStrategy);
            return this;
        }

        @Override
        public RouteStarter thenRouteTo(StreamingHttpService service) {
            return this.thenRouteTo0(service, this.serviceOffloads(service));
        }

        @Override
        public RouteStarter thenRouteTo(HttpService service) {
            HttpApiConversions.ServiceAdapterHolder adapterHolder = HttpApiConversions.toStreamingHttpService((HttpService)service, (HttpExecutionStrategy)this.serviceOffloads(service));
            return this.thenRouteTo0(adapterHolder.adaptor(), adapterHolder.serviceInvocationStrategy());
        }

        @Override
        public RouteStarter thenRouteTo(BlockingHttpService service) {
            HttpApiConversions.ServiceAdapterHolder adapterHolder = HttpApiConversions.toStreamingHttpService((BlockingHttpService)service, (HttpExecutionStrategy)this.serviceOffloads(service));
            return this.thenRouteTo0(adapterHolder.adaptor(), adapterHolder.serviceInvocationStrategy());
        }

        @Override
        public RouteStarter thenRouteTo(BlockingStreamingHttpService service) {
            HttpApiConversions.ServiceAdapterHolder adapterHolder = HttpApiConversions.toStreamingHttpService((BlockingStreamingHttpService)service, (HttpExecutionStrategy)this.serviceOffloads(service));
            return this.thenRouteTo0(adapterHolder.adaptor(), adapterHolder.serviceInvocationStrategy());
        }

        private HttpExecutionStrategy serviceOffloads(Object service) {
            return null != this.strategy ? this.strategy : (service instanceof ExecutionStrategyInfluencer ? HttpExecutionStrategy.from((ExecutionStrategy)((ExecutionStrategyInfluencer)service).requiredOffloads()) : HttpExecutionStrategies.defaultStrategy());
        }

        private RouteStarter thenRouteTo0(StreamingHttpService route, @Nullable HttpExecutionStrategy routeStrategy) {
            assert (HttpPredicateRouterBuilder.this.predicate != null);
            HttpPredicateRouterBuilder.this.routes.add(new Route(HttpPredicateRouterBuilder.this.predicate, route, null == this.strategy ? null : routeStrategy));
            HttpPredicateRouterBuilder.this.predicate = null;
            this.strategy = null;
            return HttpPredicateRouterBuilder.this;
        }
    }
}

