/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.security.auth.basic.jersey;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

abstract class AbstractBasicAuthSecurityContextFilter<UserInfo>
implements ContainerRequestFilter {
    @Nullable
    private final AsyncContextMap.Key<UserInfo> userInfoKey;
    private final BiFunction<ContainerRequestContext, UserInfo, SecurityContext> securityContextFunction;

    AbstractBasicAuthSecurityContextFilter(@Nullable AsyncContextMap.Key<UserInfo> userInfoKey, BiFunction<ContainerRequestContext, UserInfo, SecurityContext> securityContextFunction) {
        this.userInfoKey = userInfoKey;
        this.securityContextFunction = securityContextFunction;
    }

    public void filter(ContainerRequestContext requestCtx) {
        SecurityContext securityContext = this.securityContext(requestCtx);
        if (securityContext != null) {
            requestCtx.setSecurityContext(securityContext);
        }
    }

    @Nullable
    private SecurityContext securityContext(ContainerRequestContext requestCtx) {
        if (this.userInfoKey == null) {
            return this.securityContextFunction.apply(requestCtx, null);
        }
        Object userInfo = AsyncContext.get(this.userInfoKey);
        if (userInfo == null) {
            return null;
        }
        return this.securityContextFunction.apply(requestCtx, userInfo);
    }
}

