/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.security.auth.basic.jersey;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.security.auth.basic.jersey.BasicAuthPrincipal;
import io.servicetalk.http.security.auth.basic.jersey.BasicAuthSecurityContext;
import io.servicetalk.http.security.auth.basic.jersey.GlobalBindingBasicAuthSecurityContextFilter;
import io.servicetalk.http.security.auth.basic.jersey.NameBindingBasicAuthSecurityContextFilter;
import java.security.Principal;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

public final class BasicAuthSecurityContextFilters {
    static final Principal ANONYMOUS_PRINCIPAL = () -> "ANONYMOUS";

    private BasicAuthSecurityContextFilters() {
    }

    public static <UserInfo> UserInfoBuilder<UserInfo> forGlobalBinding(final ContextMap.Key<UserInfo> userInfoKey) {
        Objects.requireNonNull(userInfoKey);
        return new UserInfoBuilder<UserInfo>(){

            @Override
            public ContainerRequestFilter build() {
                return new GlobalBindingBasicAuthSecurityContextFilter(userInfoKey, (BiFunction)this.securityContextFunction());
            }
        };
    }

    public static NoUserInfoBuilder forGlobalBinding() {
        return new NoUserInfoBuilder(){

            @Override
            public ContainerRequestFilter build() {
                return new GlobalBindingBasicAuthSecurityContextFilter(null, BasicAuthSecurityContextFilters.asSecurityContextBiFunction((Function)this.securityContextFunction()));
            }
        };
    }

    public static <UserInfo> UserInfoBuilder<UserInfo> forNameBinding(final ContextMap.Key<UserInfo> userInfoKey) {
        Objects.requireNonNull(userInfoKey);
        return new UserInfoBuilder<UserInfo>(){

            @Override
            public ContainerRequestFilter build() {
                return new NameBindingBasicAuthSecurityContextFilter(userInfoKey, (BiFunction)this.securityContextFunction());
            }
        };
    }

    public static NoUserInfoBuilder forNameBinding() {
        return new NoUserInfoBuilder(){

            @Override
            public ContainerRequestFilter build() {
                return new NameBindingBasicAuthSecurityContextFilter(null, BasicAuthSecurityContextFilters.asSecurityContextBiFunction((Function)this.securityContextFunction()));
            }
        };
    }

    private static SecurityContext newAnonymousSecurityContext(ContainerRequestContext requestCtx) {
        return new BasicAuthSecurityContext(ANONYMOUS_PRINCIPAL, BasicAuthSecurityContextFilters.isRequestSecure(requestCtx));
    }

    private static <UserInfo> SecurityContext newSecurityContext(ContainerRequestContext requestCtx, UserInfo userInfo) {
        return new BasicAuthSecurityContext(BasicAuthSecurityContextFilters.newPrincipal(requestCtx, userInfo), BasicAuthSecurityContextFilters.isRequestSecure(requestCtx));
    }

    private static Function<ContainerRequestContext, SecurityContext> asSecurityContextFunction(Function<ContainerRequestContext, Principal> principalFunction) {
        return requestCtx -> new BasicAuthSecurityContext((Principal)principalFunction.apply((ContainerRequestContext)requestCtx), BasicAuthSecurityContextFilters.isRequestSecure(requestCtx));
    }

    private static <UserInfo> BiFunction<ContainerRequestContext, UserInfo, SecurityContext> asSecurityContextBiFunction(BiFunction<ContainerRequestContext, UserInfo, Principal> principalFunction) {
        return (requestCtx, userInfo) -> new BasicAuthSecurityContext((Principal)principalFunction.apply((ContainerRequestContext)requestCtx, (Object)userInfo), BasicAuthSecurityContextFilters.isRequestSecure(requestCtx));
    }

    private static <UserInfo> BiFunction<ContainerRequestContext, UserInfo, SecurityContext> asSecurityContextBiFunction(Function<ContainerRequestContext, SecurityContext> securityContextFunction) {
        return (requestCtx, __) -> (SecurityContext)securityContextFunction.apply((ContainerRequestContext)requestCtx);
    }

    private static <UserInfo> Principal newPrincipal(ContainerRequestContext __, UserInfo userInfo) {
        return userInfo instanceof Principal ? (Principal)userInfo : new BasicAuthPrincipal<UserInfo>(userInfo);
    }

    private static boolean isRequestSecure(ContainerRequestContext requestCtx) {
        return "https".equalsIgnoreCase(requestCtx.getUriInfo().getRequestUri().getScheme());
    }

    public static abstract class NoUserInfoBuilder
    extends AbstractBuilder<NoUserInfoBuilder, Function<ContainerRequestContext, Principal>, Function<ContainerRequestContext, SecurityContext>> {
        NoUserInfoBuilder() {
            super(x$0 -> BasicAuthSecurityContextFilters.asSecurityContextFunction(x$0), x$0 -> BasicAuthSecurityContextFilters.newAnonymousSecurityContext(x$0));
        }
    }

    public static abstract class UserInfoBuilder<UserInfo>
    extends AbstractBuilder<UserInfoBuilder<UserInfo>, BiFunction<ContainerRequestContext, UserInfo, Principal>, BiFunction<ContainerRequestContext, UserInfo, SecurityContext>> {
        UserInfoBuilder() {
            super(x$0 -> BasicAuthSecurityContextFilters.asSecurityContextBiFunction(x$0), (x$0, x$1) -> BasicAuthSecurityContextFilters.newSecurityContext(x$0, x$1));
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, PF, SCF> {
        private final Function<PF, SCF> principalToSecurityContextFunction;
        private SCF securityContextFunction;

        AbstractBuilder(Function<PF, SCF> principalToSecurityContextFunction, SCF securityContextFunction) {
            this.principalToSecurityContextFunction = principalToSecurityContextFunction;
            this.securityContextFunction = securityContextFunction;
        }

        SCF securityContextFunction() {
            return this.securityContextFunction;
        }

        public B principalFunction(PF principalFunction) {
            this.securityContextFunction(this.principalToSecurityContextFunction.apply(Objects.requireNonNull(principalFunction)));
            return (B)this;
        }

        public B securityContextFunction(SCF securityContextFunction) {
            this.securityContextFunction = Objects.requireNonNull(securityContextFunction);
            return (B)this;
        }

        public abstract ContainerRequestFilter build();
    }
}

