/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.security.auth.basic.jersey;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.context.api.ContextMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

abstract class AbstractBasicAuthSecurityContextFilter<UserInfo>
implements ContainerRequestFilter {
    @Nullable
    private final ContextMap.Key<UserInfo> userInfoKey;
    private final BiFunction<ContainerRequestContext, UserInfo, SecurityContext> securityContextFunction;

    AbstractBasicAuthSecurityContextFilter(@Nullable ContextMap.Key<UserInfo> userInfoKey, BiFunction<ContainerRequestContext, UserInfo, SecurityContext> securityContextFunction) {
        this.userInfoKey = userInfoKey;
        this.securityContextFunction = securityContextFunction;
    }

    public void filter(ContainerRequestContext requestCtx) {
        SecurityContext securityContext = this.securityContext(requestCtx);
        if (securityContext != null) {
            requestCtx.setSecurityContext(securityContext);
        }
    }

    @Nullable
    private SecurityContext securityContext(ContainerRequestContext requestCtx) {
        if (this.userInfoKey != null) {
            Object userInfo = AsyncContext.get(this.userInfoKey);
            return userInfo == null ? null : this.securityContextFunction.apply(requestCtx, userInfo);
        }
        return this.securityContextFunction.apply(requestCtx, null);
    }
}

