/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TimeoutHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    private final Duration duration;
    @Nullable
    private final Executor timeoutExecutor;

    public TimeoutHttpRequesterFilter(Duration duration) {
        this.duration = duration;
        this.timeoutExecutor = null;
    }

    public TimeoutHttpRequesterFilter(Duration duration, Executor timeoutExecutor) {
        this.duration = duration;
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.timeoutExecutor != null ? delegate.request(strategy, request).idleTimeout(this.duration, this.timeoutExecutor) : delegate.request(strategy, request).idleTimeout(this.duration);
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return TimeoutHttpRequesterFilter.this.request(delegate, strategy, request);
            }
        };
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return TimeoutHttpRequesterFilter.this.request((StreamingHttpRequester)this.delegate(), strategy, request);
            }
        };
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }
}

