/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RedirectSingle
extends SubscribableSingle<StreamingHttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectSingle.class);
    private final HttpExecutionStrategy strategy;
    private final SingleSource<StreamingHttpResponse> originalResponse;
    private final StreamingHttpRequest originalRequest;
    private final int maxRedirects;
    private final StreamingHttpRequester requester;
    private final boolean onlyRelative;

    RedirectSingle(HttpExecutionStrategy strategy, Single<StreamingHttpResponse> originalResponse, StreamingHttpRequest originalRequest, int maxRedirects, StreamingHttpRequester requester, boolean onlyRelative) {
        this.strategy = strategy;
        this.originalResponse = SourceAdapters.toSource(originalResponse);
        this.originalRequest = Objects.requireNonNull(originalRequest);
        this.maxRedirects = maxRedirects;
        this.requester = Objects.requireNonNull(requester);
        this.onlyRelative = onlyRelative;
    }

    protected void handleSubscribe(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
        this.originalResponse.subscribe((SingleSource.Subscriber)new RedirectSubscriber(subscriber, this, this.originalRequest));
    }

    private static final class RedirectSubscriber
    implements SingleSource.Subscriber<StreamingHttpResponse> {
        private final SingleSource.Subscriber<? super StreamingHttpResponse> target;
        private final RedirectSingle redirectSingle;
        private final StreamingHttpRequest request;
        @Nullable
        private final String scheme;
        private final int redirectCount;
        private final SequentialCancellable sequentialCancellable;

        RedirectSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> target, RedirectSingle redirectSingle, StreamingHttpRequest request) {
            this(target, redirectSingle, request, 0, new SequentialCancellable());
        }

        RedirectSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> target, RedirectSingle redirectSingle, StreamingHttpRequest request, int redirectCount, SequentialCancellable sequentialCancellable) {
            this.target = target;
            this.redirectSingle = redirectSingle;
            this.request = request;
            this.scheme = request.scheme();
            this.redirectCount = redirectCount;
            this.sequentialCancellable = sequentialCancellable;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.sequentialCancellable.nextCancellable(cancellable);
            if (this.redirectCount == 0) {
                this.target.onSubscribe((Cancellable)this.sequentialCancellable);
            }
        }

        public void onSuccess(@Nullable StreamingHttpResponse result) {
            StreamingHttpRequest newRequest;
            if (result == null || !this.shouldRedirect(this.redirectCount + 1, result, this.request.method())) {
                this.target.onSuccess((Object)result);
                return;
            }
            try {
                newRequest = RedirectSubscriber.prepareRedirectRequest(this.request, result, (StreamingHttpRequestFactory)this.redirectSingle.requester);
            }
            catch (Throwable cause) {
                this.target.onError(cause);
                return;
            }
            if (newRequest == null) {
                this.target.onSuccess((Object)result);
                return;
            }
            String newScheme = newRequest.scheme();
            if (this.redirectSingle.onlyRelative) {
                if (this.request.effectiveHost() == null || !this.request.effectiveHost().equalsIgnoreCase(newRequest.effectiveHost()) || this.request.effectivePort() != newRequest.effectivePort()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ignoring non-relative redirect to '{}' for original request '{}': {}", new Object[]{newRequest.requestTarget(), this.redirectSingle.originalRequest, "Only relative redirects are allowed"});
                    }
                    this.target.onSuccess((Object)result);
                    return;
                }
                if (newScheme != null) {
                    newRequest.requestTarget(RedirectSubscriber.absoluteToRelativeFormRequestTarget(newRequest.requestTarget(), newScheme));
                }
            } else if (newScheme == null && this.scheme != null) {
                newRequest.requestTarget(this.scheme + "://" + newRequest.headers().get(HttpHeaderNames.HOST) + newRequest.requestTarget());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Execute redirect to '{}' for original request '{}'", (Object)result.headers().get(HttpHeaderNames.LOCATION), (Object)this.redirectSingle.originalRequest);
            }
            SourceAdapters.toSource((Single)result.payloadBodyAndTrailers().ignoreElements().concat(this.redirectSingle.requester.request(this.redirectSingle.strategy, newRequest))).subscribe((SingleSource.Subscriber)new RedirectSubscriber(this.target, this.redirectSingle, newRequest, this.redirectCount + 1, this.sequentialCancellable));
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme) {
            int fromIndex = scheme.length() + 3;
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            return relativeReferenceIdx < 0 ? "/" : requestTarget.substring(relativeReferenceIdx);
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }

        private boolean shouldRedirect(int redirectCount, StreamingHttpResponse response, HttpRequestMethod originalMethod) {
            int statusCode = response.status().code();
            if (statusCode < 300 || statusCode > 308) {
                return false;
            }
            if (redirectCount > this.redirectSingle.maxRedirects) {
                LOGGER.debug("Maximum number of redirects ({}) reached for original request '{}'", (Object)this.redirectSingle.maxRedirects, (Object)this.redirectSingle.originalRequest);
                return false;
            }
            switch (statusCode) {
                case 304: 
                case 305: 
                case 306: {
                    return false;
                }
            }
            if (HttpRequestMethod.TRACE.name().equals(originalMethod.name()) || HttpRequestMethod.OPTIONS.name().equals(originalMethod.name()) || HttpRequestMethod.CONNECT.name().equals(originalMethod.name())) {
                return false;
            }
            CharSequence locationHeader = response.headers().get(HttpHeaderNames.LOCATION);
            if (locationHeader == null || locationHeader.length() == 0) {
                LOGGER.debug("No location header for redirect response");
                return false;
            }
            if (statusCode == 307 || statusCode == 308) {
                return HttpRequestMethod.GET.name().equals(originalMethod.name()) || HttpRequestMethod.HEAD.name().equals(originalMethod.name());
            }
            return true;
        }

        @Nullable
        private static StreamingHttpRequest prepareRedirectRequest(StreamingHttpRequest request, StreamingHttpResponse response, StreamingHttpRequestFactory requestFactory) {
            HttpRequestMethod method = RedirectSubscriber.defineRedirectMethod(request.method());
            CharSequence locationHeader = response.headers().get(HttpHeaderNames.LOCATION);
            assert (locationHeader != null);
            StreamingHttpRequest redirectRequest = requestFactory.newRequest(method, locationHeader.toString()).version(request.version());
            String redirectHost = redirectRequest.host();
            if (redirectHost == null) {
                redirectHost = request.effectiveHost();
                if (redirectHost == null) {
                    return null;
                }
                int redirectPort = request.effectivePort();
                redirectRequest.setHeader(HttpHeaderNames.HOST, (CharSequence)(redirectPort < 0 ? redirectHost : redirectHost + ':' + redirectPort));
            }
            redirectRequest.setHeader(HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO);
            return redirectRequest;
        }

        private static HttpRequestMethod defineRedirectMethod(HttpRequestMethod originalMethod) {
            return HttpRequestMethod.HEAD.name().equals(originalMethod.name()) ? HttpRequestMethod.HEAD : HttpRequestMethod.GET;
        }
    }
}

