/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.RedirectSingle;

public final class RedirectingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private final int maxRedirects;
    private final boolean onlyRelativeClient;
    private final boolean onlyRelativeConnection;

    public RedirectingHttpRequesterFilter() {
        this(true, true);
    }

    public RedirectingHttpRequesterFilter(int maxRedirects) {
        this(true, true, maxRedirects);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient) {
        this(onlyRelativeClient, true, 5);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, int maxRedirects) {
        this(onlyRelativeClient, true, maxRedirects);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection) {
        this(onlyRelativeClient, onlyRelativeConnection, 5);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection, int maxRedirects) {
        this.onlyRelativeClient = onlyRelativeClient;
        this.onlyRelativeConnection = onlyRelativeConnection;
        this.maxRedirects = maxRedirects;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeClient);
            }

            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
                return this.delegate().reserveConnection(strategy, metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                        return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeConnection);
                    }
                });
            }
        };
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request((StreamingHttpRequester)this.delegate(), strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeConnection);
            }
        };
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request, boolean onlyRelative) {
        Single response = delegate.request(strategy, request);
        if (this.maxRedirects <= 0) {
            return response;
        }
        return new RedirectSingle(strategy, (Single<StreamingHttpResponse>)response, request, this.maxRedirects, delegate, onlyRelative);
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }
}

