/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils.auth;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.utils.auth.AuthenticationException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthHttpServiceFilter<UserInfo>
implements StreamingHttpServiceFilterFactory,
HttpExecutionStrategyInfluencer {
    private final CredentialsVerifier<UserInfo> credentialsVerifier;
    private final HttpExecutionStrategyInfluencer influencer;
    private final String realm;
    private final boolean proxy;
    @Nullable
    private final AsyncContextMap.Key<UserInfo> userInfoKey;
    private final boolean utf8;

    private BasicAuthHttpServiceFilter(CredentialsVerifier<UserInfo> credentialsVerifier, String realm, boolean proxy, @Nullable AsyncContextMap.Key<UserInfo> userInfoKey, boolean utf8) {
        this.credentialsVerifier = credentialsVerifier;
        this.realm = realm;
        this.proxy = proxy;
        this.userInfoKey = userInfoKey;
        this.utf8 = utf8;
        this.influencer = credentialsVerifier instanceof HttpExecutionStrategyInfluencer ? (HttpExecutionStrategyInfluencer)credentialsVerifier : HttpExecutionStrategyInfluencer.defaultStreamingInfluencer();
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new BasicAuthStreamingHttpService(this, service);
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return this.influencer.influenceStrategy(strategy);
    }

    private static final class BasicAuthStreamingHttpService<UserInfo>
    extends StreamingHttpServiceFilter {
        private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthStreamingHttpService.class);
        private static final String AUTH_SCHEME = "basic ";
        private static final int AUTH_SCHEME_LENGTH = "basic ".length();
        private final BasicAuthHttpServiceFilter<UserInfo> config;
        private final String authenticateHeader;
        private final AsyncCloseable closeable;

        BasicAuthStreamingHttpService(BasicAuthHttpServiceFilter<UserInfo> config, StreamingHttpService next) {
            super(next);
            this.config = config;
            this.authenticateHeader = "Basic realm=\"" + ((BasicAuthHttpServiceFilter)config).realm + (((BasicAuthHttpServiceFilter)config).utf8 ? "\", charset=\"UTF-8\"" : Character.valueOf('\"'));
            this.closeable = AsyncCloseables.newCompositeCloseable().appendAll(new AsyncCloseable[]{next, ((BasicAuthHttpServiceFilter)config).credentialsVerifier});
        }

        public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory factory) {
            Iterator authorizations = request.headers().valuesIterator(((BasicAuthHttpServiceFilter)this.config).proxy ? HttpHeaderNames.PROXY_AUTHORIZATION : HttpHeaderNames.AUTHORIZATION);
            String token = "";
            while (authorizations.hasNext()) {
                int beginIdx;
                int commaIdx;
                int endIdx;
                String strAuth;
                int schemeIdx;
                CharSequence authorization = (CharSequence)authorizations.next();
                if (authorization.length() <= AUTH_SCHEME_LENGTH || (schemeIdx = (strAuth = authorization.toString()).toLowerCase().indexOf(AUTH_SCHEME)) < 0 || (endIdx = (commaIdx = strAuth.indexOf(44, beginIdx = schemeIdx + AUTH_SCHEME_LENGTH)) < 0 ? strAuth.length() : commaIdx) <= beginIdx) continue;
                token = strAuth.substring(beginIdx, endIdx);
                break;
            }
            if (token.isEmpty()) {
                return this.onAccessDenied((HttpMetaData)request, factory);
            }
            String userIdAndPassword = new String(Base64.getDecoder().decode(token), StandardCharsets.UTF_8);
            int colonIdx = userIdAndPassword.indexOf(58);
            if (colonIdx < 1) {
                return this.onAccessDenied((HttpMetaData)request, factory);
            }
            String userId = userIdAndPassword.substring(0, colonIdx);
            String password = userIdAndPassword.length() - 1 == colonIdx ? "" : userIdAndPassword.substring(colonIdx + 1);
            return ((BasicAuthHttpServiceFilter)this.config).credentialsVerifier.apply(userId, password).flatMap(userInfo -> this.onAuthenticated(ctx, request, factory, userInfo)).recoverWith(t -> {
                if (t instanceof AuthenticationException) {
                    return this.onAccessDenied((HttpMetaData)request, factory);
                }
                LOGGER.debug("Unexpected exception during authentication", t);
                return Single.failed((Throwable)t);
            });
        }

        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        private Single<StreamingHttpResponse> onAccessDenied(HttpMetaData requestMetaData, StreamingHttpResponseFactory factory) {
            StreamingHttpResponse response = factory.newResponse(((BasicAuthHttpServiceFilter)this.config).proxy ? HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED : HttpResponseStatus.UNAUTHORIZED).version(requestMetaData.version());
            HttpHeaders headers = response.headers();
            headers.set(((BasicAuthHttpServiceFilter)this.config).proxy ? HttpHeaderNames.PROXY_AUTHENTICATE : HttpHeaderNames.WWW_AUTHENTICATE, (CharSequence)this.authenticateHeader);
            headers.set(HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO);
            return Single.succeeded((Object)response);
        }

        private Single<StreamingHttpResponse> onAuthenticated(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory factory, UserInfo userInfo) {
            if (((BasicAuthHttpServiceFilter)this.config).userInfoKey != null) {
                AsyncContext.put((AsyncContextMap.Key)((BasicAuthHttpServiceFilter)this.config).userInfoKey, userInfo);
            }
            return this.delegate().handle(ctx, request, factory);
        }
    }

    public static final class Builder<UserInfo> {
        private final CredentialsVerifier<UserInfo> credentialsVerifier;
        private final String realm;
        @Nullable
        private AsyncContextMap.Key<UserInfo> userInfoKey;
        private boolean utf8;

        public Builder(CredentialsVerifier<UserInfo> credentialsVerifier, String realm) {
            this.credentialsVerifier = Objects.requireNonNull(credentialsVerifier);
            this.realm = Objects.requireNonNull(realm);
        }

        public Builder<UserInfo> userInfoKey(AsyncContextMap.Key<UserInfo> userInfoKey) {
            this.userInfoKey = Objects.requireNonNull(userInfoKey);
            return this;
        }

        public Builder<UserInfo> setCharsetUtf8(boolean utf8) {
            this.utf8 = utf8;
            return this;
        }

        public StreamingHttpServiceFilterFactory buildServer() {
            return new BasicAuthHttpServiceFilter(this.credentialsVerifier, this.realm, false, this.userInfoKey, this.utf8);
        }

        public StreamingHttpServiceFilterFactory buildProxy() {
            return new BasicAuthHttpServiceFilter(this.credentialsVerifier, this.realm, true, this.userInfoKey, this.utf8);
        }
    }

    public static interface CredentialsVerifier<UserInfo>
    extends BiFunction<String, String, Single<UserInfo>>,
    AsyncCloseable {
        @Override
        public Single<UserInfo> apply(String var1, String var2);
    }
}

