/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.TimeoutFromRequest;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractTimeoutHttpFilter
implements HttpExecutionStrategyInfluencer {
    private final TimeoutFromRequest timeoutForRequest;
    private final boolean fullRequestResponse;
    @Nullable
    private final io.servicetalk.concurrent.api.Executor timeoutExecutor;

    AbstractTimeoutHttpFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = null;
    }

    AbstractTimeoutHttpFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor");
    }

    public final HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return this.timeoutForRequest.influenceStrategy(strategy);
    }

    final Single<StreamingHttpResponse> withTimeout(StreamingHttpRequest request, Function<StreamingHttpRequest, Single<StreamingHttpResponse>> responseFunction) {
        return Single.defer(() -> {
            Duration timeout = this.timeoutForRequest.apply((HttpRequestMetaData)request);
            Single response = (Single)responseFunction.apply(request);
            if (null != timeout) {
                Single timeoutResponse;
                Single single = timeoutResponse = this.timeoutExecutor == null ? response.timeout(timeout) : response.timeout(timeout, (Executor)this.timeoutExecutor);
                if (this.fullRequestResponse) {
                    long deadline = System.nanoTime() + timeout.toNanos();
                    response = timeoutResponse.map(resp -> resp.transformMessageBody(body -> Publisher.defer(() -> {
                        Duration remaining = Duration.ofNanos(deadline - System.nanoTime());
                        return (this.timeoutExecutor == null ? body.timeoutTerminal(remaining) : body.timeoutTerminal(remaining, (Executor)this.timeoutExecutor)).onErrorMap(TimeoutException.class, t -> new MappedTimeoutException("message body timeout after " + timeout.toMillis() + "ms", (Throwable)t)).subscribeShareContext();
                    })));
                } else {
                    response = timeoutResponse;
                }
            }
            return response.subscribeShareContext();
        });
    }

    static final class FixedDuration
    implements TimeoutFromRequest {
        private final Duration duration;

        FixedDuration(Duration duration) {
            this.duration = DurationUtils.ensurePositive((Duration)duration, (String)"duration");
        }

        @Override
        public Duration apply(HttpRequestMetaData request) {
            return this.duration;
        }

        @Override
        public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
            return strategy;
        }
    }

    private static final class MappedTimeoutException
    extends TimeoutException {
        private static final long serialVersionUID = -8230476062001221272L;

        MappedTimeoutException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

