/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.AbstractTimeoutHttpFilter;
import io.servicetalk.http.utils.TimeoutFromRequest;
import java.time.Duration;

public final class TimeoutHttpRequesterFilter
extends AbstractTimeoutHttpFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    public TimeoutHttpRequesterFilter(Duration duration) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), false);
    }

    public TimeoutHttpRequesterFilter(Duration duration, Executor timeoutExecutor) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), false, timeoutExecutor);
    }

    public TimeoutHttpRequesterFilter(Duration duration, boolean fullRequestResponse) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse);
    }

    public TimeoutHttpRequesterFilter(Duration duration, boolean fullRequestResponse, Executor timeoutExecutor) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse, timeoutExecutor);
    }

    public TimeoutHttpRequesterFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse) {
        super(timeoutForRequest, fullRequestResponse);
    }

    public TimeoutHttpRequesterFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse, Executor timeoutExecutor) {
        super(timeoutForRequest, fullRequestResponse, timeoutExecutor);
    }

    public StreamingHttpClientFilter create(final FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return TimeoutHttpRequesterFilter.this.withTimeout(request, r -> delegate.request(strategy, r), client.executionContext().executor());
            }
        };
    }

    public StreamingHttpConnectionFilter create(final FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return TimeoutHttpRequesterFilter.this.withTimeout(request, r -> this.delegate().request(strategy, r), connection.executionContext().executor());
            }
        };
    }
}

