/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class RequestTargetDecoderHttpServiceFilter
implements StreamingHttpServiceFilterFactory,
HttpExecutionStrategyInfluencer {
    private final Charset charset;

    public RequestTargetDecoderHttpServiceFilter() {
        this(StandardCharsets.US_ASCII);
    }

    public RequestTargetDecoderHttpServiceFilter(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return Single.defer(() -> {
                    request.requestTarget(request.requestTarget(RequestTargetDecoderHttpServiceFilter.this.charset));
                    return this.delegate().handle(ctx, request, responseFactory).shareContextOnSubscribe();
                });
            }
        };
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }
}

