/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.TimeSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.AbstractTimeoutHttpFilter;
import io.servicetalk.http.utils.TimeoutFromRequest;
import java.time.Duration;
import java.util.function.BiFunction;

public final class TimeoutHttpRequesterFilter
extends AbstractTimeoutHttpFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    public TimeoutHttpRequesterFilter(Duration duration) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), false);
    }

    public TimeoutHttpRequesterFilter(Duration duration, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        this((BiFunction<HttpRequestMetaData, TimeSource, Duration>)new AbstractTimeoutHttpFilter.FixedDuration(duration), false, timeoutExecutor);
    }

    public TimeoutHttpRequesterFilter(Duration duration, boolean fullRequestResponse) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse);
    }

    public TimeoutHttpRequesterFilter(Duration duration, boolean fullRequestResponse, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        this((BiFunction<HttpRequestMetaData, TimeSource, Duration>)new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse, timeoutExecutor);
    }

    @Deprecated
    public TimeoutHttpRequesterFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse) {
        super(timeoutForRequest, fullRequestResponse);
    }

    public TimeoutHttpRequesterFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest, boolean fullRequestResponse) {
        super(timeoutForRequest, fullRequestResponse);
    }

    @Deprecated
    public TimeoutHttpRequesterFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        super(timeoutForRequest, fullRequestResponse, (Executor)timeoutExecutor);
    }

    public TimeoutHttpRequesterFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest, boolean fullRequestResponse, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        super(timeoutForRequest, fullRequestResponse, (Executor)timeoutExecutor);
    }

    public StreamingHttpClientFilter create(final FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                HttpExecutionContext executionContext = client.executionContext();
                return TimeoutHttpRequesterFilter.this.withTimeout(request, arg_0 -> ((StreamingHttpRequester)delegate).request(arg_0), (Executor)(executionContext.executionStrategy().hasOffloads() ? executionContext.executor() : executionContext.ioExecutor()));
            }
        };
    }

    public StreamingHttpConnectionFilter create(final FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                HttpExecutionContext executionContext = connection.executionContext();
                return TimeoutHttpRequesterFilter.this.withTimeout(request, r -> this.delegate().request(r), (Executor)(executionContext.executionStrategy().hasOffloads() ? executionContext.executor() : executionContext.ioExecutor()));
            }
        };
    }
}

