/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.cpg.passes;

import better.files.File;
import better.files.File$;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.js2cpg.core.Report;
import io.shiftleft.js2cpg.cpg.passes.AstCreationPass$ParseResult$;
import io.shiftleft.js2cpg.cpg.passes.UsedIdentNodesPass;
import io.shiftleft.js2cpg.cpg.passes.UsedIdentNodesPass$;
import io.shiftleft.js2cpg.cpg.passes.astcreation.AstCreator;
import io.shiftleft.js2cpg.io.FileUtils;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.io.JsFileChecks$;
import io.shiftleft.js2cpg.io.TimeUtils$;
import io.shiftleft.js2cpg.parser.JavaScriptParser$;
import io.shiftleft.js2cpg.parser.JsSource;
import io.shiftleft.js2cpg.util.SourceWrapper$;
import io.shiftleft.js2cpg.util.SourceWrapper$SourceWrapper$;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.passes.DiffGraph;
import io.shiftleft.passes.DiffGraph$;
import io.shiftleft.passes.IntervalKeyPool;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ConcurrentWriterCpgPass<Tuple2<Path, Path>> {
    private final File srcDir;
    private final List<Tuple2<Path, Path>> filenames;
    private final Report report;
    private final Logger logger;
    public final AstCreationPass$ParseResult$ ParseResult$lzy1;

    public AstCreationPass(File srcDir, List<Tuple2<Path, Path>> filenames, Cpg cpg, IntervalKeyPool keyPool, Report report) {
        this.srcDir = srcDir;
        this.filenames = filenames;
        this.report = report;
        Some some = Some$.MODULE$.apply((Object)keyPool);
        String string = ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2();
        super(cpg, string, (Option)some);
        this.ParseResult$lzy1 = new AstCreationPass$ParseResult$(this);
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }

    private final AstCreationPass$ParseResult$ ParseResult() {
        return this.ParseResult$lzy1;
    }

    public Tuple2<Path, Path>[] generateParts() {
        return (Tuple2[])this.filenames.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public void runOnPart(DiffGraph.Builder diffGraph, Tuple2<Path, Path> filename) {
        None$ none$;
        Tuple2<Path, Path> tuple2 = filename;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Path file = (Path)tuple2._1();
        Path fileRoot = (Path)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)file, (Object)fileRoot);
        Path file2 = (Path)tuple22._1();
        Path fileRoot2 = (Path)tuple22._2();
        Try<ParseResult> try_ = this.parse(file2, fileRoot2);
        if (try_ instanceof Failure) {
            Throwable parseException = ((Failure)try_).exception();
            this.logger.warn(parseException.getMessage());
            none$ = None$.MODULE$;
        } else if (try_ instanceof Success) {
            ParseResult parseResult = (ParseResult)((Success)try_).value();
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)parseResult, this.preAnalyze(parseResult)));
        } else {
            throw new MatchError(try_);
        }
        None$ parseResult = none$;
        parseResult.map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            Set usedIdentNodes;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ParseResult parseResult = (ParseResult)tuple2._1();
            Tuple2 tuple22 = TimeUtils$.MODULE$.time(() -> this.$anonfun$1(parseResult, usedIdentNodes = (Set)tuple2._2()));
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Try result = (Try)tuple22._1();
            long duration = BoxesRunTime.unboxToLong((Object)tuple22._2());
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)result, (Object)BoxesRunTime.boxToLong((long)duration));
            Try result2 = (Try)tuple23._1();
            long duration2 = BoxesRunTime.unboxToLong((Object)tuple23._2());
            String path = parseResult.jsSource().originalFilePath();
            Try try_ = result2;
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.warn(new StringBuilder(30).append("Failed to generate CPG for '").append(path).append("'!").toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            } else {
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                DiffGraph.Builder localDiff = (DiffGraph.Builder)((Success)try_).value();
                this.logger.info(new StringBuilder(17).append("Processed file '").append(path).append("'").toString());
                this.report.updateReportDuration(path, duration2);
                boxedUnit = diffGraph.moveFrom(localDiff);
            }
            return boxedUnit;
        });
    }

    private Try<DiffGraph.Builder> generateCpg(ParseResult parseResult, DiffGraph.Builder diffGraph, Set<String> usedIdentNodes) {
        return Try$.MODULE$.apply(() -> this.generateCpg$$anonfun$1(parseResult, diffGraph, usedIdentNodes));
    }

    private Set<String> preAnalyze(ParseResult parseResult) {
        FunctionNode ast = parseResult.ast();
        UsedIdentNodesPass usedIdentNodesPass = new UsedIdentNodesPass(UsedIdentNodesPass$.MODULE$.$lessinit$greater$default$1());
        ast.accept((NodeVisitor)usedIdentNodesPass);
        return usedIdentNodesPass.usedIdentNodes().toSet();
    }

    private Try<ParseResult> parse(Path path, Path rootDir) {
        Tuple2 tuple2;
        Failure failure;
        Seq<String> lines = FileUtils$.MODULE$.readLinesInFile(path);
        String relPath = rootDir.relativize(path).toString();
        FileUtils.FileStatistics fileStatistics = JsFileChecks$.MODULE$.check(relPath, lines);
        Source source = Source.sourceFor((String)relPath, (String)lines.mkString("\n"));
        JsSource jsSource = SourceWrapper$SourceWrapper$.MODULE$.toJsSource$extension(SourceWrapper$.MODULE$.SourceWrapper(source), this.srcDir, rootDir);
        this.logger.debug(new StringBuilder(16).append("Parsing file '").append(relPath).append("'.").toString());
        Try try_ = Try$.MODULE$.apply(() -> AstCreationPass.parse$$anonfun$1(jsSource));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.report.addReportInfo(jsSource.originalFilePath(), fileStatistics.linesOfCode(), this.report.addReportInfo$default$3(), this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5(), this.report.addReportInfo$default$6());
            failure = Failure$.MODULE$.apply(exception);
        } else if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
            FunctionNode ast = (FunctionNode)tuple2._1();
            JsSource jsSource2 = (JsSource)tuple2._2();
            this.report.addReportInfo(jsSource2.originalFilePath(), fileStatistics.linesOfCode(), true, this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5(), this.report.addReportInfo$default$6());
            failure = Success$.MODULE$.apply((Object)this.ParseResult().apply(File$.MODULE$.apply(path), jsSource2, ast));
        } else {
            throw new MatchError((Object)try_);
        }
        return failure;
    }

    private final Try $anonfun$1(ParseResult parseResult$1, Set usedIdentNodes$1) {
        return this.generateCpg(parseResult$1, DiffGraph$.MODULE$.newBuilder(), (Set<String>)usedIdentNodes$1);
    }

    private final DiffGraph.Builder generateCpg$$anonfun$1(ParseResult parseResult$2, DiffGraph.Builder diffGraph$2, Set usedIdentNodes$2) {
        JsSource source = parseResult$2.jsSource();
        FunctionNode ast = parseResult$2.ast();
        this.logger.debug(new StringBuilder(27).append("Generating CPG for file '").append(source.originalFilePath()).append("'.").toString());
        AstCreator astBuilderPass = new AstCreator(diffGraph$2, source, (Set<String>)usedIdentNodes$2);
        astBuilderPass.convert(ast);
        return diffGraph$2;
    }

    private static final Tuple2 parse$$anonfun$1(JsSource jsSource$1) {
        return JavaScriptParser$.MODULE$.parseFromSource(jsSource$1);
    }

    private class ParseResult
    implements Product,
    Serializable {
        private final File file;
        private final JsSource jsSource;
        private final FunctionNode ast;
        private final AstCreationPass $outer;

        public ParseResult(AstCreationPass $outer, File file, JsSource jsSource, FunctionNode ast) {
            this.file = file;
            this.jsSource = jsSource;
            this.ast = ast;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseResult)) return false;
            if (((ParseResult)object).io$shiftleft$js2cpg$cpg$passes$AstCreationPass$ParseResult$$$outer() != this.$outer) return false;
            ParseResult parseResult = (ParseResult)object;
            File file = this.file();
            File file2 = parseResult.file();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!file.equals(file2)) return false;
            JsSource jsSource = this.jsSource();
            JsSource jsSource2 = parseResult.jsSource();
            if (jsSource == null) {
                if (jsSource2 != null) {
                    return false;
                }
            } else if (!jsSource.equals(jsSource2)) return false;
            FunctionNode functionNode = this.ast();
            FunctionNode functionNode2 = parseResult.ast();
            if (functionNode == null) {
                if (functionNode2 != null) {
                    return false;
                }
            } else if (!functionNode.equals(functionNode2)) return false;
            if (!parseResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ParseResult";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "file";
                    break;
                }
                case 1: {
                    string = "jsSource";
                    break;
                }
                case 2: {
                    string = "ast";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public File file() {
            return this.file;
        }

        public JsSource jsSource() {
            return this.jsSource;
        }

        public FunctionNode ast() {
            return this.ast;
        }

        public ParseResult copy(File file, JsSource jsSource, FunctionNode ast) {
            return new ParseResult(this.$outer, file, jsSource, ast);
        }

        public File copy$default$1() {
            return this.file();
        }

        public JsSource copy$default$2() {
            return this.jsSource();
        }

        public FunctionNode copy$default$3() {
            return this.ast();
        }

        public File _1() {
            return this.file();
        }

        public JsSource _2() {
            return this.jsSource();
        }

        public FunctionNode _3() {
            return this.ast();
        }

        public final AstCreationPass io$shiftleft$js2cpg$cpg$passes$AstCreationPass$ParseResult$$$outer() {
            return this.$outer;
        }
    }
}

