/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.shiftleft.js2cpg.io.FileUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class PackageJsonParser$
implements Serializable {
    private static final Logger logger;
    private static final String PACKAGE_JSON_FILENAME;
    private static final String PACKAGE_JSON_LOCK_FILENAME;
    private static final Seq<String> projectDependencies;
    private static final TrieMap<Path, Map<String, String>> cachedDependencies;
    public static final PackageJsonParser$ MODULE$;

    private PackageJsonParser$() {
    }

    static {
        MODULE$ = new PackageJsonParser$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        PACKAGE_JSON_FILENAME = "package.json";
        PACKAGE_JSON_LOCK_FILENAME = "package-lock.json";
        projectDependencies = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dependencies", "devDependencies", "peerDependencies", "optionalDependencies"}));
        cachedDependencies = TrieMap$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PackageJsonParser$.class);
    }

    public String PACKAGE_JSON_FILENAME() {
        return PACKAGE_JSON_FILENAME;
    }

    public String PACKAGE_JSON_LOCK_FILENAME() {
        return PACKAGE_JSON_LOCK_FILENAME;
    }

    public Map<String, String> dependencies(Path packageJsonPath) {
        return (Map)cachedDependencies.getOrElseUpdate((Object)packageJsonPath, () -> this.dependencies$$anonfun$1(packageJsonPath));
    }

    private final Iterator $anonfun$2() {
        return package$.MODULE$.Iterator().empty();
    }

    private final Map $anonfun$4(Path lockDepsPath$1) {
        String content = FileUtils$.MODULE$.readLinesInFile(lockDepsPath$1).mkString("\n");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode packageJson = objectMapper.readTree(content);
        ObjectRef depToVersion = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Iterator dependencyIt = (Iterator)Option$.MODULE$.apply((Object)packageJson.get("dependencies")).map((Function1 & Serializable)_$1 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$1.fields()).asScala()).getOrElse(this::$anonfun$2);
        dependencyIt.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Map.Entry entry = x$1;
            if (entry != null) {
                Map.Entry entry2 = entry;
                String depName = (String)entry2.getKey();
                JsonNode versionNode = ((JsonNode)entry2.getValue()).get("version");
                if (versionNode != null) {
                    Map map = (Map)((Map)depToVersion$1.elem).updated((Object)depName, (Object)versionNode.asText());
                    depToVersion$1.elem = map;
                }
            } else {
                throw new MatchError((Object)entry);
            }
        });
        return (Map)depToVersion.elem;
    }

    private final Iterator $anonfun$6() {
        return package$.MODULE$.Iterator().empty();
    }

    private final Map deps$lzyINIT1$3$$anonfun$3(Path depsPath$2) {
        String content = FileUtils$.MODULE$.readLinesInFile(depsPath$2).mkString("\n");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode packageJson = objectMapper.readTree(content);
        ObjectRef depToVersion = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        projectDependencies.foreach((Function1)(JProcedure1 & Serializable)dependency -> {
            Iterator dependencyIt = (Iterator)Option$.MODULE$.apply((Object)packageJson.get(dependency)).map((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$2.fields()).asScala()).getOrElse(this::$anonfun$6);
            dependencyIt.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Map.Entry entry = x$1;
                if (entry == null) {
                    throw new MatchError((Object)entry);
                }
                Map.Entry entry2 = entry;
                Map map = (Map)((Map)depToVersion$3.elem).updated(entry2.getKey(), (Object)((JsonNode)entry2.getValue()).asText());
                depToVersion$3.elem = map;
            });
        });
        return (Map)depToVersion.elem;
    }

    private final Option deps$lzyINIT1$4(Path depsPath$1, LazyRef deps$lzy1$1) {
        Option option;
        LazyRef lazyRef = deps$lzy1$1;
        synchronized (lazyRef) {
            option = (Option)(deps$lzy1$1.initialized() ? deps$lzy1$1.value() : deps$lzy1$1.initialize((Object)Try$.MODULE$.apply(() -> this.deps$lzyINIT1$3$$anonfun$3(depsPath$1)).toOption()));
        }
        return option;
    }

    private final Option deps$1(Path depsPath$3, LazyRef deps$lzy1$2) {
        return (Option)(deps$lzy1$2.initialized() ? deps$lzy1$2.value() : this.deps$lzyINIT1$4(depsPath$3, deps$lzy1$2));
    }

    private final Map dependencies$$anonfun$1(Path packageJsonPath$1) {
        Map map;
        LazyRef lazyRef = new LazyRef();
        Path depsPath = packageJsonPath$1;
        Path lockDepsPath = packageJsonPath$1.resolveSibling(Paths.get(this.PACKAGE_JSON_LOCK_FILENAME(), new String[0]));
        Option lockDeps = Try$.MODULE$.apply(() -> this.$anonfun$4(lockDepsPath)).toOption();
        if (lockDeps.isDefined() && ((IterableOnceOps)lockDeps.get()).nonEmpty()) {
            logger.debug(new StringBuilder(28).append("Loaded dependencies from '").append(lockDepsPath).append("'.").toString());
            map = (Map)lockDeps.get();
        } else if (this.deps$1(depsPath, lazyRef).isDefined() && ((IterableOnceOps)this.deps$1(depsPath, lazyRef).get()).nonEmpty()) {
            logger.debug(new StringBuilder(28).append("Loaded dependencies from '").append(depsPath).append("'.").toString());
            map = (Map)this.deps$1(depsPath, lazyRef).get();
        } else {
            logger.debug(new StringBuilder(44).append("No project dependencies found in ").append(this.PACKAGE_JSON_FILENAME()).append(" or ").append(this.PACKAGE_JSON_LOCK_FILENAME()).append(" at '").append(depsPath.getParent()).append("'.").toString());
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }
}

