/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.util;

import io.shiftleft.js2cpg.util.JmxCpuMetric;
import io.shiftleft.js2cpg.util.JmxCpuMetric$;
import io.shiftleft.js2cpg.util.JmxGCMetric;
import io.shiftleft.js2cpg.util.JmxGCMetric$;
import io.shiftleft.js2cpg.util.JmxMemoryMetric;
import io.shiftleft.js2cpg.util.JmxMemoryMetric$;
import java.io.Serializable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public abstract class JmxClient {
    public Option<JMXConnector> init(int port, int retries) {
        JMXServiceURL url = new JMXServiceURL(new StringBuilder(47).append("service:jmx:rmi:///jndi/rmi://localhost:").append(port).append("/jmxrmi").toString());
        return JmxClient.withRetries$1(url, retries);
    }

    public int init$default$2() {
        return 30;
    }

    public Option<JmxMemoryMetric> memoryMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                Object memoryMbean = jmxc.getMBeanServerConnection().getAttribute(new ObjectName("java.lang:type=Memory"), "HeapMemoryUsage");
                CompositeData cd = (CompositeData)memoryMbean;
                return Some$.MODULE$.apply((Object)JmxMemoryMetric$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)cd.get("used")), BoxesRunTime.unboxToLong((Object)cd.get("committed"))));
            });
        }
        catch (Throwable e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JmxCpuMetric> cpuMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                MBeanServerConnection connection = jmxc.getMBeanServerConnection();
                Object osMbean = connection.getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "ProcessCpuTime");
                long threads = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=Threading"), "ThreadCount"));
                return Some$.MODULE$.apply((Object)JmxCpuMetric$.MODULE$.apply(osMbean, threads));
            });
        }
        catch (Throwable e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JmxGCMetric> gcMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                MBeanServerConnection connection = jmxc.getMBeanServerConnection();
                long gcParCollectionCount = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ParNew"), "CollectionCount"));
                long gcParCollectionTime = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ParNew"), "CollectionTime"));
                long gcConCollectionCount = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep"), "CollectionCount"));
                long gcConCollectionTime = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep"), "CollectionTime"));
                return Some$.MODULE$.apply((Object)JmxGCMetric$.MODULE$.apply(gcParCollectionCount, gcParCollectionTime, gcConCollectionCount, gcConCollectionTime));
            });
        }
        catch (Throwable e) {
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    private static final Option withRetries$1(JMXServiceURL url, int retriesLeft) {
        None$ none$;
        int n = retriesLeft;
        while (true) {
            try {
                void var3_3;
                Some jmxc = Some$.MODULE$.apply((Object)JMXConnectorFactory.connect(url, null));
                jmxc.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.connect());
                none$ = var3_3;
            }
            catch (Throwable e) {
                if (n > 0) {
                    Thread.sleep(100L);
                    --n;
                    continue;
                }
                none$ = None$.MODULE$;
            }
            break;
        }
        return none$;
    }
}

