/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.core;

import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.core.Report;
import io.shiftleft.js2cpg.cpg.passes.AstCreationPass;
import io.shiftleft.js2cpg.cpg.passes.BuiltinTypesPass;
import io.shiftleft.js2cpg.cpg.passes.CallLinkerPass;
import io.shiftleft.js2cpg.cpg.passes.ConfigPass;
import io.shiftleft.js2cpg.cpg.passes.DependenciesPass;
import io.shiftleft.js2cpg.cpg.passes.JsMetaDataPass;
import io.shiftleft.js2cpg.cpg.passes.PrivateKeyFilePass;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.preprocessing.NuxtTranspiler$;
import io.shiftleft.js2cpg.preprocessing.TranspilationRunner;
import io.shiftleft.js2cpg.preprocessing.TranspilationRunner$;
import io.shiftleft.js2cpg.util.MemoryMetrics$;
import io.shiftleft.passes.IntervalKeyPool;
import io.shiftleft.passes.KeyPool;
import io.shiftleft.passes.KeyPoolCreator$;
import io.shiftleft.x2cpg.X2Cpg$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Js2Cpg {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Report report = new Report();

    private void checkCpgGenInputFiles(List<Tuple2<Path, Path>> jsFiles, Config config) {
        if (jsFiles.isEmpty()) {
            File project = File$.MODULE$.apply(config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.logger.warn(new StringBuilder(48).append("'").append(project).append("' contains no *.js files. No CPG was generated.").toString());
            if (config.babelTranspiling()) {
                this.logger.warn("\t- Babel transpilation did not yield any *.js files");
            }
            if (config.tsTranspiling()) {
                this.logger.warn("\t- Typescript compilation did not yield any *.js files. Does a valid 'tsconfig.json' exist in that folder?");
            }
            if (config.vueTranspiling()) {
                this.logger.warn("\t- Vue.js transpilation did not yield any *.js files.");
            }
            if (config.templateTranspiling()) {
                this.logger.warn("\t- Template transpilation did not yield any *.js files.");
            }
            System.exit(1);
        }
    }

    private File handleVsixProject(File project, File tmpProjectDir) {
        this.logger.debug(new StringBuilder(60).append("Project is a VS code extension file (*").append(FileDefaults$.MODULE$.VSIX_SUFFIX()).append("). Unpacking it to '").append(tmpProjectDir).append("'.").toString());
        return project.streamedUnzip(tmpProjectDir, project.streamedUnzip$default$2(tmpProjectDir)).$div("extension");
    }

    private File handleStandardProject(File project, File tmpProjectDir, Config config) {
        File file;
        File realProjectPath;
        File file2 = realProjectPath = File$.MODULE$.apply(project.path().toRealPath(new LinkOption[0]));
        File file3 = tmpProjectDir;
        if (!(file2 != null ? !file2.equals(file3) : file3 != null)) {
            file = realProjectPath;
        } else {
            this.logger.debug(new StringBuilder(37).append("Copying '").append(realProjectPath).append("' to temporary workspace '").append(tmpProjectDir).append("'.").toString());
            Try try_ = Try$.MODULE$.apply(() -> Js2Cpg.handleStandardProject$$anonfun$1(tmpProjectDir, config, realProjectPath));
            if (try_ instanceof Failure) {
                this.logger.debug(new StringBuilder(82).append("Unable to copy project to temporary workspace '").append(tmpProjectDir).append("'. Does it contain broken symlinks?").toString());
                this.logger.debug(new StringBuilder(63).append("Retrying to copy '").append(realProjectPath).append("' to temporary workspace '").append(tmpProjectDir).append("' without symlinks.").toString());
                file = FileUtils$.MODULE$.copyToDirectory(realProjectPath, tmpProjectDir, config, (Seq<CopyOption>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).$plus$plus((IterableOnce)File.LinkOptions$.MODULE$.noFollow())));
            } else if (try_ instanceof Success) {
                File value;
                file = value = (File)((Success)try_).value();
            } else {
                throw new MatchError((Object)try_);
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Path> findProjects(File projectDir, Config config) {
        List list;
        List allProjects = (List)FileUtils$.MODULE$.getFileTree(projectDir.path(), config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}))), FileUtils$.MODULE$.getFileTree$default$4()).filter((Function1 & Serializable)_$1 -> _$1.toString().endsWith(PackageJsonParser$.MODULE$.PACKAGE_JSON_FILENAME())).map((Function1 & Serializable)_$2 -> _$2.getParent()).sortBy((Function1 & Serializable)_$3 -> _$3.toString(), (Ordering)Ordering.String$.MODULE$);
        Set subProjects = (Set)Predef$.MODULE$.Set().from((IterableOnce)allProjects).$minus((Object)projectDir.path());
        List list2 = allProjects;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{projectDir.path()}));
            return list;
        }
        if (list2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list2;
            List list4 = colon2.next$access$1();
            Path head = (Path)colon2.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list5 = list4;
            if (!(nil$2 != null ? !nil$2.equals(list5) : list5 != null)) {
                Path path = head;
                Path path2 = projectDir.path();
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{head}));
                    return list;
                }
            }
        }
        this.logger.info(new StringBuilder(33).append("Found the following sub-projects:").append(((IterableOnceOps)subProjects.map((Function1 & Serializable)p -> projectDir.relativize(File$.MODULE$.apply(p)))).mkString("\n\t- ", "\n\t- ", "")).toString());
        list = (List)subProjects.toList().$plus$colon((Object)projectDir.path());
        return list;
    }

    private boolean isInCi() {
        return scala.sys.package$.MODULE$.env().get((Object)"CI").contains((Object)"true");
    }

    private List<Tuple2<Path, Path>> collectJsFiles(List<Tuple2<Path, Path>> jsFiles, Path dir, Config config) {
        List transpiledJsFiles = FileUtils$.MODULE$.getFileTree(dir, config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.JS_SUFFIX(), FileDefaults$.MODULE$.MJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply(f, (Object)dir));
        return (List)jsFiles.filterNot((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path f = (Path)tuple2._1();
            Path rootDir = (Path)tuple2._2();
            String filename = f.toString().replace(rootDir.toString(), "");
            return transpiledJsFiles.exists((Function1 & Serializable)_$4 -> ((Path)_$4._1()).toString().endsWith(filename));
        }).$plus$plus((IterableOnce)transpiledJsFiles);
    }

    private void prepareAndGenerateCpg(File project, File tmpProjectDir, Config config) {
        File newTmpProjectDir = project.extension().contains((Object)FileDefaults$.MODULE$.VSIX_SUFFIX()) ? this.handleVsixProject(project, tmpProjectDir) : this.handleStandardProject(project, tmpProjectDir, config);
        FileUtils$.MODULE$.logAndClearExcludedPaths();
        List jsFilesBeforeTranspiling = FileUtils$.MODULE$.getFileTree(newTmpProjectDir.path(), config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.JS_SUFFIX(), FileDefaults$.MODULE$.MJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply(f, (Object)newTmpProjectDir.path()));
        File$.MODULE$.usingTemporaryDirectory("js2cpgTranspileOut", File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)tmpTranspileDir -> {
            this.findProjects(newTmpProjectDir, config).foreach((Function1)(JProcedure1 & Serializable)p -> {
                String string = p.toString();
                String string2 = newTmpProjectDir.toString();
                None$ subDir = (string == null ? string2 != null : !string.equals(string2)) ? Some$.MODULE$.apply((Object)newTmpProjectDir.relativize(File$.MODULE$.apply(p))) : None$.MODULE$;
                new TranspilationRunner((Path)p, tmpTranspileDir.path(), config, (Option<Path>)subDir).execute();
            });
            List jsFilesAfterTranspiling = (List)this.collectJsFiles((List<Tuple2<Path, Path>>)jsFilesBeforeTranspiling, tmpTranspileDir.path(), config).$plus$plus(NuxtTranspiler$.MODULE$.collectJsFiles(newTmpProjectDir.path(), config));
            List<Tuple2<Path, Path>> privateModuleFiles = !config.ignorePrivateDeps() ? new TranspilationRunner(newTmpProjectDir.path(), tmpTranspileDir.path(), config, TranspilationRunner$.MODULE$.$lessinit$greater$default$4()).handlePrivateModules() : package$.MODULE$.Nil();
            List jsFiles = (List)((StrictOptimizedSeqOps)jsFilesAfterTranspiling.$plus$plus((IterableOnce)privateModuleFiles)).distinctBy((Function1 & Serializable)_$5 -> (Path)_$5._1());
            FileUtils$.MODULE$.logAndClearExcludedPaths();
            this.checkCpgGenInputFiles((List<Tuple2<Path, Path>>)jsFiles, config);
            MemoryMetrics$.MODULE$.withMemoryMetrics(config, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.prepareAndGenerateCpg$$anonfun$1$$anonfun$2(config, newTmpProjectDir, jsFiles)));
        });
    }

    public void run(Config config) {
        File project = File$.MODULE$.apply(config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String absoluteProjectPath = project.canonicalFile().pathAsString();
        Config configWithAbsolutProjectPath = config.copy(absoluteProjectPath, config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9(), config.copy$default$10(), config.copy$default$11(), config.copy$default$12(), config.copy$default$13(), config.copy$default$14(), config.copy$default$15(), config.copy$default$16(), config.copy$default$17(), config.copy$default$18(), config.copy$default$19(), config.copy$default$20());
        this.logger.info(new StringBuilder(45).append("Generating CPG from Javascript sources in: '").append(absoluteProjectPath).append("'").toString());
        this.logger.debug(new StringBuilder(14).append("Configuration:").append(configWithAbsolutProjectPath).toString());
        if (this.isInCi()) {
            this.prepareAndGenerateCpg(project, File$.MODULE$.apply(absoluteProjectPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), configWithAbsolutProjectPath);
        } else {
            File$.MODULE$.usingTemporaryDirectory(project.name(), File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)tmpProjectDir -> this.prepareAndGenerateCpg(project, (File)tmpProjectDir, configWithAbsolutProjectPath));
        }
        this.logger.info("Generation of CPG is complete.");
        this.report.print();
    }

    private List<Tuple2<Path, Path>> configFiles(Config config, List<String> extensions) {
        return FileUtils$.MODULE$.getFileTree(File$.MODULE$.apply(config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path(), config, extensions, false).map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply(f, (Object)File$.MODULE$.apply(config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path()));
    }

    private void generateCPG(Config config, List<Tuple2<Path, Path>> jsFilesWithRoot) {
        IntervalKeyPool metaDataKeyPool = new IntervalKeyPool(1L, 100L);
        IntervalKeyPool builtinTypesKeyPool = new IntervalKeyPool(101L, 200L);
        IntervalKeyPool dependenciesKeyPool = new IntervalKeyPool(201L, 1000100L);
        List otherPools = KeyPoolCreator$.MODULE$.obtain(5L, 1000101L, KeyPoolCreator$.MODULE$.obtain$default$3());
        IntervalKeyPool functionKeyPool = (IntervalKeyPool)otherPools.head();
        IntervalKeyPool vueAsConfigPassPool = (IntervalKeyPool)otherPools.apply(1);
        IntervalKeyPool configPassPool = (IntervalKeyPool)otherPools.apply(2);
        IntervalKeyPool privateKeyFilePassPool = (IntervalKeyPool)otherPools.apply(3);
        IntervalKeyPool htmlAsConfigPassPool = (IntervalKeyPool)otherPools.apply(4);
        Cpg cpg = X2Cpg$.MODULE$.newEmptyCpg((Option)Some$.MODULE$.apply((Object)config.outputFile()));
        String hash = FileUtils$.MODULE$.md5((Seq<Path>)jsFilesWithRoot.map((Function1 & Serializable)_$6 -> (Path)_$6._1()));
        new AstCreationPass(File$.MODULE$.apply(config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), jsFilesWithRoot, cpg, functionKeyPool, this.report).createAndApply();
        new CallLinkerPass(cpg).createAndApply();
        new JsMetaDataPass(cpg, (KeyPool)metaDataKeyPool, hash).createAndApply();
        new BuiltinTypesPass(cpg, (KeyPool)builtinTypesKeyPool).createAndApply();
        new DependenciesPass(cpg, config, (KeyPool)dependenciesKeyPool).createAndApply();
        new ConfigPass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.VUE_SUFFIX()})))), cpg, vueAsConfigPassPool, this.report).createAndApply();
        new PrivateKeyFilePass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.KEY_SUFFIX()})))), cpg, privateKeyFilePassPool, this.report).createAndApply();
        if (config.includeHtml()) {
            new ConfigPass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.HTML_SUFFIX()})))), cpg, htmlAsConfigPassPool, this.report).createAndApply();
        }
        if (config.includeConfigs()) {
            new ConfigPass(this.configFiles(config, FileDefaults$.MODULE$.CONFIG_FILES()), cpg, configPassPool, this.report).createAndApply();
        }
        cpg.close();
    }

    private static final File handleStandardProject$$anonfun$1(File tmpProjectDir$1, Config config$1, File realProjectPath$1) {
        return FileUtils$.MODULE$.copyToDirectory(realProjectPath$1, tmpProjectDir$1, config$1, FileUtils$.MODULE$.copyToDirectory$default$4(realProjectPath$1, tmpProjectDir$1, config$1));
    }

    private final void prepareAndGenerateCpg$$anonfun$1$$anonfun$2(Config config$4, File newTmpProjectDir$4, List jsFiles$1) {
        this.generateCPG(config$4.copy(newTmpProjectDir$4.toString(), config$4.copy$default$2(), config$4.copy$default$3(), config$4.copy$default$4(), config$4.copy$default$5(), config$4.copy$default$6(), config$4.copy$default$7(), config$4.copy$default$8(), config$4.copy$default$9(), config$4.copy$default$10(), config$4.copy$default$11(), config$4.copy$default$12(), config$4.copy$default$13(), config$4.copy$default$14(), config$4.copy$default$15(), config$4.copy$default$16(), config$4.copy$default$17(), config$4.copy$default$18(), config$4.copy$default$19(), config$4.copy$default$20()), (List<Tuple2<Path, Path>>)jsFiles$1);
    }
}

