/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.io;

import io.shiftleft.js2cpg.core.Js2cpgArgumentsParser$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils;
import io.shiftleft.js2cpg.io.FileUtils$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.ModuleSerializationProxy;

public final class JsFileChecks$
implements Serializable {
    private static final Logger logger;
    public static final JsFileChecks$ MODULE$;

    private JsFileChecks$() {
    }

    static {
        MODULE$ = new JsFileChecks$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsFileChecks$.class);
    }

    private void printPerformanceHints(String relPath, Seq<String> reasons) {
        logger.debug(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(368).append("The file '").append(relPath).append("' may have negative impact on the analyzing performance!\n         | ").append(reasons.length() > 1 ? "Reasons:" : "Reason:").append("\n         | ").append(reasons.mkString(System.lineSeparator())).append("\n         | Please check if:\n         | \t- this file is the result of your build process\n         | \t- this file is the result of applying transpilation tools (e.g., Typescript, Emscripten)\n         | You might want to exclude this file when running js2cpg by adding it to '--").append(Js2cpgArgumentsParser$.MODULE$.EXCLUDE()).append("'.").toString())));
    }

    /*
     * WARNING - void declaration
     */
    public FileUtils.FileStatistics check(String relPath, Seq<String> lines) {
        void var3_3;
        FileUtils.FileStatistics fileStatistics = FileUtils$.MODULE$.fileStatistics(lines);
        ArrayBuffer reasons = ArrayBuffer$.MODULE$.empty();
        if (fileStatistics.linesOfCode() > FileDefaults$.MODULE$.NUM_LINES_THRESHOLD()) {
            reasons.append((Object)new StringBuilder(39).append("\t- it contains more than ").append(FileDefaults$.MODULE$.NUM_LINES_THRESHOLD()).append(" lines of code").toString());
        }
        if (fileStatistics.containsMarker()) {
            reasons.append((Object)"\t- it contains WebAssembly code");
        }
        if (FileDefaults$.MODULE$.MINIFIED_PATH_REGEX().matches((CharSequence)relPath)) {
            reasons.append((Object)"\t- it appears to be a minified Javascript file");
        }
        if (FileDefaults$.MODULE$.BUILD_PATH_REGEX().matches((CharSequence)relPath)) {
            reasons.append((Object)"\t- it is stored or copied to a www, dist, build or vendor folder during the build or distribution process");
        }
        if (reasons.nonEmpty()) {
            this.printPerformanceHints(relPath, (Seq<String>)reasons.toSeq());
        }
        return var3_3;
    }
}

