/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File;
import better.files.File$;
import com.atlassian.sourcemap.WritableSourceMap;
import com.atlassian.sourcemap.WritableSourceMapImpl;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SortedMap;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EjsTranspiler
implements TranspilingEnvironment,
Transpiler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(EjsTranspiler.class, "0bitmap$1");
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    public long 0bitmap$1;
    private final Config config;
    private final Path projectPath;
    private final Logger logger;
    private final Regex TAGS_REGEX;
    private final Regex TAG_GROUPS_REGEX;
    private List ejsFiles$lzy1;

    public EjsTranspiler(Config config, Path projectPath) {
        this.config = config;
        this.projectPath = projectPath;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.TAGS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(<%(?!%)[\\s\\S]*?[^%]%>)"));
        this.TAG_GROUPS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(<%[=\\-_#]?)([\\s\\S]*?)([-_]?%>)$"));
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private List<Path> ejsFiles() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    List<Path> list;
                    this.ejsFiles$lzy1 = list = this.allEjsFiles();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return list;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.ejsFiles$lzy1;
    }

    private List<Path> allEjsFiles() {
        return FileUtils$.MODULE$.getFileTree(this.projectPath(), this.config(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.EJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4());
    }

    private int offset(String str) {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(str.trim())).length() - StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(str)).length() + 1;
    }

    private Tuple2<String, WritableSourceMap> extractJsCode(String tpl, SortedMap<Object, Object> positionToLineNumberMapping, SortedMap<Object, Object> positionToFirstPositionInLineMapping, String ejsFileName) {
        WritableSourceMap sourceMap = new WritableSourceMapImpl.Builder().withSources(Collections.singletonList(ejsFileName)).build();
        ArrayBuffer result = ArrayBuffer$.MODULE$.empty();
        this.TAGS_REGEX.findAllIn((CharSequence)tpl).matchData().foreach((Function1)(JProcedure1 & Serializable)ma -> {
            String string;
            String string2;
            String t;
            String tag = ma.toString();
            int start = ma.start();
            List parse = this.TAG_GROUPS_REGEX.findAllIn((CharSequence)tag).subgroups();
            int generatedLineNumber = result.length();
            int generatedColumnNumber = 0;
            int sourceLineNumber = 0;
            int sourceColumnNumber = 0;
            String string3 = t = (string2 = (String)parse.head());
            String string4 = "<%=";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                sourceLineNumber = this.getLineOfSource(positionToLineNumberMapping, start + 3);
                sourceColumnNumber = this.getColumnOfSource(positionToFirstPositionInLineMapping, start + 3);
                generatedColumnNumber = 2;
                string = new StringBuilder(22).append(";__append(escapeFn(").append(((String)parse.apply(1)).trim()).append("));").toString();
            } else {
                String t2;
                String string5 = t2 = string2;
                String string6 = "<%-";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    sourceLineNumber = this.getLineOfSource(positionToLineNumberMapping, start + 3);
                    sourceColumnNumber = this.getColumnOfSource(positionToFirstPositionInLineMapping, start + 3);
                    generatedColumnNumber = 2;
                    string = new StringBuilder(12).append(";__append(").append(((String)parse.apply(1)).trim()).append(");").toString();
                } else {
                    String t3;
                    String string7 = t3 = string2;
                    String string8 = "<%#";
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        string = "";
                    } else {
                        String t4;
                        String string9 = t4 = string2;
                        String string10 = "<%_";
                        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                            sourceLineNumber = this.getLineOfSource(positionToLineNumberMapping, start + 3);
                            sourceColumnNumber = this.getColumnOfSource(positionToFirstPositionInLineMapping, start + 3);
                            generatedColumnNumber = 0;
                            string = ((String)parse.apply(1)).trim();
                        } else {
                            String t5;
                            String string11 = t5 = string2;
                            String string12 = "<%";
                            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                                sourceLineNumber = this.getLineOfSource(positionToLineNumberMapping, start + 2);
                                sourceColumnNumber = this.getColumnOfSource(positionToFirstPositionInLineMapping, start + 2);
                                generatedColumnNumber = 0;
                                string = ((String)parse.apply(1)).trim();
                            } else {
                                String n = string2;
                                throw new UnsupportedOperationException(new StringBuilder(17).append("Unknown EJS tag: ").append(n).toString());
                            }
                        }
                    }
                }
            }
            String extractedJsCode = string;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(extractedJsCode))) {
                sourceMap.addMapping(generatedLineNumber, generatedColumnNumber, sourceLineNumber - this.offset((String)parse.apply(1)), sourceColumnNumber, ejsFileName);
                result.append((Object)extractedJsCode);
            }
        });
        return Tuple2$.MODULE$.apply((Object)result.mkString(System.lineSeparator()), (Object)sourceMap);
    }

    @Override
    public boolean shouldRun() {
        return this.config().templateTranspiling() && this.ejsFiles().nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private int getLineOfSource(SortedMap<Object, Object> positionToLineNumberMapping, int position) {
        void var3_5;
        Tuple2 tuple2 = (Tuple2)positionToLineNumberMapping.minAfter((Object)BoxesRunTime.boxToInteger((int)position)).get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int lineNumber = BoxesRunTime.unboxToInt((Object)tuple2._2());
        int lineNumber2 = lineNumber;
        return (int)var3_5;
    }

    private int getColumnOfSource(SortedMap<Object, Object> positionToFirstPositionInLineMapping, int position) {
        Tuple2 tuple2 = (Tuple2)positionToFirstPositionInLineMapping.minAfter((Object)BoxesRunTime.boxToInteger((int)position)).get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int firstPositionInLine = BoxesRunTime.unboxToInt((Object)tuple2._2());
        int firstPositionInLine2 = firstPositionInLine;
        return position - firstPositionInLine2;
    }

    private void transpileEjsFile(Path ejsFile, Path tmpTranspileDir) {
        File sourceMapFile;
        String ejsFileName = this.projectPath().relativize(ejsFile).toString();
        String transpiledFileName = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ejsFileName), FileDefaults$.MODULE$.EJS_SUFFIX())).append(FileDefaults$.MODULE$.JS_SUFFIX()).toString();
        File transpiledFile = File$.MODULE$.apply(tmpTranspileDir).$div(transpiledFileName);
        Try try_ = Try$.MODULE$.apply(() -> this.transpileEjsFile$$anonfun$1(ejsFile, transpiledFile, sourceMapFile = File$.MODULE$.apply(tmpTranspileDir).$div(new StringBuilder(4).append(transpiledFileName).append(".map").toString())));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.debug(new StringBuilder(38).append("\t- could not transpile EJS template '").append(ejsFileName).append("'").toString(), exception);
        } else if (try_ instanceof Success) {
            this.logger.debug(new StringBuilder(35).append("\t+ transpiled EJS template '").append(ejsFileName).append("' to '").append(transpiledFile).append("'").toString());
        } else {
            throw new MatchError((Object)try_);
        }
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        this.ejsFiles().foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.transpileEjsFile((Path)_$1, tmpTranspileDir));
        this.logger.debug("\t+ EJS template transpiling finished.");
        return true;
    }

    @Override
    public boolean validEnvironment() {
        return true;
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(36).append("EJS - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }

    private final File transpileEjsFile$$anonfun$1(Path ejsFile$1, File transpiledFile$1, File sourceMapFile$1) {
        String ejsFileContent = FileUtils$.MODULE$.readLinesInFile(ejsFile$1).mkString("\n");
        Tuple2<SortedMap<Object, Object>, SortedMap<Object, Object>> tuple2 = FileUtils$.MODULE$.positionLookupTables(ejsFileContent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SortedMap positionToLineNumberMapping = (SortedMap)tuple2._1();
        SortedMap positionToFirstPositionInLineMapping = (SortedMap)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)positionToLineNumberMapping, (Object)positionToFirstPositionInLineMapping);
        SortedMap positionToLineNumberMapping2 = (SortedMap)tuple22._1();
        SortedMap positionToFirstPositionInLineMapping2 = (SortedMap)tuple22._2();
        Tuple2<String, WritableSourceMap> tuple23 = this.extractJsCode(ejsFileContent, (SortedMap<Object, Object>)positionToLineNumberMapping2, (SortedMap<Object, Object>)positionToFirstPositionInLineMapping2, ejsFile$1.toString());
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        String jsCode = (String)tuple23._1();
        WritableSourceMap sourceMap = (WritableSourceMap)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)jsCode, (Object)sourceMap);
        String jsCode2 = (String)tuple24._1();
        WritableSourceMap sourceMap2 = (WritableSourceMap)tuple24._2();
        File file = transpiledFile$1.parent();
        file.createDirectoryIfNotExists(true, file.createDirectoryIfNotExists$default$2(true), file.createDirectoryIfNotExists$default$3(true));
        File file2 = sourceMapFile$1.parent();
        file2.createDirectoryIfNotExists(true, file2.createDirectoryIfNotExists$default$2(true), file2.createDirectoryIfNotExists$default$3(true));
        transpiledFile$1.writeText(jsCode2, transpiledFile$1.writeText$default$2(jsCode2), transpiledFile$1.writeText$default$3(jsCode2));
        String string = sourceMap2.generate();
        return sourceMapFile$1.writeText(string, sourceMapFile$1.writeText$default$2(string), sourceMapFile$1.writeText$default$3(string));
    }
}

