/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File$;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class PugTranspiler
implements TranspilingEnvironment,
Transpiler {
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    private final Config config;
    private final Path projectPath;
    private final Logger logger;

    public PugTranspiler(Config config, Path projectPath) {
        this.config = config;
        this.projectPath = projectPath;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private boolean hasPugFiles() {
        return FileUtils$.MODULE$.getFileTree(this.projectPath(), this.config(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.PUG_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).nonEmpty();
    }

    @Override
    public boolean shouldRun() {
        return this.config().templateTranspiling() && this.hasPugFiles();
    }

    private boolean installPugPlugins() {
        boolean bl;
        String command = this.yarnAvailable() ? new StringBuilder(18).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" pug-cli --dev && ").append(TranspilingEnvironment$.MODULE$.YARN_INSTALL()).toString() : new StringBuilder(23).append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).append(" --save-dev pug-cli && ").append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).toString();
        this.logger.info("Installing Pug dependencies and plugins. That will take a while.");
        this.logger.debug(new StringBuilder(52).append("\t+ Installing Pug plugins with command '").append(command).append("' in path '").append(this.projectPath()).append("'").toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            this.logger.info("\t+ Pug plugins installed");
            bl = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.error("\t- Failed to install Pug plugins", exception);
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        if (this.installPugPlugins()) {
            String pug = Paths.get(this.projectPath().toString(), "node_modules", ".bin", "pug").toString();
            String command = new StringBuilder(29).append(ExternalCommand$.MODULE$.toOSCommand(pug)).append(" --client --no-debug --out ").append(tmpTranspileDir).append(" .").toString();
            this.logger.debug(new StringBuilder(36).append("\t+ transpiling Pug templates in ").append(this.projectPath()).append(" to ").append(tmpTranspileDir).toString());
            Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
            if (try_ instanceof Success) {
                this.logger.debug("\t+ transpiling Pug templates finished");
            } else if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.debug("\t- transpiling Pug templates failed", exception);
            } else {
                throw new MatchError(try_);
            }
        }
        return true;
    }

    @Override
    public boolean validEnvironment() {
        return this.valid();
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(36).append("PUG - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }
}

