/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File$;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilerGroup$;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class TranspilerGroup
implements TranspilingEnvironment,
Transpiler,
Product,
Serializable {
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    private final Config config;
    private final Path projectPath;
    private final Seq transpilers;
    private final Logger logger;
    private final String BABEL_PLUGINS;

    public static TranspilerGroup apply(Config config, Path path, Seq<Transpiler> seq) {
        return TranspilerGroup$.MODULE$.apply(config, path, seq);
    }

    public static TranspilerGroup fromProduct(Product product) {
        return TranspilerGroup$.MODULE$.fromProduct(product);
    }

    public static TranspilerGroup unapply(TranspilerGroup transpilerGroup) {
        return TranspilerGroup$.MODULE$.unapply(transpilerGroup);
    }

    public TranspilerGroup(Config config, Path projectPath, Seq<Transpiler> transpilers) {
        this.config = config;
        this.projectPath = projectPath;
        this.transpilers = transpilers;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.BABEL_PLUGINS = "@babel/core @babel/cli @babel/preset-env @babel/preset-flow @babel/preset-react @babel/preset-typescript @babel/plugin-proposal-class-properties @babel/plugin-proposal-private-methods @babel/plugin-proposal-object-rest-spread @babel/plugin-proposal-nullish-coalescing-operator @babel/plugin-transform-property-mutators";
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TranspilerGroup)) return false;
        TranspilerGroup transpilerGroup = (TranspilerGroup)object;
        Config config = this.config();
        Config config2 = transpilerGroup.config();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!((Object)config).equals(config2)) return false;
        Path path = this.projectPath();
        Path path2 = transpilerGroup.projectPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Seq<Transpiler> seq = this.transpilers();
        Seq<Transpiler> seq2 = transpilerGroup.transpilers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!transpilerGroup.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TranspilerGroup;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TranspilerGroup";
    }

    public Object productElement(int n) {
        Seq<Transpiler> seq;
        int n2 = n;
        switch (n2) {
            case 0: {
                seq = this._1();
                break;
            }
            case 1: {
                seq = this._2();
                break;
            }
            case 2: {
                seq = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return seq;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "config";
                break;
            }
            case 1: {
                string = "projectPath";
                break;
            }
            case 2: {
                string = "transpilers";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    public Seq<Transpiler> transpilers() {
        return this.transpilers;
    }

    private boolean installPlugins() {
        boolean bl;
        String command = this.yarnAvailable() ? new StringBuilder(14).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" ").append(this.BABEL_PLUGINS).append(" --dev -W && ").append(TranspilingEnvironment$.MODULE$.YARN_INSTALL()).toString() : new StringBuilder(16).append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).append(" --save-dev ").append(this.BABEL_PLUGINS).append(" && ").append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).toString();
        this.logger.info("Installing project dependencies and plugins. That will take a while.");
        this.logger.debug(new StringBuilder(48).append("\t+ Installing plugins with command '").append(command).append("' in path '").append(this.projectPath()).append("'").toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            this.logger.info("\t+ Plugins installed");
            bl = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.error("\t- Failed to install plugins", exception);
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    @Override
    public boolean shouldRun() {
        return this.transpilers().exists((Function1 & Serializable)_$1 -> _$1.shouldRun());
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        return this.installPlugins() ? ((SeqOps)this.transpilers().takeWhile((Function1 & Serializable)_$2 -> _$2.run(tmpTranspileDir))).length() == this.transpilers().length() : true;
    }

    @Override
    public boolean validEnvironment() {
        return this.transpilers().forall((Function1 & Serializable)_$3 -> _$3.validEnvironment());
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(38).append("Downloading / installing plugins in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }

    public TranspilerGroup copy(Config config, Path projectPath, Seq<Transpiler> transpilers) {
        return new TranspilerGroup(config, projectPath, transpilers);
    }

    public Config copy$default$1() {
        return this.config();
    }

    public Path copy$default$2() {
        return this.projectPath();
    }

    public Seq<Transpiler> copy$default$3() {
        return this.transpilers();
    }

    public Config _1() {
        return this.config();
    }

    public Path _2() {
        return this.projectPath();
    }

    public Seq<Transpiler> _3() {
        return this.transpilers();
    }
}

