/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.io;

import better.files.File;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.EmScriptenCleaner$;
import io.shiftleft.js2cpg.io.FileCollector;
import io.shiftleft.js2cpg.io.FileCollector$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils;
import io.shiftleft.js2cpg.io.FileUtils$FileStatistics$;
import io.shiftleft.js2cpg.io.PathFilter$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SortedMap;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class FileUtils$
implements Serializable {
    private static final Logger logger;
    private static final TrieMap<Path, String> excludedPaths;
    public static final FileUtils$FileStatistics$ FileStatistics;
    public static final FileUtils$ MODULE$;

    private FileUtils$() {
    }

    static {
        MODULE$ = new FileUtils$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        excludedPaths = TrieMap$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtils$.class);
    }

    public void logAndClearExcludedPaths() {
        excludedPaths.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            String reason = (String)tuple2._2();
            logger.debug(new StringBuilder(15).append("Excluded '").append(path).append("' (").append(reason).append(").").toString());
        });
        excludedPaths.clear();
    }

    /*
     * WARNING - void declaration
     */
    public String cleanPath(String sourceFileName) {
        void var3_3;
        String replacedDots = sourceFileName.replace("../", "").replace("\u0000", "");
        String replacedFile = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("file:///.:.*")).matches((CharSequence)replacedDots) ? replacedDots.replace("file:///", "") : replacedDots;
        return replacedFile.matches(".*\\.vue\\?.*$") ? replacedFile.substring(0, replacedFile.lastIndexOf(".vue") + 4) : var3_3;
    }

    public List<Path> getFileTree(Path rootPath, Config config, List<String> extensions, boolean filterIgnoredFiles) {
        FileCollector fileCollector = FileCollector$.MODULE$.apply(PathFilter$.MODULE$.apply(rootPath, config, filterIgnoredFiles, extensions, PathFilter$.MODULE$.$lessinit$greater$default$5()));
        Files.walkFileTree(rootPath, fileCollector);
        excludedPaths.addAll(fileCollector.excludedPaths());
        return fileCollector.files();
    }

    public boolean getFileTree$default$4() {
        return true;
    }

    private File copyTo(File from, File destination, Config config, Seq<CopyOption> copyOptions) {
        FileCollector fileCollector = FileCollector$.MODULE$.apply(PathFilter$.MODULE$.apply(from.path(), config, false, (List<String>)package$.MODULE$.List().empty(), config.withNodeModuleFolder()));
        Path path = from.isDirectory(from.isDirectory$default$1()) ? Files.walkFileTree(from.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(from, destination, copyOptions, fileCollector){
            private final File from$1;
            private final File destination$1;
            private final Seq copyOptions$1;
            private final FileCollector fileCollector$1;
            {
                this.from$1 = from$2;
                this.destination$1 = destination$2;
                this.copyOptions$1 = copyOptions$2;
                this.fileCollector$1 = fileCollector$2;
            }

            private Path newPath(Path subPath) {
                return this.destination$1.path().resolve(this.from$1.path().relativize(subPath));
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                FileVisitResult fileVisitResult;
                FileVisitResult fileVisitResult2 = this.fileCollector$1.preVisitDirectory(dir, attrs);
                FileVisitResult fileVisitResult3 = FileVisitResult.CONTINUE;
                FileVisitResult fileVisitResult4 = fileVisitResult2;
                if (!(fileVisitResult3 != null ? !((Object)((Object)fileVisitResult3)).equals((Object)((Object)fileVisitResult4)) : fileVisitResult4 != null)) {
                    FileVisitResult c = fileVisitResult2;
                    Files.createDirectories(this.newPath(dir), new FileAttribute[0]);
                    fileVisitResult = c;
                } else {
                    FileVisitResult other;
                    fileVisitResult = other = fileVisitResult2;
                }
                return fileVisitResult;
            }

            /*
             * WARNING - void declaration
             */
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                void var3_3;
                FileVisitResult result = this.fileCollector$1.visitFile(file, attrs);
                if (!this.fileCollector$1.wasExcluded(file)) {
                    Files.copy(file, this.newPath(file), (CopyOption[])Arrays$.MODULE$.seqToArray(this.copyOptions$1, CopyOption.class));
                }
                return var3_3;
            }
        }) : Files.copy(from.path(), destination.path(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class));
        excludedPaths.addAll(fileCollector.excludedPaths());
        return destination;
    }

    private Seq<CopyOption> copyTo$default$4(File from, File destination, Config config) {
        return File.CopyOptions$.MODULE$.apply(false);
    }

    public File copyToDirectory(File from, File directory, Config config, Seq<CopyOption> copyOptions) {
        return this.copyTo(from, directory.$div(from.name()), config, copyOptions);
    }

    public Seq<CopyOption> copyToDirectory$default$4(File from, File directory, Config config) {
        return File.CopyOptions$.MODULE$.default();
    }

    public Seq<String> readLinesInFile(Path path) {
        return EmScriptenCleaner$.MODULE$.clean((Seq<String>)IOUtils$.MODULE$.readLinesInFile(path));
    }

    public Map<Object, String> contentMapFromFile(Path path) {
        return ((IterableOnceOps)((IterableOps)this.readLinesInFile(path).zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            int lineNumber = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)lineNumber));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)line);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Tuple2<SortedMap<Object, Object>, SortedMap<Object, Object>> positionLookupTables(String source) {
        int position;
        TreeMap positionToLineNumber = TreeMap$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);
        TreeMap positionToFirstPositionInLine = TreeMap$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);
        char[] data = source.toCharArray();
        int lineNumber = 1;
        int firstPositionInLine = 0;
        for (position = 0; position < data.length; ++position) {
            boolean isNewLine;
            boolean bl = isNewLine = data[position] == '\n';
            if (!isNewLine) continue;
            positionToLineNumber.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)lineNumber));
            ++lineNumber;
            positionToFirstPositionInLine.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)firstPositionInLine));
            firstPositionInLine = position + 1;
        }
        positionToLineNumber.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)lineNumber));
        positionToFirstPositionInLine.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)firstPositionInLine));
        return Tuple2$.MODULE$.apply((Object)positionToLineNumber, (Object)positionToFirstPositionInLine);
    }

    public FileUtils.FileStatistics fileStatistics(Seq<String> lines) {
        LongRef linesOfCode = LongRef.create((long)0L);
        IntRef longestLineLength = IntRef.create((int)0);
        BooleanRef containsMarker = BooleanRef.create((boolean)false);
        lines.foreach((Function1)(JProcedure1 & Serializable)line -> {
            long l;
            int currLength = line.length();
            if (currLength > longestLineLength$1.elem) {
                int n;
                longestLineLength$1.elem = n = currLength;
            }
            if (!containsMarker$1.elem && FileDefaults$.MODULE$.EMSCRIPTEN_START_FUNCS().matches((CharSequence)line)) {
                boolean bl;
                containsMarker$1.elem = bl = true;
            }
            linesOfCode$1.elem = l = linesOfCode$1.elem + 1L;
        });
        return FileUtils$FileStatistics$.MODULE$.apply(linesOfCode.elem, longestLineLength.elem, containsMarker.elem);
    }
}

