/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.shiftleft.js2cpg.io.FileUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PackageJsonParser$
implements Serializable {
    private static final Logger logger;
    private static final String PACKAGE_JSON_FILENAME;
    private static final String JSON_LOCK_FILENAME;
    private static final String NPM_SHRINKWRAP_FILENAME;
    private static final String PNPM_WS_FILENAME;
    private static final String PNPM_LOCK_FILENAME;
    private static final String PNPM_LOCK_FILENAME_BAK;
    private static final String YARN_LOCK_FILENAME;
    private static final String YARN_LOCK_FILENAME_BAK;
    private static final String WEBPACK_CONFIG_FILENAME;
    private static final String BABEL_CONFIG_FILENAME;
    private static final List PROJECT_CONFIG_FILES;
    private static final Seq PROJECT_DEPENDENCIES;
    private static final TrieMap<Path, Map<String, String>> cachedDependencies;
    public static final PackageJsonParser$ MODULE$;

    private PackageJsonParser$() {
    }

    static {
        MODULE$ = new PackageJsonParser$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        PACKAGE_JSON_FILENAME = "package.json";
        JSON_LOCK_FILENAME = "package-lock.json";
        NPM_SHRINKWRAP_FILENAME = "npm-shrinkwrap.json";
        PNPM_WS_FILENAME = "pnpm-workspace.yaml";
        PNPM_LOCK_FILENAME = "pnpm-lock.yaml";
        PNPM_LOCK_FILENAME_BAK = "pnpm-lock.yaml.bak";
        YARN_LOCK_FILENAME = "yarn.lock";
        YARN_LOCK_FILENAME_BAK = "yarn.lock.bak";
        WEBPACK_CONFIG_FILENAME = "webpack.config.js";
        BABEL_CONFIG_FILENAME = "babel.config.js";
        PROJECT_CONFIG_FILES = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.JSON_LOCK_FILENAME(), MODULE$.YARN_LOCK_FILENAME(), MODULE$.PNPM_LOCK_FILENAME(), MODULE$.PNPM_WS_FILENAME(), MODULE$.NPM_SHRINKWRAP_FILENAME(), MODULE$.WEBPACK_CONFIG_FILENAME(), MODULE$.BABEL_CONFIG_FILENAME()}));
        PROJECT_DEPENDENCIES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dependencies", "devDependencies", "peerDependencies", "peerDependenciesMeta", "optionalDependencies", "resolutions", "bundledDependencies"}));
        cachedDependencies = TrieMap$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PackageJsonParser$.class);
    }

    public String PACKAGE_JSON_FILENAME() {
        return PACKAGE_JSON_FILENAME;
    }

    public String JSON_LOCK_FILENAME() {
        return JSON_LOCK_FILENAME;
    }

    public String NPM_SHRINKWRAP_FILENAME() {
        return NPM_SHRINKWRAP_FILENAME;
    }

    public String PNPM_WS_FILENAME() {
        return PNPM_WS_FILENAME;
    }

    public String PNPM_LOCK_FILENAME() {
        return PNPM_LOCK_FILENAME;
    }

    public String PNPM_LOCK_FILENAME_BAK() {
        return PNPM_LOCK_FILENAME_BAK;
    }

    public String YARN_LOCK_FILENAME() {
        return YARN_LOCK_FILENAME;
    }

    public String YARN_LOCK_FILENAME_BAK() {
        return YARN_LOCK_FILENAME_BAK;
    }

    public String WEBPACK_CONFIG_FILENAME() {
        return WEBPACK_CONFIG_FILENAME;
    }

    public String BABEL_CONFIG_FILENAME() {
        return BABEL_CONFIG_FILENAME;
    }

    public List<String> PROJECT_CONFIG_FILES() {
        return PROJECT_CONFIG_FILES;
    }

    public Seq<String> PROJECT_DEPENDENCIES() {
        return PROJECT_DEPENDENCIES;
    }

    public String removeComments(String json) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        return mapper.writeValueAsString((Object)mapper.readTree(json));
    }

    public boolean isValidProjectPackageJson(Path packageJsonPath) {
        boolean bl;
        if (packageJsonPath.toString().endsWith(this.PACKAGE_JSON_FILENAME())) {
            boolean bl2;
            Try try_ = Try$.MODULE$.apply(() -> this.$anonfun$1(packageJsonPath));
            if (try_ instanceof Success) {
                Seq content = (Seq)((Success)try_).value();
                bl2 = content.forall((Function1 & Serializable)l -> StringUtils.isNotBlank((String)StringUtils.normalizeSpace((String)l)));
            } else if (try_ instanceof Failure) {
                bl2 = false;
            } else {
                throw new MatchError((Object)try_);
            }
            boolean isNotEmpty = bl2;
            bl = isNotEmpty && this.dependencies(packageJsonPath).nonEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public Map<String, String> dependencies(Path packageJsonPath) {
        return (Map)cachedDependencies.getOrElseUpdate((Object)packageJsonPath, () -> this.dependencies$$anonfun$1(packageJsonPath));
    }

    private final Seq $anonfun$1(Path packageJsonPath$1) {
        return FileUtils$.MODULE$.readLinesInFile(packageJsonPath$1);
    }

    private final Iterator $anonfun$5() {
        return package$.MODULE$.Iterator().empty();
    }

    private final Map $anonfun$3(Path lockDepsPath$1) {
        String content = FileUtils$.MODULE$.readLinesInFile(lockDepsPath$1).mkString("\n");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode packageJson = objectMapper.readTree(content);
        ObjectRef depToVersion = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Iterator dependencyIt = (Iterator)Option$.MODULE$.apply((Object)packageJson.get("dependencies")).map((Function1 & Serializable)_$1 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$1.fields()).asScala()).getOrElse(this::$anonfun$5);
        dependencyIt.foreach((Function1)(JProcedure1 & Serializable)entry -> {
            String depName = (String)entry.getKey();
            JsonNode versionNode = ((JsonNode)entry.getValue()).get("version");
            if (versionNode != null) {
                Map map = (Map)((Map)depToVersion$1.elem).updated((Object)depName, (Object)versionNode.asText());
                depToVersion$1.elem = map;
                map = null;
            }
        });
        return (Map)depToVersion.elem;
    }

    private final Iterator $anonfun$7() {
        return package$.MODULE$.Iterator().empty();
    }

    private final Map deps$lzyINIT1$1$$anonfun$1(Path depsPath$2) {
        String content = FileUtils$.MODULE$.readLinesInFile(depsPath$2).mkString("\n");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode packageJson = objectMapper.readTree(content);
        ObjectRef depToVersion = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.PROJECT_DEPENDENCIES().foreach((Function1)(JProcedure1 & Serializable)dependency -> {
            Iterator dependencyIt = (Iterator)Option$.MODULE$.apply((Object)packageJson.get(dependency)).map((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$2.fields()).asScala()).getOrElse(this::$anonfun$7);
            dependencyIt.foreach((Function1)(JProcedure1 & Serializable)entry -> {
                Map map = (Map)((Map)depToVersion$3.elem).updated(entry.getKey(), (Object)((JsonNode)entry.getValue()).asText());
                depToVersion$3.elem = map;
                map = null;
            });
        });
        return (Map)depToVersion.elem;
    }

    private final Option deps$lzyINIT1$1(Path depsPath$1, LazyRef deps$lzy1$1) {
        Option option;
        LazyRef lazyRef = deps$lzy1$1;
        synchronized (lazyRef) {
            option = (Option)(deps$lzy1$1.initialized() ? deps$lzy1$1.value() : deps$lzy1$1.initialize((Object)Try$.MODULE$.apply(() -> this.deps$lzyINIT1$1$$anonfun$1(depsPath$1)).toOption()));
        }
        return option;
    }

    private final Option deps$1(Path depsPath$3, LazyRef deps$lzy1$2) {
        return (Option)(deps$lzy1$2.initialized() ? deps$lzy1$2.value() : this.deps$lzyINIT1$1(depsPath$3, deps$lzy1$2));
    }

    private final Map dependencies$$anonfun$1(Path packageJsonPath$2) {
        Map map;
        LazyRef lazyRef = new LazyRef();
        Path depsPath = packageJsonPath$2;
        Path lockDepsPath = packageJsonPath$2.resolveSibling(Paths.get(this.JSON_LOCK_FILENAME(), new String[0]));
        Option lockDeps = Try$.MODULE$.apply(() -> this.$anonfun$3(lockDepsPath)).toOption();
        if (lockDeps.isDefined() && ((IterableOnceOps)lockDeps.get()).nonEmpty()) {
            logger.debug(new StringBuilder(28).append("Loaded dependencies from '").append(lockDepsPath).append("'.").toString());
            map = (Map)lockDeps.get();
        } else if (this.deps$1(depsPath, lazyRef).isDefined() && ((IterableOnceOps)this.deps$1(depsPath, lazyRef).get()).nonEmpty()) {
            logger.debug(new StringBuilder(28).append("Loaded dependencies from '").append(depsPath).append("'.").toString());
            map = (Map)this.deps$1(depsPath, lazyRef).get();
        } else {
            logger.debug(new StringBuilder(44).append("No project dependencies found in ").append(this.PACKAGE_JSON_FILENAME()).append(" or ").append(this.JSON_LOCK_FILENAME()).append(" at '").append(depsPath.getParent()).append("'.").toString());
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }
}

