/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File$;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.preprocessing.BabelTranspiler;
import io.shiftleft.js2cpg.preprocessing.BabelTranspiler$;
import io.shiftleft.js2cpg.preprocessing.NuxtTranspiler$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class NuxtTranspiler
implements TranspilingEnvironment,
Transpiler {
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    private final Config config;
    private final Path projectPath;
    private final Logger logger;
    private final String nuxt;

    public static String NUXT_FOLDER() {
        return NuxtTranspiler$.MODULE$.NUXT_FOLDER();
    }

    public static List<Tuple2<Path, Path>> collectJsFiles(Path path, Config config) {
        return NuxtTranspiler$.MODULE$.collectJsFiles(path, config);
    }

    public static String remapPath(String string) {
        return NuxtTranspiler$.MODULE$.remapPath(string);
    }

    public NuxtTranspiler(Config config, Path projectPath) {
        this.config = config;
        this.projectPath = projectPath;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.nuxt = Paths.get(projectPath.toString(), "node_modules", ".bin", "nuxt").toString();
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private boolean isNuxtProject() {
        return PackageJsonParser$.MODULE$.dependencies(File$.MODULE$.apply(this.config().srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).$div(PackageJsonParser$.MODULE$.PACKAGE_JSON_FILENAME()).path()).contains((Object)"nuxt");
    }

    @Override
    public boolean shouldRun() {
        return this.config().nuxtTranspiling() && this.isNuxtProject();
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        String command = new StringBuilder(13).append(ExternalCommand$.MODULE$.toOSCommand(this.nuxt)).append(" --force-exit").toString();
        this.logger.debug(new StringBuilder(23).append("\t+ Nuxt.js transpiling ").append(this.projectPath()).toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            this.logger.debug("\t+ Nuxt.js transpiling finished");
            Some some = Some$.MODULE$.apply((Object)Paths.get(NuxtTranspiler$.MODULE$.NUXT_FOLDER(), new String[0]));
            Option<Path> option = BabelTranspiler$.MODULE$.$lessinit$greater$default$3();
            new BabelTranspiler(this.config(), this.projectPath(), option, (Option<Path>)some).run(this.projectPath().resolve(NuxtTranspiler$.MODULE$.NUXT_FOLDER()));
            NuxtTranspiler$.io$shiftleft$js2cpg$preprocessing$NuxtTranspiler$$$wasExecuted = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.debug("\t- Nuxt.js transpiling failed", exception);
        } else {
            throw new MatchError(try_);
        }
        return false;
    }

    @Override
    public boolean validEnvironment() {
        return this.valid(this.projectPath());
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(40).append("Nuxt.js - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }
}

