/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File;
import better.files.File$;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public interface TranspilingEnvironment {
    public static String ENV_PATH_CONTENT() {
        return TranspilingEnvironment$.MODULE$.ENV_PATH_CONTENT();
    }

    public static String NPM() {
        return TranspilingEnvironment$.MODULE$.NPM();
    }

    public static String NPM_INSTALL() {
        return TranspilingEnvironment$.MODULE$.NPM_INSTALL();
    }

    public static String PNPM() {
        return TranspilingEnvironment$.MODULE$.PNPM();
    }

    public static String PNPM_ADD() {
        return TranspilingEnvironment$.MODULE$.PNPM_ADD();
    }

    public static String PNPM_INSTALL() {
        return TranspilingEnvironment$.MODULE$.PNPM_INSTALL();
    }

    public static String YARN() {
        return TranspilingEnvironment$.MODULE$.YARN();
    }

    public static String YARN_ADD() {
        return TranspilingEnvironment$.MODULE$.YARN_ADD();
    }

    public static String YARN_INSTALL() {
        return TranspilingEnvironment$.MODULE$.YARN_INSTALL();
    }

    public static void $init$(TranspilingEnvironment $this) {
        $this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(LoggerFactory.getLogger($this.getClass()));
    }

    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger();

    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger var1);

    private boolean checkForPnpm() {
        boolean bl;
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Checking pnpm ...");
        Try<String> try_ = ExternalCommand$.MODULE$.run(new StringBuilder(3).append(TranspilingEnvironment$.MODULE$.PNPM()).append(" -v").toString(), ((Transpiler)this).projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            String result = (String)((Success)try_).value();
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug(new StringBuilder(22).append("\t+ pnpm is available: ").append(result).toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().error("\t- pnpm is not installed. Transpiling sources will not be available.");
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean checkForYarn() {
        boolean bl;
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Checking yarn ...");
        Try<String> try_ = ExternalCommand$.MODULE$.run(new StringBuilder(3).append(TranspilingEnvironment$.MODULE$.YARN()).append(" -v").toString(), ((Transpiler)this).projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            String result = (String)((Success)try_).value();
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug(new StringBuilder(22).append("\t+ yarn is available: ").append(result).toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().error("\t- yarn is not installed. Transpiling sources will not be available.");
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean checkForNpm() {
        boolean bl;
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Checking npm ...");
        Try<String> try_ = ExternalCommand$.MODULE$.run(new StringBuilder(3).append(TranspilingEnvironment$.MODULE$.NPM()).append(" -v").toString(), ((Transpiler)this).projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            String result = (String)((Success)try_).value();
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug(new StringBuilder(21).append("\t+ npm is available: ").append(result).toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().error("\t- npm is not installed. Transpiling sources will not be available.");
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean setNpmPython() {
        boolean bl;
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Setting npm config ...");
        Try<String> try_ = ExternalCommand$.MODULE$.run(new StringBuilder(28).append(TranspilingEnvironment$.MODULE$.NPM()).append(" config set python python2.7").toString(), ((Transpiler)this).projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Set successfully");
            bl = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t- Failed setting npm config", exception);
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    public static Option nodeVersion$(TranspilingEnvironment $this) {
        return $this.nodeVersion();
    }

    default public Option<String> nodeVersion() {
        None$ none$;
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug("\t+ Checking node ...");
        Try<String> try_ = ExternalCommand$.MODULE$.run("node -v", ((Transpiler)this).projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            String result = (String)((Success)try_).value();
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().debug(new StringBuilder(22).append("\t+ node is available: ").append(result).toString());
            none$ = Some$.MODULE$.apply((Object)result);
        } else if (try_ instanceof Failure) {
            this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger().error("\t- node is not installed.");
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(try_);
        }
        return none$;
    }

    public static boolean valid$(TranspilingEnvironment $this, Path dir) {
        return $this.valid(dir);
    }

    default public boolean valid(Path dir) {
        boolean bl;
        Option<Object> option = TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isValid;
        if (option instanceof Some) {
            boolean value;
            bl = value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            this.nodeVersion();
            TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isValid = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean(((this.pnpmAvailable(dir) || this.yarnAvailable() || this.npmAvailable()) && this.setNpmPython() ? 1 : 0) != 0));
            bl = BoxesRunTime.unboxToBoolean((Object)TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isValid.get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private boolean anyLockFileExists(Path dir, List<String> lockFiles) {
        return lockFiles.exists((Function1 & Serializable)f -> {
            File lockFile = File$.MODULE$.apply(dir).$div(f);
            return lockFile.exists(lockFile.exists$default$1());
        });
    }

    public static boolean pnpmAvailable$(TranspilingEnvironment $this, Path dir) {
        return $this.pnpmAvailable(dir);
    }

    default public boolean pnpmAvailable(Path dir) {
        boolean bl;
        Option<Object> option = TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isPnpmAvailable;
        if (option instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            boolean hasLockFile = this.anyLockFileExists(dir, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PackageJsonParser$.MODULE$.PNPM_LOCK_FILENAME_BAK(), PackageJsonParser$.MODULE$.PNPM_LOCK_FILENAME()}))));
            bl = value && hasLockFile;
        } else if (None$.MODULE$.equals(option)) {
            boolean hasLockFile = this.anyLockFileExists(dir, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PackageJsonParser$.MODULE$.PNPM_LOCK_FILENAME_BAK(), PackageJsonParser$.MODULE$.PNPM_LOCK_FILENAME()}))));
            TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isPnpmAvailable = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((hasLockFile && this.checkForPnpm() ? 1 : 0) != 0));
            bl = BoxesRunTime.unboxToBoolean((Object)TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isPnpmAvailable.get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static boolean yarnAvailable$(TranspilingEnvironment $this) {
        return $this.yarnAvailable();
    }

    default public boolean yarnAvailable() {
        boolean bl;
        Option<Object> option = TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isYarnAvailable;
        if (option instanceof Some) {
            boolean value;
            bl = value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            boolean hasLockFile = this.anyLockFileExists(((Transpiler)this).projectPath(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PackageJsonParser$.MODULE$.YARN_LOCK_FILENAME_BAK(), PackageJsonParser$.MODULE$.YARN_LOCK_FILENAME()}))));
            TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isYarnAvailable = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((hasLockFile && this.checkForYarn() ? 1 : 0) != 0));
            bl = BoxesRunTime.unboxToBoolean((Object)TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isYarnAvailable.get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static boolean npmAvailable$(TranspilingEnvironment $this) {
        return $this.npmAvailable();
    }

    default public boolean npmAvailable() {
        boolean bl;
        Option<Object> option = TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isNpmAvailable;
        if (option instanceof Some) {
            boolean value;
            bl = value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isNpmAvailable = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForNpm()));
            bl = BoxesRunTime.unboxToBoolean((Object)TranspilingEnvironment$.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$$isNpmAvailable.get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }
}

