/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.parser.TsConfigJsonParser$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import io.shiftleft.js2cpg.preprocessing.TypescriptTranspiler$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class TypescriptTranspiler
implements TranspilingEnvironment,
Transpiler {
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    private final Config config;
    private final Path projectPath;
    private final Option<Path> subDir;
    private final Logger logger;
    private final Map<String, String> NODE_OPTIONS;
    private final String tsc;

    public static String COMMONJS() {
        return TypescriptTranspiler$.MODULE$.COMMONJS();
    }

    public static String DEFAULT_MODULE() {
        return TypescriptTranspiler$.MODULE$.DEFAULT_MODULE();
    }

    public static String ES2020() {
        return TypescriptTranspiler$.MODULE$.ES2020();
    }

    public static String ESNEXT() {
        return TypescriptTranspiler$.MODULE$.ESNEXT();
    }

    public static Option<Path> $lessinit$greater$default$3() {
        return TypescriptTranspiler$.MODULE$.$lessinit$greater$default$3();
    }

    public TypescriptTranspiler(Config config, Path projectPath, Option<Path> subDir) {
        this.config = config;
        this.projectPath = projectPath;
        this.subDir = subDir;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"NODE_OPTIONS");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"--max_old_space_size=4096");
        this.NODE_OPTIONS = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.tsc = Paths.get(projectPath.toString(), "node_modules", ".bin", "tsc").toString();
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private boolean hasTsFiles() {
        return FileUtils$.MODULE$.getFileTree(this.projectPath(), this.config(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.TS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).nonEmpty();
    }

    @Override
    public boolean shouldRun() {
        better.files.File file;
        return this.config().tsTranspiling() && (file = File$.MODULE$.apply(this.projectPath()).$div("tsconfig.json")).exists(file.exists$default$1()) && this.hasTsFiles();
    }

    private void moveIgnoredDirs(better.files.File from, better.files.File to) {
        List ignores = this.config().ignoreTests() ? (List)this.DEFAULT_IGNORED_DIRS().$plus$plus((IterableOnce)this.DEFAULT_IGNORED_TEST_DIRS()) : this.DEFAULT_IGNORED_DIRS();
        ignores.foreach((Function1)(JProcedure1 & Serializable)dir -> {
            better.files.File ignoredDir = from.$div(dir);
            if (ignoredDir.isDirectory(ignoredDir.isDirectory$default$1())) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    TypescriptTranspiler.moveIgnoredDirs$$anonfun$1$$anonfun$1(to, dir, ignoredDir);
                    return BoxedUnit.UNIT;
                });
                if (try_ instanceof Failure) {
                    Throwable exception = ((Failure)try_).exception();
                    this.logger.debug(new StringBuilder(105).append("Could not move '").append(ignoredDir).append("' to '").append(to).append("' during Typescript transpilation!").append(" Please check the permissions for that directory.").toString(), exception);
                } else if (!(try_ instanceof Success)) {
                    throw new MatchError((Object)try_);
                }
            }
        });
    }

    private Try<better.files.File> createCustomTsConfigFile() {
        Path customTsConfigFilePath = File$.MODULE$.apply(this.projectPath()).$div("tsconfig.json").path();
        return Try$.MODULE$.apply(() -> this.createCustomTsConfigFile$$anonfun$1(customTsConfigFilePath));
    }

    private boolean installTsPlugins() {
        boolean bl;
        String command = this.pnpmAvailable(this.projectPath()) ? new StringBuilder(11).append(TranspilingEnvironment$.MODULE$.PNPM_ADD()).append(" typescript").toString() : (this.yarnAvailable() ? (this.logger.isDebugEnabled() ? new StringBuilder(14).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" -v typescript").toString() : new StringBuilder(11).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" typescript").toString()) : new StringBuilder(11).append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).append(" typescript").toString());
        this.logger.info("Installing TypeScript dependencies and plugins. That will take a while.");
        this.logger.debug(new StringBuilder(59).append("\t+ Installing Typescript plugins with command '").append(command).append("' in path '").append(this.projectPath()).append("'").toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), this.NODE_OPTIONS);
        if (try_ instanceof Success) {
            this.logger.info("\t+ TypeScript plugins installed");
            bl = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("\t- Failed to install TypeScript plugins", exception);
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean isCleanTrace(Throwable exception) {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(exception.getMessage())).forall((Function1 & Serializable)l -> TypescriptTranspiler$.io$shiftleft$js2cpg$preprocessing$TypescriptTranspiler$$$tscTypingWarnings.exists((Function1 & Serializable)x$0 -> l.contains((CharSequence)x$0)));
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        if (this.installTsPlugins()) {
            File$.MODULE$.usingTemporaryDirectory(File$.MODULE$.usingTemporaryDirectory$default$1(), File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)tmpForIgnoredDirs -> {
                this.moveIgnoredDirs(File$.MODULE$.apply(this.projectPath()), (better.files.File)tmpForIgnoredDirs);
                boolean isSolutionTsConfig = TsConfigJsonParser$.MODULE$.isSolutionTsConfig(this.projectPath(), this.tsc);
                List<String> projects = isSolutionTsConfig ? TsConfigJsonParser$.MODULE$.subprojects(this.projectPath(), this.tsc) : package$.MODULE$.Nil().$colon$colon((Object)"");
                String module = (String)this.config().moduleMode().getOrElse(this::$anonfun$1);
                better.files.File outDir = (better.files.File)this.subDir.map((Function1 & Serializable)s -> File$.MODULE$.apply(tmpTranspileDir.toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s.toString()}))).getOrElse(() -> TypescriptTranspiler.$anonfun$3(tmpTranspileDir));
                projects.foreach((Function1)(JProcedure1 & Serializable)proj -> {
                    String string;
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(proj))) {
                        string = new StringBuilder(10).append("--project ").append((String)proj).toString();
                    } else {
                        Try<better.files.File> try_ = this.createCustomTsConfigFile();
                        if (try_ instanceof Failure) {
                            Throwable f = ((Failure)try_).exception();
                            this.logger.debug("\t- Creating a custom TS config failed", f);
                            string = "";
                        } else if (try_ instanceof Success) {
                            better.files.File customTsConfigFile = (better.files.File)((Success)try_).value();
                            string = new StringBuilder(10).append("--project ").append(customTsConfigFile).toString();
                        } else {
                            throw new MatchError(try_);
                        }
                    }
                    String projCommand = string;
                    better.files.File projOutDir = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(proj)) ? outDir.$div(proj.substring(0, proj.lastIndexOf("/"))) : outDir;
                    String sourceRoot = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(proj)) ? new StringBuilder(13).append("--sourceRoot ").append(File$.MODULE$.apply(this.projectPath()).$div(proj.substring(0, proj.lastIndexOf("/")))).toString() : "";
                    String command = new StringBuilder(79).append(ExternalCommand$.MODULE$.toOSCommand(this.tsc)).append(" --skipLibCheck -sourcemap ").append(sourceRoot).append(" --outDir ").append(projOutDir).append(" -t ES2017 -m ").append(module).append(" --jsx react --noEmit false ").append(projCommand).toString();
                    this.logger.debug(new StringBuilder(52).append("\t+ TypeScript compiling ").append(this.projectPath()).append(" ").append(projCommand).append(" to ").append(projOutDir).append(" (using ").append(module).append(" style modules)").toString());
                    Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), this.NODE_OPTIONS);
                    if (try_ instanceof Success) {
                        this.logger.debug("\t+ TypeScript compiling finished");
                    } else if (try_ instanceof Failure) {
                        Throwable throwable = ((Failure)try_).exception();
                        Throwable exception = throwable;
                        if (this.isCleanTrace(exception)) {
                            this.logger.debug("\t+ TypeScript compiling finished");
                        } else {
                            Throwable exception2 = throwable;
                            this.logger.debug(new StringBuilder(32).append("\t- TypeScript compiling failed: ").append(exception2).toString());
                        }
                    } else {
                        throw new MatchError(try_);
                    }
                });
                this.moveIgnoredDirs((better.files.File)tmpForIgnoredDirs, File$.MODULE$.apply(this.projectPath()));
            });
        }
        return true;
    }

    @Override
    public boolean validEnvironment() {
        return this.valid(this.projectPath());
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(43).append("TypeScript - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }

    private static final void moveIgnoredDirs$$anonfun$1$$anonfun$1(better.files.File to$2, String dir$1, better.files.File ignoredDir$1) {
        FileUtils.moveDirectory((File)ignoredDir$1.toJava(), (File)to$2.$div(dir$1).toJava());
    }

    private final better.files.File createCustomTsConfigFile$$anonfun$1(Path customTsConfigFilePath$1) {
        String content = FileUtils$.MODULE$.readLinesInFile(customTsConfigFilePath$1).mkString("\n");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(PackageJsonParser$.MODULE$.removeComments(content));
        Option$.MODULE$.apply((Object)json.get("compilerOptions")).foreach((Function1 & Serializable)options -> {
            ((ObjectNode)options).remove("sourceRoot");
            ((ObjectNode)options).putArray("types");
            return ((ObjectNode)options).putArray("typeRoots");
        });
        ((ObjectNode)json).putArray("include").add("**/*");
        Some some = Some$.MODULE$.apply((Object)File$.MODULE$.apply(this.projectPath()));
        better.files.File file = File$.MODULE$.newTemporaryFile("js2cpgTsConfig", ".json", (Option)some, File$.MODULE$.newTemporaryFile$default$4("js2cpgTsConfig", ".json", (Option)some));
        better.files.File customTsConfigFile = file.deleteOnExit(true, file.deleteOnExit$default$2());
        String string = mapper.writeValueAsString((Object)json);
        return customTsConfigFile.writeText(string, customTsConfigFile.writeText$default$2(string), customTsConfigFile.writeText$default$3(string));
    }

    private final String $anonfun$1() {
        return TsConfigJsonParser$.MODULE$.module(this.projectPath(), this.tsc);
    }

    private static final better.files.File $anonfun$3(Path tmpTranspileDir$3) {
        return File$.MODULE$.apply(tmpTranspileDir$3);
    }
}

