/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File;
import better.files.File$;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import io.shiftleft.js2cpg.preprocessing.VueTranspiler$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VueTranspiler
implements TranspilingEnvironment,
Transpiler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(VueTranspiler.class, "0bitmap$1");
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    public long 0bitmap$1;
    private final Config config;
    private final Path projectPath;
    private final Logger logger;
    private Map NODE_OPTIONS$lzy1;
    private final String vue;

    public static boolean isVueProject(Config config, Path path) {
        return VueTranspiler$.MODULE$.isVueProject(config, path);
    }

    public VueTranspiler(Config config, Path projectPath) {
        this.config = config;
        this.projectPath = projectPath;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.vue = Paths.get(projectPath.toString(), "node_modules", ".bin", "vue-cli-service").toString();
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private Map<String, String> NODE_OPTIONS() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Map<String, String> map;
                    this.NODE_OPTIONS$lzy1 = map = this.nodeOptions();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return map;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.NODE_OPTIONS$lzy1;
    }

    @Override
    public boolean shouldRun() {
        return this.config().vueTranspiling() && VueTranspiler$.MODULE$.isVueProject(this.config(), this.projectPath());
    }

    private Map<String, String> nodeOptions() {
        Map map;
        if (this.nodeVersion().exists((Function1 & Serializable)_$1 -> _$1.startsWith("v17"))) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"NODE_OPTIONS");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"--openssl-legacy-provider");
            map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    private boolean installVuePlugins() {
        boolean bl;
        String command = this.pnpmAvailable(this.projectPath()) ? new StringBuilder(28).append(TranspilingEnvironment$.MODULE$.PNPM_ADD()).append(" @vue/cli-service-global && ").append(TranspilingEnvironment$.MODULE$.PNPM_INSTALL()).toString() : (this.yarnAvailable() ? new StringBuilder(28).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" @vue/cli-service-global && ").append(TranspilingEnvironment$.MODULE$.YARN_INSTALL()).toString() : new StringBuilder(28).append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).append(" @vue/cli-service-global && ").append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).toString());
        this.logger.info("Installing Vue.js dependencies and plugins. That will take a while.");
        this.logger.debug(new StringBuilder(55).append("\t+ Installing Vue.js plugins with command '").append(command).append("' in path '").append(this.projectPath()).append("'").toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), this.NODE_OPTIONS());
        if (try_ instanceof Success) {
            this.logger.info("\t+ Vue.js plugins installed");
            bl = true;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("\t- Failed to install Vue.js plugins", exception);
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private void createCustomBrowserslistFile() {
        File browserslistFile = File$.MODULE$.apply(this.projectPath()).$div(".browserslistrc");
        if (browserslistFile.exists(browserslistFile.exists$default$1())) {
            browserslistFile.delete(true, browserslistFile.delete$default$2());
        }
        Some some = Some$.MODULE$.apply((Object)File$.MODULE$.apply(this.projectPath()));
        String string = File$.MODULE$.newTemporaryFile$default$2();
        File file = File$.MODULE$.newTemporaryFile(".browserslistrc", string, (Option)some, File$.MODULE$.newTemporaryFile$default$4(".browserslistrc", string, (Option)some));
        File customBrowserslistFile = file.deleteOnExit(true, file.deleteOnExit$default$2());
        customBrowserslistFile.writeText("last 2 years", customBrowserslistFile.writeText$default$2("last 2 years"), customBrowserslistFile.writeText$default$3("last 2 years"));
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        if (this.installVuePlugins()) {
            this.createCustomBrowserslistFile();
            String command = new StringBuilder(44).append(ExternalCommand$.MODULE$.toOSCommand(this.vue)).append(" build --dest ").append(tmpTranspileDir).append(" --mode development --no-clean").toString();
            this.logger.debug(new StringBuilder(26).append("\t+ Vue.js transpiling ").append(this.projectPath()).append(" to ").append(tmpTranspileDir).toString());
            Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), this.NODE_OPTIONS());
            if (try_ instanceof Success) {
                this.logger.debug("\t+ Vue.js transpiling finished");
            } else if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.debug("\t- Vue.js transpiling failed", exception);
            } else {
                throw new MatchError(try_);
            }
        }
        return true;
    }

    @Override
    public boolean validEnvironment() {
        return this.valid(this.projectPath());
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(39).append("Vue.js - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }
}

