/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.util;

import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.util.JmxClient;
import io.shiftleft.js2cpg.util.MemoryMetrics$;
import java.io.Serializable;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public final class MemoryMetrics {
    public static void withMemoryMetrics(Config config, Function0<BoxedUnit> function0) {
        MemoryMetrics$.MODULE$.withMemoryMetrics(config, function0);
    }

    public static class JmxRunnable
    extends JmxClient
    implements Runnable,
    AutoCloseable {
        private int port;
        private int sleep;
        private final Logger logger;
        private final int MB;
        private boolean running;

        public JmxRunnable(int port, int sleep) {
            this.port = port;
            this.sleep = sleep;
            this.logger = LoggerFactory.getLogger(JmxRunnable.class);
            this.MB = 0x100000;
            this.running = false;
        }

        public int port() {
            return this.port;
        }

        public void port_$eq(int x$1) {
            this.port = x$1;
        }

        public int sleep() {
            return this.sleep;
        }

        public void sleep_$eq(int x$1) {
            this.sleep = x$1;
        }

        @Override
        public void run() {
            Option<JMXConnector> optJmx = this.init(this.port(), 20);
            if (optJmx.isDefined()) {
                this.running = true;
                this.logger.info("Enabling JVM metrics logging");
                while (this.running) {
                    this.memoryMetric(optJmx).foreach((Function1)(JProcedure1 & Serializable)value -> this.logger.debug(new StringBuilder(31).append("Memory used/committed (MB): ").append(value.usedMem() / (long)this.MB).append(" / ").append(value.committedMem() / (long)this.MB).toString()));
                    this.gcMetric(optJmx).foreach((Function1)(JProcedure1 & Serializable)value -> this.logger.debug(new StringBuilder(78).append("GC: Parallel count - ").append(value.parCollectionCount()).append(", Parallel time - ").append(value.parCollectionTime()).append("Concurrent count - ").append(value.conCollectionCount()).append(", Concurrent time - ").append(value.conCollectionCount()).toString()));
                    this.cpuMetric(optJmx).foreach((Function1)(JProcedure1 & Serializable)value -> this.logger.debug(new StringBuilder(20).append("CPU: Thread count - ").append(value.threadCount()).toString()));
                    try {
                        Thread.sleep(this.sleep());
                    }
                    catch (InterruptedException interruptedException) {
                        this.running = false;
                    }
                }
            }
        }

        @Override
        public void close() {
            this.running = false;
        }
    }
}

