/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.datastructures.scope;

import io.shiftleft.codepropertygraph.generated.nodes.NewNode;
import io.shiftleft.js2cpg.datastructures.scope.BlockScopeElement;
import io.shiftleft.js2cpg.datastructures.scope.MethodScope$;
import io.shiftleft.js2cpg.datastructures.scope.MethodScopeElement;
import io.shiftleft.js2cpg.datastructures.scope.PendingReference;
import io.shiftleft.js2cpg.datastructures.scope.PendingReference$;
import io.shiftleft.js2cpg.datastructures.scope.ResolvedReference;
import io.shiftleft.js2cpg.datastructures.scope.ScopeElement;
import io.shiftleft.js2cpg.datastructures.scope.ScopeElementIterator;
import io.shiftleft.js2cpg.datastructures.scope.ScopeType;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;

public class Scope {
    private final Buffer<PendingReference> pendingReferences = ListBuffer$.MODULE$.empty();
    private Option<ScopeElement> stack = Option$.MODULE$.empty();

    public Option<ScopeElement> getScopeHead() {
        return this.stack;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void pushNewMethodScope(String methodFullName, String name, NewNode scopeNode, Option<NewNode> capturingRefId) {
        this.stack = Some$.MODULE$.apply((Object)new MethodScopeElement(methodFullName, capturingRefId, name, scopeNode, this.stack));
    }

    public void pushNewBlockScope(NewNode scopeNode) {
        Option<ScopeElement> option = this.peek();
        if (option instanceof Some) {
            ScopeElement stackTop = (ScopeElement)((Some)option).value();
            this.stack = Some$.MODULE$.apply((Object)new BlockScopeElement(BoxesRunTime.boxToInteger((int)stackTop.subScopeCounter()).toString(), scopeNode, this.stack));
            stackTop.subScopeCounter_$eq(stackTop.subScopeCounter() + 1);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.stack = Some$.MODULE$.apply((Object)new BlockScopeElement("0", scopeNode, this.stack));
            return;
        }
        throw new MatchError(option);
    }

    private Option<ScopeElement> peek() {
        return this.stack;
    }

    public void popScope() {
        this.stack = ((ScopeElement)this.stack.get()).surroundingScope();
    }

    public void addVariable(String variableName, NewNode variableNode, ScopeType scopeType) {
        this.addVariable(this.stack, variableName, variableNode, scopeType);
    }

    public void addVariableReference(String variableName, NewNode referenceNode) {
        this.pendingReferences.prepend((Object)PendingReference$.MODULE$.apply(variableName, referenceNode, this.stack));
    }

    private NewNode getEnclosingMethodScope(Option<ScopeElement> scopeHead) {
        return (NewNode)new ScopeElementIterator(scopeHead).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ScopeElement x) {
                ScopeElement scopeElement = x;
                if (scopeElement instanceof MethodScopeElement) {
                    MethodScopeElement methodScopeElement = (MethodScopeElement)scopeElement;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ScopeElement x, Function1 function1) {
                ScopeElement scopeElement = x;
                if (scopeElement instanceof MethodScopeElement) {
                    MethodScopeElement methodScopeElement = (MethodScopeElement)scopeElement;
                    return methodScopeElement.scopeNode();
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(Scope::getEnclosingMethodScope$$anonfun$1);
    }

    public Iterator<ResolvedReference> resolve(Function2<NewNode, String, Tuple2<NewNode, ScopeType>> unresolvedHandler) {
        return this.pendingReferences.iterator().map((Function1 & Serializable)pendingReference -> {
            Option<ResolvedReference> resolvedReferenceOption = pendingReference.tryResolve();
            return (ResolvedReference)resolvedReferenceOption.getOrElse(() -> this.resolve$$anonfun$1$$anonfun$1(unresolvedHandler, pendingReference));
        });
    }

    private void addVariable(Option<ScopeElement> stack, String variableName, NewNode variableNode, ScopeType scopeType) {
        ScopeType scopeType2 = scopeType;
        ScopeElement scopeToAddTo = MethodScope$.MODULE$.equals(scopeType2) ? (ScopeElement)new ScopeElementIterator(stack).find((Function1 & Serializable)_$1 -> _$1 instanceof MethodScopeElement).get() : (ScopeElement)stack.get();
        scopeToAddTo.addVariable(variableName, variableNode);
    }

    private static final NewNode getEnclosingMethodScope$$anonfun$1() {
        throw new RuntimeException("Cannot find method scope.");
    }

    private final ResolvedReference resolve$$anonfun$1$$anonfun$1(Function2 unresolvedHandler$1, PendingReference pendingReference$1) {
        NewNode methodScopeNodeId = this.getEnclosingMethodScope(pendingReference$1.stack());
        Tuple2 tuple2 = (Tuple2)unresolvedHandler$1.apply((Object)methodScopeNodeId, (Object)pendingReference$1.variableName());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NewNode newVariableNode = (NewNode)tuple2._1();
        ScopeType scopeType = (ScopeType)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newVariableNode, (Object)scopeType);
        NewNode newVariableNode2 = (NewNode)tuple22._1();
        ScopeType scopeType2 = (ScopeType)tuple22._2();
        this.addVariable(pendingReference$1.stack(), pendingReference$1.variableName(), newVariableNode2, scopeType2);
        return (ResolvedReference)pendingReference$1.tryResolve().get();
    }
}

