/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.io;

import io.shiftleft.js2cpg.io.Accepted;
import io.shiftleft.js2cpg.io.Accepted$;
import io.shiftleft.js2cpg.io.FileCollector$;
import io.shiftleft.js2cpg.io.FilterResult;
import io.shiftleft.js2cpg.io.NotValid;
import io.shiftleft.js2cpg.io.NotValid$;
import io.shiftleft.js2cpg.io.PathFilter;
import io.shiftleft.js2cpg.io.Rejected;
import io.shiftleft.js2cpg.io.Rejected$;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;

public class FileCollector
extends SimpleFileVisitor<Path> {
    private final PathFilter pathFilter;
    private final ArrayBuffer<Path> result;
    private final Map<Path, String> excluded;

    public static FileCollector apply(PathFilter pathFilter) {
        return FileCollector$.MODULE$.apply(pathFilter);
    }

    public FileCollector(PathFilter pathFilter) {
        this.pathFilter = pathFilter;
        this.result = ArrayBuffer$.MODULE$.empty();
        this.excluded = HashMap$.MODULE$.empty();
    }

    public List<Path> files() {
        return package$.MODULE$.List().from(this.result);
    }

    public scala.collection.immutable.Map<Path, String> excludedPaths() {
        return Predef$.MODULE$.Map().from(this.excluded);
    }

    public boolean wasExcluded(Path path) {
        return this.excluded.contains((Object)this.pathFilter.rootPath().relativize(path));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
        FilterResult filterResult = this.pathFilter.apply(path);
        if (filterResult instanceof Accepted && Accepted$.MODULE$.unapply((Accepted)filterResult)) {
            return FileVisitResult.CONTINUE;
        }
        if (filterResult instanceof Rejected) {
            Rejected rejected = Rejected$.MODULE$.unapply((Rejected)filterResult);
            Path path2 = rejected._1();
            String string = rejected._2();
            Path path3 = path2;
            String reason = string;
            this.excluded.update((Object)path3, (Object)reason);
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (filterResult instanceof NotValid && NotValid$.MODULE$.unapply((NotValid)filterResult)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        throw new MatchError((Object)filterResult);
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        ArrayBuffer arrayBuffer;
        FilterResult filterResult = this.pathFilter.apply(path);
        if (filterResult instanceof Accepted && Accepted$.MODULE$.unapply((Accepted)filterResult)) {
            arrayBuffer = this.result.addOne((Object)path);
        } else if (filterResult instanceof Rejected) {
            Rejected rejected = Rejected$.MODULE$.unapply((Rejected)filterResult);
            Path path2 = rejected._1();
            String string = rejected._2();
            Path path3 = path2;
            String reason = string;
            this.excluded.update((Object)path3, (Object)reason);
            arrayBuffer = BoxedUnit.UNIT;
        } else if (filterResult instanceof NotValid && NotValid$.MODULE$.unapply((NotValid)filterResult)) {
            arrayBuffer = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)filterResult);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        IOException iOException = exc;
        if (iOException instanceof FileSystemLoopException) {
            FileSystemLoopException loop = (FileSystemLoopException)iOException;
            FileCollector$.io$shiftleft$js2cpg$io$FileCollector$$$logger.debug(new StringBuilder(41).append("Cyclic symbolic link detected for file '").append(file).append("'").toString(), (Throwable)loop);
        } else {
            FileCollector$.io$shiftleft$js2cpg$io$FileCollector$$$logger.debug(new StringBuilder(23).append("Unable to visit file '").append(file).append("'").toString(), (Throwable)exc);
        }
        return FileVisitResult.CONTINUE;
    }
}

