/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.preprocessing.TypescriptTranspiler$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class FreshJsonParser$
implements Serializable {
    private static final Logger logger;
    private static final TrieMap<Path, Map<String, String>> cachedDependencies;
    public static final FreshJsonParser$ MODULE$;

    private FreshJsonParser$() {
    }

    static {
        MODULE$ = new FreshJsonParser$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        cachedDependencies = TrieMap$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FreshJsonParser$.class);
    }

    private String dropLastSlash(String str) {
        String string = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(str), 1);
        if ("/".equals(string)) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(str), 1);
        }
        return str;
    }

    private String cleanKey(String key) {
        return this.dropLastSlash(key).replaceFirst("\\$", "");
    }

    private String extractVersion(String str) {
        String dropped = this.dropLastSlash(str.replace("mod.ts", ""));
        return dropped.substring(dropped.lastIndexOf("@") + 1, dropped.length());
    }

    public Set<Path> findImportMapPaths(Config config, boolean includeDenoConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        return FileUtils$.MODULE$.getFileTree(Paths.get(config.srcDir(), new String[0]), config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}))), FileUtils$.MODULE$.getFileTree$default$4()).filter((Function1 & Serializable)_$1 -> _$1.endsWith(TypescriptTranspiler$.MODULE$.DENO_CONFIG())).flatMap((Function1 & Serializable)file -> {
            JsonNode packageJson = objectMapper.readTree(Files.readAllBytes(file));
            Option importMap = Option$.MODULE$.apply((Object)packageJson.path("importMap").asText()).map((Function1 & Serializable)x$0 -> file.resolveSibling((String)x$0));
            if (includeDenoConfig) {
                return (IterableOnce)((IterableOps)package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{file}))).$plus$plus((IterableOnce)importMap);
            }
            return importMap;
        }).filter((Function1 & Serializable)_$2 -> Files.exists(_$2, new LinkOption[0])).toSet();
    }

    public Map<String, String> dependencies(Path freshJsonPath) {
        return (Map)cachedDependencies.getOrElseUpdate((Object)freshJsonPath, () -> this.dependencies$$anonfun$1(freshJsonPath));
    }

    private final Iterator $anonfun$4() {
        return package$.MODULE$.Iterator().empty();
    }

    private final Map $anonfun$2(Path freshJsonPath$2) {
        String content = FileUtils$.MODULE$.readLinesInFile(freshJsonPath$2).mkString("\n");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode json = objectMapper.readTree(content);
        ObjectRef depToVersion = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Iterator dependencyIt = (Iterator)Option$.MODULE$.apply((Object)json.get("imports")).map((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$3.fields()).asScala()).getOrElse(this::$anonfun$4);
        dependencyIt.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Map.Entry entry = x$1;
            Map.Entry entry2 = entry;
            if (((String)entry2.getKey()).startsWith("@")) {
                return;
            }
            Map.Entry entry3 = entry;
            Map map = (Map)((Map)depToVersion$1.elem).updated((Object)this.cleanKey((String)entry3.getKey()), (Object)this.extractVersion(((JsonNode)entry3.getValue()).asText()));
            depToVersion$1.elem = map;
            map = null;
        });
        return (Map)depToVersion.elem;
    }

    private final Map dependencies$$anonfun$1(Path freshJsonPath$1) {
        Option deps = Try$.MODULE$.apply(() -> this.$anonfun$2(freshJsonPath$1)).toOption();
        if (deps.isDefined()) {
            logger.debug(new StringBuilder(28).append("Loaded dependencies from '").append(freshJsonPath$1).append("'.").toString());
            return (Map)deps.get();
        }
        logger.debug(new StringBuilder(40).append("No project dependencies found in ").append(freshJsonPath$1.getFileName()).append(" at '").append(freshJsonPath$1.getParent()).append("'.").toString());
        return Predef$.MODULE$.Map().empty();
    }
}

